/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import spoon.reflect.declaration.CtCompilationUnit;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.path.CtRole;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.chain.CtScannerListener;
import spoon.reflect.visitor.chain.ScanningMode;

public class EarlyTerminatingScanner<T>
extends CtScanner {
    private boolean terminate = false;
    private T result;
    private CtScannerListener listener;
    protected CtRole scannedRole;
    private boolean visitCompilationUnitContent = false;

    protected void terminate() {
        this.terminate = true;
    }

    protected boolean isTerminated() {
        return this.terminate;
    }

    protected void setResult(T result) {
        this.result = result;
    }

    public T getResult() {
        return this.result;
    }

    public CtScannerListener getListener() {
        return this.listener;
    }

    public EarlyTerminatingScanner<T> setListener(CtScannerListener listener) {
        this.listener = listener;
        return this;
    }

    @Override
    public void scan(CtRole role, Collection<? extends CtElement> elements) {
        if (this.isTerminated() || elements == null) {
            return;
        }
        for (CtElement ctElement : new ArrayList<CtElement>(elements)) {
            this.scan(role, ctElement);
            if (!this.isTerminated()) continue;
            return;
        }
    }

    @Override
    public void scan(CtRole role, Map<String, ? extends CtElement> elements) {
        if (this.isTerminated() || elements == null) {
            return;
        }
        for (CtElement ctElement : elements.values()) {
            this.scan(role, ctElement);
            if (!this.isTerminated()) continue;
            return;
        }
    }

    @Override
    public void scan(CtRole role, CtElement element) {
        this.scannedRole = role;
        super.scan(role, element);
    }

    @Override
    public void scan(CtElement element) {
        if (element == null || this.isTerminated()) {
            return;
        }
        if (this.listener == null) {
            this.doScan(this.scannedRole, element, ScanningMode.NORMAL);
        } else {
            ScanningMode mode = this.listener.enter(this.scannedRole, element);
            if (mode != ScanningMode.SKIP_ALL) {
                this.doScan(this.scannedRole, element, mode);
                this.listener.exit(this.scannedRole, element);
            }
        }
    }

    protected void doScan(CtRole role, CtElement element, ScanningMode mode) {
        if (mode.visitElement) {
            this.onElement(role, element);
        }
        if (mode.visitChildren) {
            element.accept(this);
        }
    }

    @Override
    public void visitCtCompilationUnit(CtCompilationUnit compilationUnit) {
        if (this.isVisitCompilationUnitContent()) {
            this.enter(compilationUnit);
            this.scan(CtRole.COMMENT, compilationUnit.getComments());
            this.scan(CtRole.ANNOTATION, compilationUnit.getAnnotations());
            this.scan(CtRole.PACKAGE_DECLARATION, compilationUnit.getPackageDeclaration());
            this.scan(CtRole.DECLARED_IMPORT, compilationUnit.getImports());
            this.scan(CtRole.DECLARED_MODULE, compilationUnit.getDeclaredModule());
            this.scan(CtRole.DECLARED_TYPE, compilationUnit.getDeclaredTypes());
            this.exit(compilationUnit);
        } else {
            super.visitCtCompilationUnit(compilationUnit);
        }
    }

    protected void onElement(CtRole role, CtElement element) {
    }

    @Override
    public void scan(CtRole role, Object o) {
        if (this.isTerminated() || o == null) {
            return;
        }
        if (o instanceof CtElement) {
            this.scan(role, (CtElement)o);
        } else if (o instanceof Collection) {
            this.scan(role, (Collection)o);
        } else if (o instanceof Map) {
            for (Object obj : ((Map)o).values()) {
                this.scan(role, obj);
                if (!this.isTerminated()) continue;
                return;
            }
        }
    }

    public boolean isVisitCompilationUnitContent() {
        return this.visitCompilationUnitContent;
    }

    public EarlyTerminatingScanner<T> setVisitCompilationUnitContent(boolean visitCompilationUnitContent) {
        this.visitCompilationUnitContent = visitCompilationUnitContent;
        return this;
    }
}

