/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import spoon.reflect.code.CtComment;
import spoon.reflect.visitor.CommentHelper;
import spoon.reflect.visitor.PrinterHelper;
import spoon.reflect.visitor.TokenWriter;

public class DefaultTokenWriter
implements TokenWriter {
    private final PrinterHelper printerHelper;

    public DefaultTokenWriter() {
        this.printerHelper = new PrinterHelper();
    }

    public DefaultTokenWriter(PrinterHelper printerHelper) {
        this.printerHelper = printerHelper;
    }

    @Override
    public DefaultTokenWriter writeOperator(String token) {
        this.printerHelper.write(token);
        return this;
    }

    @Override
    public DefaultTokenWriter writeSeparator(String token) {
        this.printerHelper.write(token);
        return this;
    }

    @Override
    public DefaultTokenWriter writeLiteral(String token) {
        this.printerHelper.write(token);
        return this;
    }

    @Override
    public DefaultTokenWriter writeKeyword(String token) {
        this.printerHelper.write(token);
        return this;
    }

    @Override
    public DefaultTokenWriter writeIdentifier(String token) {
        this.printerHelper.write(token);
        return this;
    }

    @Override
    public DefaultTokenWriter writeCodeSnippet(String token) {
        this.printerHelper.write(token);
        return this;
    }

    @Override
    public DefaultTokenWriter writeComment(CtComment comment) {
        CommentHelper.printComment(this.printerHelper, comment);
        return this;
    }

    @Override
    public DefaultTokenWriter writeln() {
        this.printerHelper.writeln();
        return this;
    }

    @Override
    public DefaultTokenWriter incTab() {
        this.printerHelper.incTab();
        return this;
    }

    @Override
    public DefaultTokenWriter decTab() {
        this.printerHelper.decTab();
        return this;
    }

    @Override
    public void reset() {
        this.printerHelper.reset();
    }

    @Override
    public TokenWriter writeSpace() {
        this.printerHelper.writeSpace();
        return this;
    }

    @Override
    public PrinterHelper getPrinterHelper() {
        return this.printerHelper;
    }

    public String toString() {
        return this.printerHelper.toString();
    }
}

