/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.util.Comparator;
import spoon.reflect.declaration.CtImport;
import spoon.reflect.declaration.CtImportKind;

public class DefaultImportComparator
implements Comparator<CtImport> {
    @Override
    public int compare(CtImport imp1, CtImport imp2) {
        int dif = this.getImportKindOrder(imp1.getImportKind()) - this.getImportKindOrder(imp2.getImportKind());
        if (dif != 0) {
            return dif;
        }
        String str1 = DefaultImportComparator.removeSuffixSemicolon(imp1.toString());
        String str2 = DefaultImportComparator.removeSuffixSemicolon(imp2.toString());
        return str1.compareTo(str2);
    }

    private static String removeSuffixSemicolon(String str) {
        if (str.endsWith(";")) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    private int getImportKindOrder(CtImportKind importKind) {
        switch (importKind) {
            case TYPE: 
            case ALL_TYPES: {
                return 0;
            }
        }
        return 1;
    }
}

