/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.visitor.CtScanner;

public class CtIterator
extends CtScanner
implements Iterator<CtElement> {
    private Deque<CtElement> deque = new ArrayDeque<CtElement>(){

        @Override
        public boolean addAll(Collection<? extends CtElement> c) {
            for (CtElement ctElement : c) {
                this.addFirst(ctElement);
            }
            return !c.isEmpty();
        }
    };
    private ArrayDeque<CtElement> currentChildren = new ArrayDeque();

    public CtIterator(CtElement root) {
        if (root != null) {
            this.deque.add(root);
        }
    }

    @Override
    public void scan(CtElement element) {
        if (element != null) {
            this.currentChildren.addFirst(element);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.deque.isEmpty();
    }

    @Override
    public CtElement next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        CtElement next = this.deque.pollFirst();
        this.currentChildren.clear();
        next.accept(this);
        this.deque.addAll(this.currentChildren);
        return next;
    }
}

