/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.util.List;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtJavaDoc;
import spoon.reflect.code.CtJavaDocTag;
import spoon.reflect.visitor.PrinterHelper;
import spoon.support.Internal;

@Internal
public class CommentHelper {
    private CommentHelper() {
    }

    public static String printComment(CtComment comment) {
        PrinterHelper ph = new PrinterHelper(comment.getFactory().getEnvironment());
        CommentHelper.printCommentContent(ph, comment, s -> s);
        return ph.toString();
    }

    static void printComment(PrinterHelper printer, CtComment comment) {
        CtComment.CommentType commentType = comment.getCommentType();
        String content = comment.getContent();
        switch (commentType) {
            case FILE: {
                printer.write("/**").writeln();
                break;
            }
            case JAVADOC: {
                printer.write("/**").writeln();
                break;
            }
            case INLINE: {
                printer.write("// ");
                break;
            }
            case BLOCK: {
                String commentStart = "/* ";
                if (printer.prefixBlockComments) {
                    commentStart = commentStart.stripTrailing();
                }
                printer.write(commentStart);
                if (!printer.prefixBlockComments) break;
                printer.writeln();
            }
        }
        switch (commentType) {
            case INLINE: {
                printer.write(content);
                break;
            }
            case FILE: 
            case BLOCK: {
                UnaryOperator op = printer.prefixBlockComments ? s -> s.isEmpty() ? " *" : " * " + s : s -> s;
                CommentHelper.printCommentContent(printer, comment, op);
                break;
            }
            case JAVADOC: {
                CommentHelper.printCommentContent(printer, comment, s -> (" * " + s).replaceAll(" *$", ""));
            }
        }
        switch (commentType) {
            case BLOCK: {
                printer.write(" */");
                break;
            }
            case FILE: {
                printer.write(" */");
                break;
            }
            case JAVADOC: {
                printer.write(" */");
            }
        }
    }

    static void printCommentContent(PrinterHelper printer, CtComment comment, Function<String, String> transfo) {
        List<CtJavaDocTag> javaDocTags;
        CtComment.CommentType commentType = comment.getCommentType();
        String content = comment.getContent();
        content.lines().forEach(line -> {
            if (commentType == CtComment.CommentType.BLOCK) {
                printer.write((String)transfo.apply((String)line));
                if (CommentHelper.hasMoreThanOneElement(content.lines())) {
                    printer.writeln();
                }
            } else {
                printer.write((String)transfo.apply((String)line)).writeln();
            }
        });
        if (comment instanceof CtJavaDoc && (javaDocTags = ((CtJavaDoc)comment).getTags()) != null && !javaDocTags.isEmpty()) {
            printer.write(transfo.apply("")).writeln();
            for (CtJavaDocTag docTag : javaDocTags) {
                CommentHelper.printJavaDocTag(printer, docTag, transfo);
            }
        }
    }

    private static boolean hasMoreThanOneElement(Stream<?> stream) {
        return stream.skip(1L).findAny().isPresent();
    }

    static void printJavaDocTag(PrinterHelper printer, CtJavaDocTag docTag, Function<String, String> transfo) {
        printer.write(transfo.apply("@"));
        printer.write(CtJavaDocTag.TagType.UNKNOWN.getName().equalsIgnoreCase(docTag.getType().name()) ? docTag.getRealName() : docTag.getType().getName().toLowerCase());
        printer.write(" ");
        if (docTag.getType().hasParam()) {
            printer.write(docTag.getParam()).writeln();
        }
        docTag.getContent().lines().forEach(com -> {
            if (docTag.getType().hasParam()) {
                printer.write((String)transfo.apply("\t\t"));
            }
            printer.write(com.trim()).writeln();
        });
    }
}

