/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtResource;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtTryWithResource;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtInheritanceScanner;

public class AccessibleVariablesFinder {
    private CtElement expression;

    public AccessibleVariablesFinder(CtElement expression) {
        this.expression = expression;
    }

    public List<CtVariable> find() {
        if (this.expression.isParentInitialized()) {
            return this.getVariable(this.expression.getParent());
        }
        return Collections.emptyList();
    }

    private List<CtVariable> getVariable(CtElement parent) {
        final ArrayList<CtVariable> variables = new ArrayList<CtVariable>();
        if (parent == null) {
            return variables;
        }
        class VariableScanner
        extends CtInheritanceScanner {
            VariableScanner() {
            }

            @Override
            public void visitCtStatementList(CtStatementList e) {
                for (int i = 0; i < e.getStatements().size(); ++i) {
                    CtStatement ctStatement = e.getStatements().get(i);
                    if (AccessibleVariablesFinder.this.expression.getPosition().isValidPosition() && ctStatement.getPosition().isValidPosition() && ctStatement.getPosition().getSourceStart() > AccessibleVariablesFinder.this.expression.getPosition().getSourceEnd()) break;
                    if (!(ctStatement instanceof CtVariable)) continue;
                    variables.add((CtVariable)((Object)ctStatement));
                }
                super.visitCtStatementList(e);
            }

            @Override
            public <T> void scanCtType(CtType<T> type) {
                List<CtField<?>> fields = type.getFields();
                for (CtField<?> ctField : fields) {
                    if (ctField.hasModifier(ModifierKind.PUBLIC) || ctField.hasModifier(ModifierKind.PROTECTED)) {
                        variables.add(ctField);
                        continue;
                    }
                    if (ctField.hasModifier(ModifierKind.PRIVATE)) {
                        if (!AccessibleVariablesFinder.this.expression.hasParent(type)) continue;
                        variables.add(ctField);
                        continue;
                    }
                    if (!AccessibleVariablesFinder.this.expression.getParent(CtPackage.class).equals(type.getParent(CtPackage.class))) continue;
                    variables.add(ctField);
                }
                CtTypeReference<?> superclass = type.getSuperclass();
                if (superclass != null) {
                    variables.addAll(AccessibleVariablesFinder.this.getVariable(superclass.getTypeDeclaration()));
                }
                Set<CtTypeReference<?>> superInterfaces = type.getSuperInterfaces();
                for (CtTypeReference<?> typeReference : superInterfaces) {
                    variables.addAll(AccessibleVariablesFinder.this.getVariable(typeReference.getTypeDeclaration()));
                }
                super.scanCtType(type);
            }

            @Override
            public void visitCtTryWithResource(CtTryWithResource e) {
                for (CtResource<?> resource : e.getResources()) {
                    if (!(resource instanceof CtLocalVariable)) continue;
                    variables.add((CtLocalVariable)resource);
                }
                super.visitCtTryWithResource(e);
            }

            public void scanCtExecutable(CtExecutable e) {
                variables.addAll(e.getParameters());
                super.scanCtExecutable(e);
            }

            @Override
            public void visitCtFor(CtFor e) {
                for (CtStatement ctStatement : e.getForInit()) {
                    this.scan(ctStatement);
                }
                super.visitCtFor(e);
            }

            @Override
            public void visitCtForEach(CtForEach e) {
                variables.add(e.getVariable());
                super.visitCtForEach(e);
            }

            public void visitCtMethod(CtMethod e) {
                this.scan(e.getBody());
                super.visitCtMethod(e);
            }

            public void visitCtLocalVariable(CtLocalVariable e) {
                variables.add(e);
                super.visitCtLocalVariable(e);
            }

            @Override
            public void visitCtCatch(CtCatch e) {
                variables.add(e.getParameter());
                super.visitCtCatch(e);
            }
        }
        new VariableScanner().scan(parent);
        return variables;
    }
}

