/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.path.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.meta.RoleHandler;
import spoon.reflect.meta.impl.RoleHandlerHelper;
import spoon.reflect.path.CtPathException;
import spoon.reflect.path.CtRole;
import spoon.reflect.path.impl.AbstractPathElement;
import spoon.reflect.path.impl.CtNamedPathElement;
import spoon.reflect.reference.CtReference;

public class CtRolePathElement
extends AbstractPathElement<CtElement, CtElement> {
    public static final String STRING = "#";
    private final CtRole role;

    public CtRolePathElement(CtRole role) {
        this.role = role;
    }

    public CtRole getRole() {
        return this.role;
    }

    public String toString() {
        return STRING + this.getRole().toString() + this.getParamString();
    }

    private CtElement getFromSet(Collection<?> set, String name) throws CtPathException {
        for (Object o : set) {
            if (o instanceof CtNamedElement) {
                if (!((CtNamedElement)o).getSimpleName().equals(name)) continue;
                return (CtElement)o;
            }
            if (o instanceof CtReference) {
                if (!((CtReference)o).getSimpleName().equals(name)) continue;
                return (CtElement)o;
            }
            throw new CtPathException();
        }
        return null;
    }

    @Override
    public Collection<CtElement> getElements(Collection<CtElement> roots) {
        LinkedList<CtElement> matchs = new LinkedList<CtElement>();
        block8: for (CtElement root : roots) {
            RoleHandler roleHandler = RoleHandlerHelper.getOptionalRoleHandler(root.getClass(), this.getRole());
            if (roleHandler == null) continue;
            switch (roleHandler.getContainerKind()) {
                case SINGLE: {
                    if (roleHandler.getValue(root) == null) break;
                    matchs.add((CtElement)roleHandler.getValue(root));
                    break;
                }
                case LIST: {
                    Collection<Object> subMatches;
                    if (this.getArguments().containsKey("name")) {
                        String name = this.getArguments().get("name");
                        subMatches = new CtNamedPathElement(name).scanElements(roleHandler.asList(root));
                    } else if (this.getArguments().containsKey("signature")) {
                        String sign = this.getArguments().get("signature");
                        subMatches = new CtNamedPathElement(sign).scanElements(roleHandler.asList(root));
                    } else {
                        subMatches = roleHandler.asList(root);
                    }
                    if (this.getArguments().containsKey("index")) {
                        int index = Integer.parseInt(this.getArguments().get("index"));
                        if (index >= subMatches.size()) continue block8;
                        matchs.add((CtElement)new ArrayList<Object>(subMatches).get(index));
                        break;
                    }
                    matchs.addAll(subMatches);
                    break;
                }
                case SET: {
                    String name;
                    if (this.getArguments().containsKey("signature")) {
                        String sign = this.getArguments().get("signature");
                        matchs.addAll(new CtNamedPathElement(sign).scanElements(roleHandler.asSet(root)));
                        break;
                    }
                    if (this.getArguments().containsKey("name")) {
                        name = this.getArguments().get("name");
                        try {
                            CtElement match = this.getFromSet(roleHandler.asSet(root), name);
                            if (match == null) continue block8;
                            matchs.add(match);
                        }
                        catch (CtPathException ctPathException) {}
                        break;
                    }
                    matchs.addAll(roleHandler.asSet(root));
                    break;
                }
                case MAP: {
                    String name;
                    if (this.getArguments().containsKey("key")) {
                        name = this.getArguments().get("key");
                        if (!roleHandler.asMap(root).containsKey(name)) continue block8;
                        matchs.add((CtElement)roleHandler.asMap(root).get(name));
                        break;
                    }
                    Map map = roleHandler.asMap(root);
                    matchs.addAll(map.values());
                }
            }
        }
        return matchs;
    }
}

