/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.path.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.path.CtPath;
import spoon.reflect.path.impl.CtPathElement;

public class CtPathImpl
implements CtPath {
    private LinkedList<CtPathElement> elements = new LinkedList();

    public List<CtPathElement> getElements() {
        return this.elements;
    }

    @Override
    public <T extends CtElement> List<T> evaluateOn(CtElement ... startNode) {
        Collection<CtElement> filtered = Arrays.asList(startNode);
        for (CtPathElement element : this.elements) {
            filtered = element.getElements(filtered);
        }
        return filtered;
    }

    @Override
    public CtPath relativePath(CtElement parent) {
        ArrayList<CtElement> roots = new ArrayList<CtElement>();
        roots.add(parent);
        int index = 0;
        for (CtPathElement pathEl : this.getElements()) {
            if (pathEl.getElements(roots).size() > 0) break;
            ++index;
        }
        CtPathImpl result = new CtPathImpl();
        result.elements = new LinkedList(this.elements.subList(index, this.elements.size()));
        return result;
    }

    public CtPathImpl addFirst(CtPathElement element) {
        this.elements.addFirst(element);
        return this;
    }

    public CtPathImpl addLast(CtPathElement element) {
        this.elements.addLast(element);
        return this;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (CtPathElement element : this.elements) {
            str.append(element.toString());
        }
        return str.toString();
    }
}

