/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.path;

import java.util.ArrayDeque;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import spoon.SpoonException;
import spoon.reflect.path.CtPath;
import spoon.reflect.path.CtPathException;
import spoon.reflect.path.CtRole;
import spoon.reflect.path.impl.AbstractPathElement;
import spoon.reflect.path.impl.CtNamedPathElement;
import spoon.reflect.path.impl.CtPathElement;
import spoon.reflect.path.impl.CtPathImpl;
import spoon.reflect.path.impl.CtRolePathElement;
import spoon.reflect.path.impl.CtTypedNameElement;

public class CtPathStringBuilder {
    private static final String MAIN_DELIMITERS = ".#/";
    private static final String PATH_DELIMITERS = ".#/[";
    private static final String ARG_NAME_DELIMITERS = "=";
    private static final Pattern NAME_MATCHER = Pattern.compile("\\w+");
    private static final String ARG_VALUE_DELIMITERS = "[];()";

    private Class load(String name) throws CtPathException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return Class.forName("spoon.reflect.declaration." + name);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                try {
                    return Class.forName("spoon.reflect.code." + name);
                }
                catch (ClassNotFoundException ex) {
                    throw new CtPathException(String.format("Unable to locate element with type %s in Spoon model", name));
                }
            }
        }
    }

    public CtPath fromString(String pathStr) throws CtPathException {
        CtPathImpl path = new CtPathImpl();
        Tokenizer tokenizer = new Tokenizer(pathStr);
        String token = tokenizer.getNextToken(MAIN_DELIMITERS);
        while (token != null) {
            AbstractPathElement pathElement;
            String kind = token;
            token = tokenizer.getNextToken(PATH_DELIMITERS);
            if (token != null && token.length() == 1 && PATH_DELIMITERS.contains(token)) {
                throw new CtPathException("Path value is missing");
            }
            if (".".equals(kind)) {
                pathElement = new CtNamedPathElement(token, false);
            } else if ("/".equals(kind)) {
                pathElement = new CtTypedNameElement(this.load(token));
            } else if ("#".equals(kind)) {
                pathElement = new CtRolePathElement(CtRole.fromName(token));
            } else {
                throw new CtPathException("Unexpected token " + kind);
            }
            token = tokenizer.getNextToken(PATH_DELIMITERS);
            if ("[".equals(token)) {
                String argName;
                do {
                    if (!NAME_MATCHER.matcher(argName = tokenizer.getNextToken(ARG_NAME_DELIMITERS)).matches()) {
                        throw new CtPathException("Argument name must be a word, but is: " + argName);
                    }
                    token = tokenizer.getNextToken(ARG_NAME_DELIMITERS);
                    if (ARG_NAME_DELIMITERS.equals(token)) continue;
                    throw new CtPathException("Expects =");
                } while (!"]".equals(token = this.parseArgumentValue(tokenizer, argName, pathElement)));
                token = tokenizer.getNextToken(MAIN_DELIMITERS);
            }
            path.addLast(pathElement);
        }
        return path;
    }

    private String parseArgumentValue(Tokenizer tokenizer, String argName, CtPathElement pathElement) {
        StringBuilder argValue = new StringBuilder();
        ArrayDeque<String> stack = new ArrayDeque<String>();
        while (true) {
            String token;
            if ("(".equals(token = tokenizer.getNextToken(ARG_VALUE_DELIMITERS)) || "[".equals(token)) {
                stack.push(token);
            } else if (stack.size() > 0) {
                String kind;
                if (")".equals(token) ? !"(".equals(kind = (String)stack.pop()) : "]".equals(token) && !"[".equals(kind = (String)stack.pop())) {
                    throw new CtPathException("Unexpected end of bracket " + token);
                }
            } else if ("]".equals(token) || ";".equals(token)) {
                pathElement.addArgument(argName, argValue.toString());
                return token;
            }
            argValue.append(token);
        }
    }

    private static class Tokenizer {
        StringTokenizer tokenizer;
        int length;
        int off;

        Tokenizer(String str) {
            this.length = str.length();
            this.off = 0;
            this.tokenizer = new StringTokenizer(str, CtPathStringBuilder.MAIN_DELIMITERS, true);
        }

        String getNextToken(String delimiters) {
            try {
                if (this.off >= this.length) {
                    return null;
                }
                String token = this.tokenizer.nextToken(delimiters);
                this.off += token.length();
                return token;
            }
            catch (NoSuchElementException e) {
                throw new SpoonException("Unexpected error", e);
            }
        }
    }
}

