/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.path;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import spoon.reflect.CtModelImpl;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.meta.RoleHandler;
import spoon.reflect.meta.impl.RoleHandlerHelper;
import spoon.reflect.path.CtPath;
import spoon.reflect.path.CtPathException;
import spoon.reflect.path.CtRole;
import spoon.reflect.path.impl.CtPathImpl;
import spoon.reflect.path.impl.CtRolePathElement;
import spoon.reflect.reference.CtReference;

public class CtElementPathBuilder {
    private boolean useNamesInPath = true;

    public CtPath fromElement(CtElement el) throws CtPathException {
        return this.fromElement(el, el.getParent(CtModelImpl.CtRootPackage.class));
    }

    public CtPath fromElement(CtElement el, CtElement root) throws CtPathException {
        CtPathImpl path = new CtPathImpl();
        CtElement cur = el;
        while (cur != root) {
            CtElement parent = cur.getParent();
            CtRole role = cur.getRoleInParent();
            if (role == null) {
                throw new CtPathException();
            }
            RoleHandler roleHandler = RoleHandlerHelper.getOptionalRoleHandler(parent.getClass(), role);
            if (roleHandler == null) {
                throw new CtPathException();
            }
            CtRolePathElement pathElement = new CtRolePathElement(role);
            switch (roleHandler.getContainerKind()) {
                case SINGLE: {
                    break;
                }
                case LIST: {
                    if (this.useNamesInPath) {
                        String[] pair = this.getArg(cur);
                        String attrName = pair[0];
                        String name = pair[1];
                        if (name != null) {
                            if (role.getSubRoles().size() > 0) {
                                role = role.getMatchingSubRoleFor(cur);
                                pathElement = new CtRolePathElement(role);
                            }
                            pathElement.addArgument(attrName, name);
                            List list = roleHandler.asList(parent);
                            ArrayList<CtElement> filteredList = new ArrayList<CtElement>();
                            int index = -1;
                            for (CtElement item : list) {
                                String[] pair2 = this.getArg(item);
                                String attrName2 = pair2[0];
                                String name2 = pair2[1];
                                if (!Objects.equals(name, name2) || !Objects.equals(attrName, attrName2)) continue;
                                if (item == cur) {
                                    index = filteredList.size();
                                }
                                filteredList.add(item);
                            }
                            if (filteredList.size() <= 1 || index < 0) break;
                            pathElement.addArgument("index", String.valueOf(index));
                            break;
                        }
                    }
                    List list = roleHandler.asList(parent);
                    int index = 0;
                    for (String o : list) {
                        if (o == cur) break;
                        ++index;
                    }
                    pathElement.addArgument("index", "" + index);
                    break;
                }
                case SET: {
                    String name;
                    if (cur instanceof CtNamedElement) {
                        name = ((CtNamedElement)cur).getSimpleName();
                    } else if (cur instanceof CtReference) {
                        name = ((CtReference)cur).getSimpleName();
                    } else {
                        throw new CtPathException();
                    }
                    pathElement.addArgument("name", name);
                    break;
                }
                case MAP: {
                    Map map = roleHandler.asMap(parent);
                    String key = null;
                    for (String o : map.keySet()) {
                        if (map.get(o) != cur) continue;
                        key = o;
                        break;
                    }
                    if (key == null) {
                        throw new CtPathException();
                    }
                    pathElement.addArgument("key", key);
                    break;
                }
            }
            cur = parent;
            path.addFirst(pathElement);
        }
        return path;
    }

    private String[] getArg(CtElement item) {
        String name = null;
        String attrName = "name";
        if (item instanceof CtExecutable) {
            name = CtElementPathBuilder.getSignature((CtExecutable)item);
            attrName = "signature";
        } else if (item instanceof CtNamedElement) {
            name = ((CtNamedElement)item).getSimpleName();
        } else if (item instanceof CtReference) {
            name = ((CtReference)item).getSimpleName();
        }
        return new String[]{attrName, name};
    }

    private static String getSignature(CtExecutable exec) {
        String sign = exec.getSignature();
        if (exec instanceof CtConstructor) {
            int idx = sign.indexOf(40);
            return sign.substring(idx);
        }
        return sign;
    }

    public CtElementPathBuilder setUseNamesInPath(boolean useNamesInPath) {
        this.useNamesInPath = useNamesInPath;
        return this;
    }
}

