/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.meta.impl;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import spoon.reflect.meta.ContainerKind;
import spoon.reflect.meta.impl.AbstractRoleHandler;
import spoon.reflect.path.CtRole;

abstract class MapHandler<T, V>
extends AbstractRoleHandler<T, Map<String, V>, V> {
    protected MapHandler(CtRole role, Class<T> targetType, Class<?> valueClass) {
        super(role, targetType, valueClass);
    }

    @Override
    public ContainerKind getContainerKind() {
        return ContainerKind.MAP;
    }

    @Override
    protected Map<String, V> castValue(Object value) {
        Map map = (Map)super.castValue(value);
        this.checkItemsClass(map.values());
        return map;
    }

    public <W, X> Collection<X> asCollection(W element) {
        return this.asMap(element).values();
    }

    @Override
    public <W, X> Map<String, X> asMap(final W e) {
        return new AbstractMap<String, X>(){
            T element;
            {
                this.element = MapHandler.this.castTarget(e);
            }

            @Override
            public Set<Map.Entry<String, X>> entrySet() {
                return MapHandler.this.entrySet(this.element);
            }

            @Override
            public X get(Object key) {
                return MapHandler.this.get(this.element, key);
            }

            @Override
            public X put(String key, X value) {
                return MapHandler.this.put(this.element, key, MapHandler.this.castItemValue(value));
            }
        };
    }

    protected V get(T element, Object key) {
        return ((Map)this.getValue(element)).get(key);
    }

    protected V put(T element, String key, V value) {
        LinkedHashMap<String, V> values = new LinkedHashMap<String, V>((Map)this.getValue(element));
        V ret = values.put(key, value);
        this.setValue(element, values);
        return ret;
    }

    protected Set<Map.Entry<String, V>> entrySet(T element) {
        return ((Map)this.getValue(element)).entrySet();
    }
}

