/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.meta.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import spoon.SpoonException;
import spoon.reflect.meta.RoleHandler;
import spoon.reflect.path.CtRole;

abstract class AbstractRoleHandler<T, U, V>
implements RoleHandler {
    private final CtRole role;
    private final Class<T> targetClass;
    private final Class<V> valueClass;

    protected AbstractRoleHandler(CtRole role, Class<T> targetType, Class<?> valueType) {
        this.role = role;
        this.targetClass = targetType;
        this.valueClass = valueType;
    }

    @Override
    public CtRole getRole() {
        return this.role;
    }

    @Override
    public Class<?> getTargetType() {
        return this.targetClass;
    }

    protected T castTarget(Object element) {
        return (T)element;
    }

    protected U castValue(Object value) {
        return (U)value;
    }

    protected void checkItemsClass(Iterable<?> iterable) {
        for (Object value : iterable) {
            this.castItemValue(value);
        }
    }

    protected V castItemValue(Object value) {
        if (value != null && !this.valueClass.isInstance(value)) {
            throw new ClassCastException(value.getClass().getName() + " cannot be cast to " + this.valueClass.getName());
        }
        return (V)value;
    }

    public <W, X> void setValue(W element, X value) {
        throw new SpoonException("Setting of CtRole." + this.role.name() + " is not supported for " + element.getClass().getSimpleName());
    }

    @Override
    public Class<?> getValueClass() {
        return this.valueClass;
    }

    public <W, X> List<X> asList(W element) {
        throw new SpoonException("The value of CtRole." + this.getRole().name() + " cannot be adapted to List for " + element.getClass().getSimpleName());
    }

    public <W, X> Set<X> asSet(W element) {
        throw new SpoonException("The value of CtRole." + this.getRole().name() + " cannot be adapted to Set for " + element.getClass().getSimpleName());
    }

    public <W, X> Map<String, X> asMap(W element) {
        throw new SpoonException("The value of CtRole." + this.getRole().name() + " cannot be adapted to Map for " + element.getClass().getSimpleName());
    }

    public String toString() {
        return this.getTargetType().getName() + "#" + this.getRole().getCamelCaseName();
    }
}

