/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import spoon.SpoonException;
import spoon.reflect.declaration.CtModule;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtPackageDeclaration;
import spoon.reflect.factory.Factory;
import spoon.reflect.factory.SubFactory;
import spoon.reflect.reference.CtPackageReference;

public class PackageFactory
extends SubFactory {
    private static final long serialVersionUID = 1L;

    public PackageFactory(Factory factory) {
        super(factory);
    }

    public CtPackageReference createReference(CtPackage pack) {
        if (pack == null) {
            throw new IllegalArgumentException();
        }
        return this.createReference(pack.getQualifiedName());
    }

    public CtPackageReference createReference(Package pack) {
        return this.createReference(pack.getName());
    }

    public CtPackageReference topLevel() {
        return this.factory.getModel().getRootPackage().getReference();
    }

    public CtPackageReference createReference(String name) {
        CtPackageReference ref = this.factory.Core().createPackageReference();
        ref.setSimpleName(name);
        return ref;
    }

    public CtPackageDeclaration createPackageDeclaration(CtPackageReference packageRef) {
        CtPackageDeclaration pd = this.factory.Core().createPackageDeclaration();
        pd.setReference(packageRef);
        return pd;
    }

    public CtPackage create(CtPackage parent, String simpleName) {
        if (parent == null) {
            return this.getOrCreate(simpleName);
        }
        return this.getOrCreate(parent + "." + simpleName);
    }

    public CtPackage getOrCreate(String qualifiedName) {
        return this.getOrCreate(qualifiedName, this.factory.getModel().getUnnamedModule());
    }

    public CtPackage getOrCreate(String qualifiedName, CtModule rootModule) {
        if (qualifiedName.isEmpty()) {
            return rootModule.getRootPackage();
        }
        StringTokenizer token = new StringTokenizer(qualifiedName, ".");
        CtPackage last = rootModule.getRootPackage();
        while (token.hasMoreElements()) {
            String name = token.nextToken();
            CtPackage next = last.getPackage(name);
            if (next == null) {
                next = this.factory.Core().createPackage();
                next.setSimpleName(name);
                last.addPackage(next);
            }
            last = next;
        }
        return last;
    }

    public CtPackage get(String qualifiedName) {
        int foundPackageCount = 0;
        CtPackage packageWithTypes = null;
        CtPackage lastNonNullPackage = null;
        for (CtModule module : this.factory.getModel().getAllModules()) {
            CtPackage aPackage = PackageFactory.getPackageFromModule(qualifiedName, module);
            if (aPackage == null) continue;
            lastNonNullPackage = aPackage;
            if (!aPackage.hasTypes()) continue;
            packageWithTypes = aPackage;
            ++foundPackageCount;
        }
        if (foundPackageCount > 1) {
            throw new SpoonException("Ambiguous package name detected. If you believe the code you analyzed is correct, please file an issue and reference https://github.com/INRIA/spoon/issues/4051. Error details: Found " + foundPackageCount + " non-empty packages with name '" + qualifiedName + "'");
        }
        return packageWithTypes != null ? packageWithTypes : lastNonNullPackage;
    }

    private static CtPackage getPackageFromModule(String qualifiedName, CtModule ctModule) {
        int nextIndex;
        int index = 0;
        CtPackage current = ctModule.getRootPackage();
        if (qualifiedName.isEmpty() || current == null) {
            return current;
        }
        while ((nextIndex = qualifiedName.indexOf(46, index)) >= 0) {
            current = current.getPackage(qualifiedName.substring(index, nextIndex));
            index = nextIndex + 1;
            if (current != null) continue;
            return null;
        }
        return current.getPackage(qualifiedName.substring(index));
    }

    public Collection<CtPackage> getAll() {
        return this.factory.getModel().getAllPackages();
    }

    public CtPackage getRootPackage() {
        return this.factory.getModel().getRootPackage();
    }

    private List<CtPackage> getSubPackageList(CtPackage pack) {
        ArrayList<CtPackage> packs = new ArrayList<CtPackage>();
        packs.add(pack);
        for (CtPackage p : pack.getPackages()) {
            packs.addAll(this.getSubPackageList(p));
        }
        return packs;
    }
}

