/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.factory;

import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.factory.Factory;
import spoon.reflect.factory.TypeFactory;

public class InterfaceFactory
extends TypeFactory {
    public InterfaceFactory(Factory factory) {
        super(factory);
    }

    public <T> CtInterface<T> create(CtPackage owner, String simpleName) {
        CtInterface i = this.factory.Core().createInterface();
        i.setSimpleName(simpleName);
        owner.addType(i);
        return i;
    }

    public <T> CtInterface<T> create(CtType<T> owner, String simpleName) {
        CtInterface ctInterface = this.factory.Core().createInterface();
        ctInterface.setSimpleName(simpleName);
        owner.addNestedType(ctInterface);
        return ctInterface;
    }

    public <T> CtInterface<T> create(String qualifiedName) {
        if (this.hasInnerType(qualifiedName) > 0) {
            return this.create(this.create(this.getDeclaringTypeName(qualifiedName)), this.getSimpleName(qualifiedName));
        }
        return this.create(this.factory.Package().getOrCreate(this.getPackageName(qualifiedName)), this.getSimpleName(qualifiedName));
    }

    public <T> CtInterface<T> get(String qualifiedName) {
        try {
            return (CtInterface)super.get(qualifiedName);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> CtInterface<T> get(Class<?> cl) {
        Class<InterfaceFactory> clazz = InterfaceFactory.class;
        synchronized (InterfaceFactory.class) {
            try {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return (CtInterface)super.get(cl);
            }
            catch (Exception e) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
        }
    }
}

