/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.factory;

import java.lang.reflect.Field;
import java.util.Set;
import spoon.reflect.code.CtExpression;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.Factory;
import spoon.reflect.factory.SubFactory;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeReference;

public class FieldFactory
extends SubFactory {
    public FieldFactory(Factory factory) {
        super(factory);
    }

    public <T> CtField<T> create(CtType<?> target, Set<ModifierKind> modifiers, CtTypeReference<T> type, String name) {
        CtField field = this.factory.Core().createField();
        field.setModifiers(modifiers);
        field.setType(type);
        field.setSimpleName(name);
        if (target != null) {
            target.addField(field);
        }
        return field;
    }

    public <T> CtField<T> create(CtType<?> target, Set<ModifierKind> modifiers, CtTypeReference<T> type, String name, CtExpression<T> defaultExpression) {
        CtField<T> field = this.create(target, modifiers, type, name);
        field.setDefaultExpression(defaultExpression);
        return field;
    }

    public <T> CtField<T> create(CtType<?> target, CtField<T> source) {
        CtNamedElement newField = source.clone();
        if (target != null) {
            target.addField(newField);
        }
        return newField;
    }

    public <T> CtFieldReference<T> createReference(CtField<T> field) {
        CtFieldReference<T> reference = this.createReference(this.factory.Type().createReference(field.getDeclaringType()), (CtTypeReference<T>)field.getType().clone(), field.getSimpleName());
        reference.setFinal(field.hasModifier(ModifierKind.FINAL));
        reference.setStatic(field.hasModifier(ModifierKind.STATIC));
        return reference;
    }

    public <T> CtFieldReference<T> createReference(CtTypeReference<?> declaringType, CtTypeReference<T> type, String fieldName) {
        CtFieldReference fieldRef = this.factory.Core().createFieldReference();
        fieldRef.setSimpleName(fieldName);
        fieldRef.setDeclaringType(declaringType);
        fieldRef.setType(type);
        return fieldRef;
    }

    public <T> CtFieldReference<T> createReference(Field field) {
        CtFieldReference fieldRef = this.factory.Core().createFieldReference();
        fieldRef.setSimpleName(field.getName());
        fieldRef.setDeclaringType(this.factory.Type().createReference(field.getDeclaringClass()));
        CtTypeReference<?> t = this.factory.Type().createReference(field.getType());
        fieldRef.setType(t);
        return fieldRef;
    }

    public <T> CtFieldReference<T> createReference(String signature) {
        CtFieldReference fieldRef = this.factory.Core().createFieldReference();
        String type = signature.substring(0, signature.indexOf(32));
        String declaringType = signature.substring(signature.indexOf(32) + 1, signature.indexOf("#"));
        String fieldName = signature.substring(signature.indexOf("#") + 1);
        fieldRef.setSimpleName(fieldName);
        fieldRef.setDeclaringType(this.factory.Type().createReference(declaringType));
        CtTypeReference typeRef = this.factory.Type().createReference(type);
        fieldRef.setType(typeRef);
        return fieldRef;
    }
}

