/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.factory;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import spoon.SpoonException;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.cu.position.NoSourcePosition;
import spoon.reflect.declaration.CtModule;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.factory.Factory;
import spoon.reflect.factory.SubFactory;
import spoon.support.compiler.jdt.JDTSnippetCompiler;

public class CompilationUnitFactory
extends SubFactory {
    private transient Map<String, CompilationUnit> cachedCompilationUnits = new TreeMap<String, CompilationUnit>();

    public CompilationUnitFactory(Factory factory) {
        super(factory);
    }

    public Map<String, CompilationUnit> getMap() {
        return Collections.unmodifiableMap(this.cachedCompilationUnits);
    }

    public CompilationUnit create() {
        return this.factory.Core().createCompilationUnit();
    }

    public CompilationUnit getOrCreate(CtPackage ctPackage) {
        if (!(ctPackage.getPosition().getCompilationUnit() instanceof NoSourcePosition.NullCompilationUnit)) {
            return ctPackage.getPosition().getCompilationUnit();
        }
        CtModule module = this.factory.getEnvironment().getComplianceLevel() > 8 ? ctPackage.getParent(CtModule.class) : null;
        File file = this.factory.getEnvironment().getOutputDestinationHandler().getOutputPath(module, ctPackage, null).toFile();
        try {
            String path = file.getCanonicalPath();
            CompilationUnit result = this.getOrCreate(path);
            result.setDeclaredPackage(ctPackage);
            ctPackage.setPosition(this.factory.createPartialSourcePosition(result));
            return result;
        }
        catch (IOException e) {
            throw new SpoonException("Cannot get path for file: " + file.getAbsolutePath(), e);
        }
    }

    public void removeType(CtType<?> type) {
        File file = type.getPosition().getCompilationUnit().getFile();
        if (file != null) {
            this.cachedCompilationUnits.remove(type.getPosition().getCompilationUnit().getFile().getAbsolutePath());
        } else {
            this.cachedCompilationUnits.values().removeIf(it -> it == type.getPosition().getCompilationUnit());
        }
    }

    public CompilationUnit addType(CtType type) {
        if (type.isTopLevel()) {
            CtModule module = type.getPackage() != null && this.factory.getEnvironment().getComplianceLevel() > 8 ? type.getPackage().getParent(CtModule.class) : null;
            File file = this.factory.getEnvironment().getOutputDestinationHandler().getOutputPath(module, type.getPackage(), type).toFile();
            try {
                String path = file.getCanonicalPath();
                CompilationUnit result = this._create(path);
                result.addDeclaredType(type);
                return result;
            }
            catch (IOException e) {
                throw new SpoonException("Cannot get path for file: " + file.getAbsolutePath(), e);
            }
        }
        return this.getOrCreate(type.getTopLevelType());
    }

    public CompilationUnit getOrCreate(CtType type) {
        if (type == null) {
            return null;
        }
        if (!(type.getPosition().getCompilationUnit() instanceof NoSourcePosition.NullCompilationUnit)) {
            return type.getPosition().getCompilationUnit();
        }
        CompilationUnit compilationUnit = this.addType(type);
        type.setPosition(this.factory.createPartialSourcePosition(compilationUnit));
        return compilationUnit;
    }

    public CompilationUnit getOrCreate(CtModule module) {
        if (!(module.getPosition().getCompilationUnit() instanceof NoSourcePosition.NullCompilationUnit)) {
            return module.getPosition().getCompilationUnit();
        }
        File file = this.factory.getEnvironment().getOutputDestinationHandler().getOutputPath(module, null, null).toFile();
        try {
            String path = file.getCanonicalPath();
            CompilationUnit result = this.getOrCreate(path);
            result.setDeclaredModule(module);
            module.setPosition(this.factory.createPartialSourcePosition(result));
            return result;
        }
        catch (IOException e) {
            throw new SpoonException("Cannot get path for file: " + file.getAbsolutePath(), e);
        }
    }

    public CompilationUnit getOrCreate(String filePath) {
        CompilationUnit cu = this.cachedCompilationUnits.get(filePath);
        if (cu != null) {
            return cu;
        }
        return this._create(filePath);
    }

    private CompilationUnit _create(String filePath) {
        if (filePath.startsWith(JDTSnippetCompiler.SNIPPET_FILENAME_PREFIX)) {
            CompilationUnit cu = this.factory.Core().createCompilationUnit();
            this.cachedCompilationUnits.put(filePath, cu);
            return cu;
        }
        CompilationUnit cu = this.factory.Core().createCompilationUnit();
        if (!filePath.equals("virtual_file")) {
            cu.setFile(new File(filePath));
        }
        this.cachedCompilationUnits.put(filePath, cu);
        return cu;
    }

    public CompilationUnit removeFromCache(String filePath) {
        return this.cachedCompilationUnits.remove(filePath);
    }
}

