/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.factory;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import spoon.SpoonException;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtCodeSnippetExpression;
import spoon.reflect.code.CtCodeSnippetStatement;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtJavaDocTag;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtTextBlock;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.Factory;
import spoon.reflect.factory.SubFactory;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtCatchVariableReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtLocalVariableReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;

public class CodeFactory
extends SubFactory {
    public CodeFactory(Factory factory) {
        super(factory);
    }

    public <T> CtBinaryOperator<T> createBinaryOperator(CtExpression<?> left, CtExpression<?> right, BinaryOperatorKind kind) {
        return this.factory.Core().createBinaryOperator().setLeftHandOperand(left).setKind(kind).setRightHandOperand(right);
    }

    public <T> CtTypeAccess<T> createTypeAccess(CtTypeReference<T> accessedType) {
        if (accessedType == null) {
            return this.factory.Core().createTypeAccess();
        }
        CtReference access = accessedType.clone();
        access.setActualTypeArguments(null);
        return this.createTypeAccessWithoutCloningReference((CtTypeReference<T>)access);
    }

    public <T> CtTypeAccess<T> createTypeAccess(CtTypeReference<T> accessedType, boolean isImplicit) {
        return (CtTypeAccess)this.createTypeAccess(accessedType).setImplicit(isImplicit);
    }

    public <T> CtTypeAccess<T> createTypeAccessWithoutCloningReference(CtTypeReference<T> accessedType) {
        CtTypeAccess typeAccess = this.factory.Core().createTypeAccess();
        typeAccess.setAccessedType(accessedType);
        return typeAccess;
    }

    public <T> CtFieldAccess<Class<T>> createClassAccess(CtTypeReference<T> type) {
        CtTypeReference<Class> classType = this.factory.Type().createReference(Class.class);
        CtTypeAccess<T> typeAccess = this.factory.Code().createTypeAccess(type);
        CtFieldReference fieldReference = this.factory.Core().createFieldReference();
        fieldReference.setSimpleName("class");
        fieldReference.setType(classType);
        fieldReference.setDeclaringType(type);
        CtFieldRead fieldRead = this.factory.Core().createFieldRead();
        fieldRead.setType((CtTypeReference)classType.clone());
        fieldRead.setVariable(fieldReference);
        fieldRead.setTarget(typeAccess);
        return fieldRead;
    }

    public <T> CtConstructorCall<T> createConstructorCall(CtTypeReference<T> type, CtExpression<?> ... parameters) {
        CtConstructorCall constructorCall = this.factory.Core().createConstructorCall();
        CtExecutableReference executableReference = this.factory.Core().createExecutableReference();
        executableReference.setType(type);
        executableReference.setDeclaringType((CtTypeReference<?>)(type == null ? type : type.clone()));
        executableReference.setSimpleName("<init>");
        ArrayList typeReferences = new ArrayList();
        for (CtExpression<?> parameter : parameters) {
            typeReferences.add(parameter.getType());
        }
        executableReference.setParameters(typeReferences);
        constructorCall.setArguments(Arrays.asList(parameters));
        constructorCall.setExecutable(executableReference);
        return constructorCall;
    }

    public <T> CtNewClass<T> createNewClass(CtType<T> superClass, CtExpression<?> ... parameters) {
        CtNewClass ctNewClass = this.factory.Core().createNewClass();
        CtConstructor constructor = ((CtClass)superClass).getConstructor((CtTypeReference[])Arrays.stream(parameters).map(x -> x.getType()).toArray(CtTypeReference[]::new));
        if (constructor == null) {
            throw new SpoonException("no appropriate constructor for these parameters " + Arrays.toString(parameters));
        }
        CtReference executableReference = constructor.getReference();
        ctNewClass.setArguments(Arrays.asList(parameters));
        ctNewClass.setExecutable(executableReference);
        CtClass c = superClass.getFactory().createClass();
        c.setSuperclass((CtTypeReference<?>)superClass.getReference());
        c.setSimpleName("0");
        ctNewClass.setAnonymousClass(c);
        return ctNewClass;
    }

    public <T> CtInvocation<T> createInvocation(CtExpression<?> target, CtExecutableReference<T> executable, CtExpression<?> ... arguments) {
        ArrayList ext = new ArrayList(arguments.length);
        Collections.addAll(ext, arguments);
        return this.createInvocation(target, executable, ext);
    }

    public <T> CtInvocation<T> createInvocation(CtExpression<?> target, CtExecutableReference<T> executable, List<CtExpression<?>> arguments) {
        return (CtInvocation)((CtInvocation)((CtInvocation)this.factory.Core().createInvocation().setTarget(target)).setExecutable(executable)).setArguments(arguments);
    }

    public <T> CtLiteral<T> createLiteral(T value) {
        CtLiteral<T> literal = this.factory.Core().createLiteral();
        literal.setValue(value);
        if (value != null) {
            literal.setType(this.factory.Type().createReference(value.getClass()).unbox());
        } else {
            literal.setType(this.factory.Type().nullType());
        }
        return literal;
    }

    public CtTextBlock createTextBlock(String value) {
        CtTextBlock textblock = this.factory.Core().createTextBlock();
        textblock.setValue(value);
        textblock.setType(this.factory.Type().stringType());
        return textblock;
    }

    public <T> CtNewArray<T[]> createLiteralArray(T[] value) {
        if (!value.getClass().isArray()) {
            throw new RuntimeException("value is not an array");
        }
        if (value.getClass().getComponentType().isArray()) {
            throw new RuntimeException("can only create one-dimension arrays");
        }
        CtTypeReference<?> componentTypeRef = this.factory.Type().createReference(value.getClass().getComponentType());
        CtArrayTypeReference<?[]> arrayReference = this.factory.Type().createArrayReference(componentTypeRef);
        CtNewArray array = (CtNewArray)this.factory.Core().createNewArray().setType(arrayReference);
        for (T e : value) {
            CtLiteral<T> l = this.factory.Core().createLiteral();
            l.setValue(e);
            array.addElement(l);
        }
        return array;
    }

    public <T> CtLocalVariable<T> createLocalVariable(CtTypeReference<T> type, String name, CtExpression<T> defaultExpression) {
        return (CtLocalVariable)((CtLocalVariable)((CtLocalVariable)this.factory.Core().createLocalVariable().setSimpleName(name)).setType(type)).setDefaultExpression(defaultExpression);
    }

    public <T> CtLocalVariableReference<T> createLocalVariableReference(CtLocalVariable<T> localVariable) {
        CtLocalVariableReference ref = this.factory.Core().createLocalVariableReference();
        ref.setType((CtTypeReference)(localVariable.getType() == null ? null : localVariable.getType().clone()));
        ref.setSimpleName(localVariable.getSimpleName());
        ref.setParent(localVariable);
        return ref;
    }

    public <T> CtLocalVariableReference<T> createLocalVariableReference(CtTypeReference<T> type, String name) {
        return (CtLocalVariableReference)this.factory.Core().createLocalVariableReference().setType(type).setSimpleName(name);
    }

    public <T> CtCatchVariable<T> createCatchVariable(CtTypeReference<T> type, String name, ModifierKind ... modifierKinds) {
        EnumSet<ModifierKind> modifiers = EnumSet.noneOf(ModifierKind.class);
        modifiers.addAll(Arrays.asList(modifierKinds));
        return (CtCatchVariable)((CtCatchVariable)((CtCatchVariable)this.factory.Core().createCatchVariable().setSimpleName(name)).setType(type)).setModifiers(modifiers);
    }

    public <T> CtCatchVariableReference<T> createCatchVariableReference(CtCatchVariable<T> catchVariable) {
        CtCatchVariableReference ref = this.factory.Core().createCatchVariableReference();
        ref.setType((CtTypeReference)(catchVariable.getType() == null ? null : catchVariable.getType().clone()));
        ref.setSimpleName(catchVariable.getSimpleName());
        ref.setParent(catchVariable);
        return ref;
    }

    public <R> CtStatementList createStatementList(CtBlock<R> block) {
        CtStatementList l = this.factory.Core().createStatementList();
        for (CtStatement s : block.getStatements()) {
            l.addStatement(s.clone());
        }
        return l;
    }

    public <T> CtThisAccess<T> createThisAccess(CtTypeReference<T> type) {
        return this.createThisAccess(type, false);
    }

    public <T> CtThisAccess<T> createThisAccess(CtTypeReference<T> type, boolean isImplicit) {
        CtThisAccess thisAccess = this.factory.Core().createThisAccess();
        thisAccess.setImplicit(isImplicit);
        thisAccess.setType(type);
        CtTypeAccess<T> typeAccess = this.factory.Code().createTypeAccess(type);
        thisAccess.setTarget(typeAccess);
        return thisAccess;
    }

    public <T> CtVariableAccess<T> createVariableRead(CtVariableReference<T> variable, boolean isStatic) {
        CtVariableRead<T> va;
        if (variable instanceof CtFieldReference) {
            va = this.factory.Core().createFieldRead();
            if (!isStatic) {
                ((CtFieldAccess)((Object)va)).setTarget(this.createThisAccess((CtTypeReference<T>)((CtFieldReference)variable).getDeclaringType().clone()));
            }
        } else {
            va = this.factory.Core().createVariableRead();
        }
        return va.setVariable(variable);
    }

    public List<CtExpression<?>> createVariableReads(List<? extends CtVariable<?>> variables) {
        ArrayList result = new ArrayList(variables.size());
        for (CtVariable<?> v : variables) {
            result.add(this.createVariableRead((CtVariableReference)v.getReference(), v.getModifiers().contains((Object)ModifierKind.STATIC)));
        }
        return result;
    }

    public <T> CtVariableAccess<T> createVariableWrite(CtVariableReference<T> variable, boolean isStatic) {
        CtVariableWrite<T> va;
        if (variable instanceof CtFieldReference) {
            va = this.factory.Core().createFieldWrite();
            if (!isStatic) {
                ((CtFieldAccess)((Object)va)).setTarget(this.createThisAccess(((CtFieldReference)variable).getDeclaringType()));
            }
        } else {
            va = this.factory.Core().createVariableWrite();
        }
        return va.setVariable(variable);
    }

    public <A, T extends A> CtAssignment<A, T> createVariableAssignment(CtVariableReference<A> variable, boolean isStatic, CtExpression<T> expression) {
        CtVariableAccess<A> vaccess = this.createVariableWrite(variable, isStatic);
        return ((CtAssignment)this.factory.Core().createAssignment().setAssignment(expression)).setAssigned(vaccess);
    }

    public <T> CtStatementList createVariableAssignments(List<? extends CtVariable<T>> variables, List<? extends CtExpression<T>> expressions) {
        CtStatementList result = this.factory.Core().createStatementList();
        for (int i = 0; i < variables.size(); ++i) {
            result.addStatement(this.createVariableAssignment((CtVariableReference)variables.get(i).getReference(), variables.get(i).getModifiers().contains((Object)ModifierKind.STATIC), expressions.get(i)));
        }
        return result;
    }

    public <T> CtField<T> createCtField(String name, CtTypeReference<T> type, String exp, ModifierKind ... visibilities) {
        return (CtField)((CtField)((CtField)((CtField)this.factory.Core().createField().setModifiers(this.modifiers(visibilities))).setSimpleName(name)).setType(type)).setDefaultExpression(this.createCodeSnippetExpression(exp));
    }

    public <T extends CtStatement> CtBlock<?> createCtBlock(T element) {
        return (CtBlock)this.factory.Core().createBlock().addStatement(element);
    }

    public <T extends CtStatement> CtBlock<?> getOrCreateCtBlock(T element) {
        if (element == null) {
            return null;
        }
        if (element instanceof CtBlock) {
            return (CtBlock)element;
        }
        return this.createCtBlock(element);
    }

    public CtThrow createCtThrow(String thrownExp) {
        return this.factory.Core().createThrow().setThrownExpression(this.createCodeSnippetExpression(thrownExp));
    }

    public CtCatch createCtCatch(String nameCatch, Class<? extends Throwable> exception, CtBlock<?> ctBlock) {
        CtCatchVariable catchVariable = (CtCatchVariable)((CtCatchVariable)this.factory.Core().createCatchVariable().setType(this.createCtTypeReference(exception))).setSimpleName(nameCatch);
        return (CtCatch)this.factory.Core().createCatch().setParameter(catchVariable).setBody(ctBlock);
    }

    public <T> CtTypeReference<T> createCtTypeReference(Class<?> originalClass) {
        if (originalClass == null) {
            return null;
        }
        int arrayDimensionCount = 0;
        Class<?> currentClass = originalClass;
        while (currentClass.isArray()) {
            currentClass = currentClass.getComponentType();
            ++arrayDimensionCount;
        }
        CtTypeReference typeReference = this.factory.Core().createTypeReference();
        if (currentClass.isAnonymousClass()) {
            int end = currentClass.getName().lastIndexOf(36);
            typeReference.setSimpleName(currentClass.getName().substring(end + 1));
        } else {
            typeReference.setSimpleName(currentClass.getSimpleName());
        }
        if (currentClass.getEnclosingClass() != null) {
            typeReference.setDeclaringType(this.createCtTypeReference(currentClass.getEnclosingClass()));
        }
        if (currentClass.getPackage() != null) {
            typeReference.setPackage(this.createCtPackageReference(currentClass.getPackage()));
        }
        if (arrayDimensionCount > 0) {
            typeReference = this.factory.createArrayReference(typeReference, arrayDimensionCount);
        }
        return typeReference;
    }

    public CtPackageReference createCtPackageReference(Package originalPackage) {
        return (CtPackageReference)this.factory.Core().createPackageReference().setSimpleName(originalPackage.getName());
    }

    public <A extends Annotation> CtAnnotation<A> createAnnotation(CtTypeReference<A> annotationType) {
        CtAnnotation a = this.factory.Core().createAnnotation();
        a.setAnnotationType(annotationType);
        return a;
    }

    public <T> CtReturn<T> createCtReturn(CtExpression<T> expression) {
        CtReturn<T> result = this.factory.Core().createReturn();
        result.setReturnedExpression(expression);
        return result;
    }

    public <R extends CtReference, E extends CtNamedElement> List<R> getReferences(List<E> elements) {
        ArrayList<CtReference> refs = new ArrayList<CtReference>(elements.size());
        for (CtNamedElement e : elements) {
            refs.add(e.getReference());
        }
        return refs;
    }

    public Set<ModifierKind> modifiers(ModifierKind ... modifiers) {
        EnumSet<ModifierKind> ret = EnumSet.noneOf(ModifierKind.class);
        Collections.addAll(ret, modifiers);
        return ret;
    }

    public <T> CtCodeSnippetExpression<T> createCodeSnippetExpression(String expression) {
        CtCodeSnippetExpression e = this.factory.Core().createCodeSnippetExpression();
        e.setValue(expression);
        return e;
    }

    public CtCodeSnippetStatement createCodeSnippetStatement(String statement) {
        CtCodeSnippetStatement e = this.factory.Core().createCodeSnippetStatement();
        e.setValue(statement);
        return e;
    }

    public CtComment createComment(String content, CtComment.CommentType type) {
        if (type == CtComment.CommentType.JAVADOC) {
            return this.factory.Core().createJavaDoc().setContent(content);
        }
        return this.factory.Core().createComment().setContent(content).setCommentType(type);
    }

    public CtComment createInlineComment(String content) {
        if (content.contains("\n")) {
            throw new SpoonException("The content of your comment contain at least one line separator. Please consider using a block comment by calling createComment(\"your content\", CtComment.CommentType.BLOCK).");
        }
        return this.createComment(content, CtComment.CommentType.INLINE);
    }

    public CtJavaDocTag createJavaDocTag(String content, CtJavaDocTag.TagType type) {
        if (content == null) {
            content = "";
        }
        CtJavaDocTag docTag = this.factory.Core().createJavaDocTag();
        if (type != null && type.hasParam()) {
            int firstWord = content.indexOf(32);
            int firstLine = content.indexOf(10);
            if (firstLine < firstWord && firstLine >= 0) {
                firstWord = firstLine;
            }
            if (firstWord == -1) {
                firstWord = content.length();
            }
            String param = content.substring(0, firstWord);
            content = content.substring(firstWord);
            docTag.setParam(param);
        }
        return docTag.setContent(content.trim()).setType(type);
    }

    public CtJavaDocTag createJavaDocTag(String content, CtJavaDocTag.TagType type, String realName) {
        if (content == null) {
            content = "";
        }
        CtJavaDocTag docTag = this.factory.Core().createJavaDocTag();
        if (type != null && type.hasParam()) {
            int firstWord = content.indexOf(32);
            int firstLine = content.indexOf(10);
            if (firstLine < firstWord && firstLine >= 0) {
                firstWord = firstLine;
            }
            if (firstWord == -1) {
                firstWord = content.length();
            }
            String param = content.substring(0, firstWord);
            content = content.substring(firstWord);
            docTag.setParam(param);
        }
        return docTag.setContent(content.trim()).setType(type).setRealName(realName);
    }
}

