/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.factory;

import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.factory.Factory;
import spoon.reflect.factory.TypeFactory;

public class ClassFactory
extends TypeFactory {
    public ClassFactory(Factory factory) {
        super(factory);
    }

    public <T> CtClass<T> create(CtClass<?> declaringClass, String simpleName) {
        CtClass c = this.factory.Core().createClass();
        c.setSimpleName(simpleName);
        declaringClass.addNestedType(c);
        return c;
    }

    public <T> CtClass<T> create(CtPackage owner, String simpleName) {
        CtClass c = this.factory.Core().createClass();
        c.setSimpleName(simpleName);
        owner.addType(c);
        return c;
    }

    public <T> CtClass<T> create(String qualifiedName) {
        if (this.hasInnerType(qualifiedName) > 0) {
            CtClass<T> declaringClass = this.create(this.getDeclaringTypeName(qualifiedName));
            return this.create(declaringClass, this.getSimpleName(qualifiedName));
        }
        return this.create(this.factory.Package().getOrCreate(this.getPackageName(qualifiedName)), this.getSimpleName(qualifiedName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> CtClass<T> get(Class<?> cl) {
        Class<ClassFactory> clazz = ClassFactory.class;
        synchronized (ClassFactory.class) {
            try {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return (CtClass)super.get(cl);
            }
            catch (Exception e) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
        }
    }

    public <T> CtClass<T> get(String qualifiedName) {
        try {
            return (CtClass)super.get(qualifiedName);
        }
        catch (Exception e) {
            return null;
        }
    }
}

