/*
 * Decompiled with CFR 0.152.
 */
package spoon.refactoring;

import java.util.List;
import spoon.SpoonException;
import spoon.refactoring.AbstractRenameRefactoring;
import spoon.refactoring.CtDeprecatedRefactoring;
import spoon.refactoring.CtRenameLocalVariableRefactoring;
import spoon.refactoring.RefactoringException;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.Query;
import spoon.reflect.visitor.filter.TypeFilter;

public final class Refactoring {
    private Refactoring() {
    }

    public static void changeTypeName(CtType<?> type, final String name) {
        final String typeQFN = type.getQualifiedName();
        List<CtTypeReference> references = Query.getElements(type.getFactory(), new TypeFilter<CtTypeReference<?>>(CtTypeReference.class){

            @Override
            public boolean matches(CtTypeReference<?> reference) {
                String refFQN = reference.getQualifiedName();
                return typeQFN.equals(refFQN);
            }
        });
        type.setSimpleName(name);
        for (CtTypeReference reference : references) {
            reference.setSimpleName(name);
        }
        if (type.isTopLevel()) {
            CompilationUnit compilationUnit = type.getFactory().CompilationUnit().getOrCreate(type);
            new CtScanner(){

                @Override
                public <T> void visitCtTypeReference(CtTypeReference<T> reference) {
                    if (typeQFN.equals(reference.getQualifiedName())) {
                        reference.setSimpleName(name);
                    }
                    super.visitCtTypeReference(reference);
                }
            }.scan(compilationUnit);
        }
    }

    public static void changeMethodName(final CtMethod<?> method, String newName) {
        List<CtExecutableReference> references = Query.getElements(method.getFactory(), new TypeFilter<CtExecutableReference<?>>(CtExecutableReference.class){

            @Override
            public boolean matches(CtExecutableReference<?> reference) {
                return reference.getDeclaration() == method;
            }
        });
        method.setSimpleName(newName);
        for (CtExecutableReference reference : references) {
            reference.setSimpleName(newName);
        }
    }

    public static CtMethod<?> copyMethod(final CtMethod<?> method) {
        CtExecutable clone = method.clone();
        StringBuilder tentativeTypeName = new StringBuilder(method.getSimpleName() + "Copy");
        CtType parent = method.getParent(CtType.class);
        while (!parent.getMethodsByName(tentativeTypeName.toString()).isEmpty()) {
            tentativeTypeName.append("X");
        }
        final String cloneMethodName = tentativeTypeName.toString();
        clone.setSimpleName(cloneMethodName);
        parent.addMethod(clone);
        new CtScanner((CtMethod)clone){
            final /* synthetic */ CtMethod val$clone;
            {
                this.val$clone = ctMethod2;
            }

            @Override
            public <T> void visitCtExecutableReference(CtExecutableReference<T> reference) {
                CtElement declaration = reference.getDeclaration();
                if (declaration == null) {
                    return;
                }
                if (declaration == method) {
                    reference.setSimpleName(cloneMethodName);
                }
                if (reference.getDeclaration() != this.val$clone) {
                    throw new SpoonException("post condition broken " + reference);
                }
                super.visitCtExecutableReference(reference);
            }
        }.scan(clone);
        return clone;
    }

    public static CtType<?> copyType(final CtType<?> type) {
        CtNamedElement clone = type.clone();
        StringBuilder tentativeTypeName = new StringBuilder(type.getSimpleName() + "Copy");
        while (type.getFactory().Type().get(type.getPackage().getQualifiedName() + "." + tentativeTypeName) != null) {
            tentativeTypeName.append("X");
        }
        final String cloneTypeName = tentativeTypeName.toString();
        clone.setSimpleName(cloneTypeName);
        type.getPackage().addType((CtType<?>)clone);
        new CtScanner(){

            @Override
            public <T> void visitCtTypeReference(CtTypeReference<T> reference) {
                if (reference.getDeclaration() == null) {
                    return;
                }
                if (reference.getDeclaration() == type) {
                    reference.setSimpleName(cloneTypeName);
                }
                super.visitCtTypeReference(reference);
            }

            @Override
            public <T> void visitCtExecutableReference(CtExecutableReference<T> reference) {
                CtElement declaration = reference.getDeclaration();
                if (declaration == null) {
                    return;
                }
                if (declaration.hasParent(type)) {
                    reference.getDeclaringType().setSimpleName(cloneTypeName);
                }
                super.visitCtExecutableReference(reference);
            }

            @Override
            public <T> void visitCtFieldReference(CtFieldReference<T> reference) {
                CtVariable declaration = reference.getDeclaration();
                if (declaration == null) {
                    return;
                }
                if (declaration.hasParent(type)) {
                    reference.getDeclaringType().setSimpleName(cloneTypeName);
                }
                super.visitCtFieldReference(reference);
            }
        }.scan(clone);
        new CtScanner((CtType)clone){
            final /* synthetic */ CtType val$clone;
            {
                this.val$clone = ctType;
            }

            @Override
            public <T> void visitCtTypeReference(CtTypeReference<T> reference) {
                if (reference.getDeclaration() == null) {
                    return;
                }
                if (reference.getDeclaration().getTopLevelType() != this.val$clone) {
                    throw new SpoonException("post condition broken " + reference);
                }
                super.visitCtTypeReference(reference);
            }

            @Override
            public <T> void visitCtExecutableReference(CtExecutableReference<T> reference) {
                CtElement declaration = reference.getDeclaration();
                if (declaration == null) {
                    return;
                }
                if (!declaration.hasParent(this.val$clone)) {
                    throw new SpoonException("post condition broken " + reference);
                }
                super.visitCtExecutableReference(reference);
            }

            @Override
            public <T> void visitCtFieldReference(CtFieldReference<T> reference) {
                CtVariable declaration = reference.getDeclaration();
                if (declaration == null) {
                    return;
                }
                if (!declaration.hasParent(this.val$clone)) {
                    throw new SpoonException("post condition broken " + reference);
                }
                super.visitCtFieldReference(reference);
            }
        }.scan(clone);
        return clone;
    }

    public static void changeLocalVariableName(CtLocalVariable<?> localVariable, String newName) throws RefactoringException {
        ((AbstractRenameRefactoring)((AbstractRenameRefactoring)new CtRenameLocalVariableRefactoring().setTarget(localVariable)).setNewName(newName)).refactor();
    }

    public static void removeDeprecatedMethods(String path) {
        new CtDeprecatedRefactoring().removeDeprecatedMethods(path);
    }

    public static void removeDeprecatedMethods(String input, String resultPath) {
        new CtDeprecatedRefactoring().removeDeprecatedMethods(input, resultPath);
    }
}

