/*
 * Decompiled with CFR 0.152.
 */
package spoon.refactoring;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import spoon.refactoring.MethodCallState;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLambda;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.filter.TypeFilter;
import spoon.support.reflect.code.CtLambdaImpl;

public class MethodInvocationSearch
extends CtScanner {
    private Map<CtExecutable<?>, Collection<CtExecutable<?>>> invocationsOfMethod = new HashMap();
    private Map<CtExecutable<?>, Collection<CtType<?>>> invocationsOfField = new HashMap();

    @Override
    public <T> void visitCtMethod(CtMethod<T> method) {
        if (!method.getPosition().isValidPosition()) {
            return;
        }
        CtExecutable transformedMethod = method instanceof CtLambda ? method.getParent(CtExecutable.class) : method;
        List<CtInvocation> invocations = method.getElements(new TypeFilter<CtInvocation>(CtInvocation.class));
        List<CtConstructorCall> constructors = method.getElements(new TypeFilter<CtConstructorCall>(CtConstructorCall.class));
        if (!(this.invocationsOfMethod.containsKey(method) || method.isImplicit() || method instanceof CtLambdaImpl)) {
            this.invocationsOfMethod.put(method, Collections.emptyList());
        }
        invocations.stream().filter(v -> !v.isImplicit()).map(v -> v.getExecutable().getExecutableDeclaration()).filter(Objects::nonNull).filter(v -> v.getPosition().isValidPosition()).forEach(v -> this.invocationsOfMethod.merge((CtExecutable<?>)v, (Collection<CtExecutable<?>>)new HashSet<CtExecutable>(Arrays.asList(transformedMethod)), (o1, o2) -> Stream.concat(o1.stream(), o2.stream()).collect(Collectors.toCollection(HashSet::new))));
        constructors.stream().filter(v -> !v.isImplicit()).map(v -> v.getExecutable().getExecutableDeclaration()).filter(Objects::nonNull).forEach(v -> this.invocationsOfMethod.merge((CtExecutable<?>)v, (Collection<CtExecutable<?>>)new HashSet<CtExecutable>(Arrays.asList(transformedMethod)), (o1, o2) -> Stream.concat(o1.stream(), o2.stream()).collect(Collectors.toCollection(HashSet::new))));
        super.visitCtMethod(method);
    }

    public Collection<MethodCallState> getInvocationsOfMethod() {
        HashSet<MethodCallState> transformedResult = new HashSet<MethodCallState>();
        Stream.concat(this.invocationsOfMethod.keySet().stream(), this.invocationsOfField.keySet().stream()).map(MethodCallState::new).forEach(transformedResult::add);
        for (MethodCallState methodCallState : transformedResult) {
            ((Collection)this.invocationsOfField.getOrDefault(methodCallState.getMethod(), Collections.emptyList())).forEach(methodCallState::add);
            ((Collection)this.invocationsOfMethod.getOrDefault(methodCallState.getMethod(), Collections.emptyList())).forEach(methodCallState::add);
        }
        return transformedResult;
    }

    @Override
    public <T> void visitCtField(CtField<T> field) {
        field.getElements(new TypeFilter<CtInvocation>(CtInvocation.class)).stream().map(call -> call.getExecutable().getExecutableDeclaration()).forEach(method -> this.invocationsOfField.merge((CtExecutable<?>)method, (Collection<CtType<?>>)new HashSet<CtType>(Arrays.asList(field.getDeclaringType())), (o1, o2) -> Stream.concat(o1.stream(), o2.stream()).collect(Collectors.toCollection(HashSet::new))));
        field.getElements(new TypeFilter<CtConstructorCall>(CtConstructorCall.class)).stream().map(call -> call.getExecutable().getExecutableDeclaration()).forEach(method -> this.invocationsOfField.merge((CtExecutable<?>)method, (Collection<CtType<?>>)new HashSet<CtType>(Arrays.asList(field.getDeclaringType())), (o1, o2) -> Stream.concat(o1.stream(), o2.stream()).collect(Collectors.toCollection(HashSet::new))));
        super.visitCtField(field);
    }
}

