/*
 * Decompiled with CFR 0.152.
 */
package spoon.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtType;

public class MethodCallState {
    private CtExecutable<?> method;
    private Collection<CtExecutable<?>> callerMethods;
    private Collection<CtType<?>> callerFields;

    public MethodCallState(CtExecutable<?> method) {
        this.method = method;
        this.callerFields = new ArrayList();
        this.callerMethods = new ArrayList();
    }

    public void add(CtExecutable<?> method) {
        this.callerMethods.add(method);
    }

    public void add(CtType<?> type) {
        this.callerFields.add(type);
    }

    public CtExecutable<?> getMethod() {
        return this.method;
    }

    public Collection<CtType<?>> getCallerFields() {
        return this.callerFields;
    }

    public Collection<CtExecutable<?>> getCallerMethods() {
        return this.callerMethods;
    }

    public boolean checkCallState() {
        return this.callerMethods.isEmpty() && this.callerFields.isEmpty();
    }

    public boolean contains(CtType<?> o) {
        return this.callerFields.contains(o);
    }

    public boolean contains(CtExecutable<?> o) {
        return this.callerMethods.contains(o);
    }

    public void remove(CtType<?> o) {
        this.callerFields.remove(o);
    }

    public void remove(CtExecutable<?> o) {
        this.callerMethods.remove(o);
    }
}

