/*
 * Decompiled with CFR 0.152.
 */
package spoon.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import spoon.SpoonException;
import spoon.refactoring.CtRefactoring;
import spoon.refactoring.RefactoringException;
import spoon.reflect.code.CtAnnotationFieldAccess;
import spoon.reflect.code.CtArrayRead;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.visitor.CtAbstractVisitor;
import spoon.reflect.visitor.chain.CtConsumer;
import spoon.reflect.visitor.filter.AllMethodsSameSignatureFunction;
import spoon.reflect.visitor.filter.ExecutableReferenceFilter;
import spoon.reflect.visitor.filter.ParameterReferenceFunction;

public class CtParameterRemoveRefactoring
implements CtRefactoring {
    private CtParameter<?> target;
    private int parameterIndex;
    private List<CtExecutable<?>> targetExecutables;
    private List<CtInvocation<?>> targetInvocations;

    public CtParameter<?> getTarget() {
        return this.target;
    }

    public CtParameterRemoveRefactoring setTarget(CtParameter<?> target) {
        if (this.target == target) {
            return this;
        }
        this.target = target;
        this.parameterIndex = target.getParent().getParameters().indexOf(target);
        this.targetExecutables = null;
        this.targetInvocations = null;
        return this;
    }

    public List<CtExecutable<?>> getTargetExecutables() {
        if (this.targetExecutables == null) {
            this.computeAllExecutables();
        }
        return this.targetExecutables;
    }

    public List<CtInvocation<?>> getTargetInvocations() {
        if (this.targetInvocations == null) {
            this.computeAllInvocations();
        }
        return this.targetInvocations;
    }

    @Override
    public void refactor() {
        if (this.getTarget() == null) {
            throw new SpoonException("The target of refactoring is not defined");
        }
        this.detectIssues();
        this.refactorNoCheck();
    }

    protected void detectIssues() {
        this.checkAllExecutables();
        this.checkAllInvocations();
    }

    private void computeAllExecutables() {
        if (this.getTarget() == null) {
            throw new SpoonException("The target of refactoring is not defined");
        }
        final ArrayList<CtElement> executables = new ArrayList<CtElement>();
        CtElement targetExecutable = this.target.getParent();
        executables.add(targetExecutable);
        targetExecutable.map(new AllMethodsSameSignatureFunction()).forEach(new CtConsumer<CtExecutable<?>>(){

            @Override
            public void accept(CtExecutable<?> executable) {
                executables.add(executable);
            }
        });
        this.targetExecutables = Collections.unmodifiableList(executables);
    }

    private void computeAllInvocations() {
        ExecutableReferenceFilter execRefFilter = new ExecutableReferenceFilter();
        for (CtExecutable<?> exec : this.getTargetExecutables()) {
            execRefFilter.addExecutable(exec);
        }
        final ArrayList invocations = new ArrayList();
        this.target.getFactory().getModel().filterChildren(execRefFilter).forEach(new CtConsumer<CtExecutableReference<?>>(){

            @Override
            public void accept(CtExecutableReference<?> t) {
                CtElement parent = t.getParent();
                if (parent instanceof CtInvocation) {
                    invocations.add((CtInvocation)parent);
                }
            }
        });
        this.targetInvocations = Collections.unmodifiableList(invocations);
    }

    private void checkAllExecutables() {
        for (CtExecutable<?> executable : this.getTargetExecutables()) {
            this.checkExecutable(executable);
        }
    }

    private void checkExecutable(CtExecutable<?> executable) {
        final CtParameter<?> toBeRemovedParam = executable.getParameters().get(this.parameterIndex);
        toBeRemovedParam.map(new ParameterReferenceFunction()).forEach(new CtConsumer<CtParameterReference<?>>(){

            @Override
            public void accept(CtParameterReference<?> paramRef) {
                if (CtParameterRemoveRefactoring.this.isAllowedParameterUsage(paramRef)) {
                    return;
                }
                CtParameterRemoveRefactoring.this.createParameterUsedIssue(toBeRemovedParam, paramRef);
            }
        });
    }

    private void checkAllInvocations() {
        for (CtInvocation<?> invocation : this.getTargetInvocations()) {
            this.checkInvocation(invocation);
        }
    }

    private void checkInvocation(CtInvocation<?> invocation) {
        CtExpression<?> toBeRemovedExpression = invocation.getArguments().get(this.parameterIndex);
        if (!this.canRemoveExpression(toBeRemovedExpression)) {
            this.createExpressionCannotBeRemovedIssue(invocation, toBeRemovedExpression);
        }
    }

    protected boolean isAllowedParameterUsage(CtParameterReference<?> paramRef) {
        return this.isRemovedParamOfRefactoredInvocation(paramRef);
    }

    protected boolean canRemoveExpression(CtExpression<?> toBeRemovedExpression) {
        class Context {
            boolean canBeRemoved = false;

            Context() {
            }
        }
        final Context context = new Context();
        toBeRemovedExpression.accept(new CtAbstractVisitor(){
            {
            }

            @Override
            public <T> void visitCtVariableRead(CtVariableRead<T> variableRead) {
                context.canBeRemoved = true;
            }

            @Override
            public <T> void visitCtArrayRead(CtArrayRead<T> arrayRead) {
                context.canBeRemoved = true;
            }

            @Override
            public <T> void visitCtFieldRead(CtFieldRead<T> fieldRead) {
                context.canBeRemoved = true;
            }

            @Override
            public <T> void visitCtParameterReference(CtParameterReference<T> reference) {
                context.canBeRemoved = true;
            }

            @Override
            public <T> void visitCtLiteral(CtLiteral<T> literal) {
                context.canBeRemoved = true;
            }

            @Override
            public <T> void visitCtNewArray(CtNewArray<T> newArray) {
                context.canBeRemoved = true;
            }

            @Override
            public <T> void visitCtAnnotationFieldAccess(CtAnnotationFieldAccess<T> annotationFieldAccess) {
                context.canBeRemoved = true;
            }

            @Override
            public <T> void visitCtThisAccess(CtThisAccess<T> thisAccess) {
                context.canBeRemoved = true;
            }
        });
        return context.canBeRemoved;
    }

    protected boolean isRemovedParamOfRefactoredInvocation(CtParameterReference<?> paramRef) {
        CtInvocation invocation = paramRef.getParent(CtInvocation.class);
        if (invocation == null) {
            return false;
        }
        return this.getTargetInvocations().contains(invocation);
    }

    protected void createParameterUsedIssue(CtParameter<?> usedParameter, CtParameterReference<?> parameterUsage) {
        throw new RefactoringException("The parameter " + usedParameter.getSimpleName() + " cannot be removed because it is used (" + parameterUsage.getPosition() + ")");
    }

    protected void createExpressionCannotBeRemovedIssue(CtInvocation<?> invocation, CtExpression<?> toBeRemovedExpression) {
        throw new RefactoringException("The expression " + toBeRemovedExpression + ", which creates argument of the to be removed parameter in invocation " + invocation + " cannot be removed. Override method `canRemoveExpression` to customize this behavior.");
    }

    protected void refactorNoCheck() {
        this.removeInvocationArguments();
        this.removeMethodParameters();
    }

    protected void removeInvocationArguments() {
        List<CtInvocation<?>> invocations = this.getTargetInvocations();
        for (CtInvocation<?> invocation : invocations) {
            this.removeInvocationArgument(invocation);
        }
    }

    protected void removeInvocationArgument(CtInvocation<?> invocation) {
        invocation.removeArgument(invocation.getArguments().get(this.parameterIndex));
    }

    protected void removeMethodParameters() {
        List<CtExecutable<?>> executables = this.getTargetExecutables();
        for (CtExecutable<?> executable : executables) {
            this.removeParameter(executable);
        }
    }

    protected void removeParameter(CtExecutable<?> executable) {
        executable.removeParameter(executable.getParameters().get(this.parameterIndex));
    }
}

