/*
 * Decompiled with CFR 0.152.
 */
package spoon.pattern.internal.parameter;

import java.util.Map;
import java.util.function.Function;
import spoon.pattern.internal.parameter.AbstractParameterInfo;
import spoon.support.util.ImmutableMap;
import spoon.support.util.ImmutableMapImpl;

public class MapParameterInfo
extends AbstractParameterInfo {
    private final String name;
    private static final ImmutableMap EMPTY = new ImmutableMapImpl();

    public MapParameterInfo(String name) {
        this(name, null);
    }

    public MapParameterInfo(AbstractParameterInfo next) {
        this(null, next);
    }

    public MapParameterInfo(String name, AbstractParameterInfo next) {
        super(next);
        this.name = name;
    }

    @Override
    protected String getPlainName() {
        return this.getWrappedName(this.getContainerName());
    }

    @Override
    protected String getWrappedName(String containerName) {
        if (this.name == null) {
            return containerName;
        }
        if (!((String)containerName).isEmpty()) {
            containerName = (String)containerName + ".";
        }
        return (String)containerName + this.name;
    }

    @Override
    protected Object addValueAs(Object container, Function<Object, Object> merger) {
        ImmutableMap parameters = this.castTo(container, ImmutableMap.class);
        if (this.name == null) {
            Object newValue = merger.apply(null);
            if (newValue == null) {
                return parameters;
            }
            if (newValue == NO_MERGE) {
                return NO_MERGE;
            }
            if (newValue instanceof Map.Entry) {
                Map.Entry newEntry = (Map.Entry)newValue;
                String newEntryKey = (String)newEntry.getKey();
                Object existingValue = parameters.getValue(newEntryKey);
                Object newEntryValue = this.merge(existingValue, newEntry.getValue());
                if (newEntryValue == NO_MERGE) {
                    return NO_MERGE;
                }
                if (existingValue == newEntryValue) {
                    return parameters;
                }
                return parameters.putValue(newEntryKey, newEntryValue);
            }
            if (newValue instanceof Map) {
                Map newMap = (Map)newValue;
                for (Map.Entry newEntry : newMap.entrySet()) {
                    String newEntryKey = (String)newEntry.getKey();
                    Object existingValue = parameters.getValue(newEntryKey);
                    Object newEntryValue = this.merge(existingValue, newEntry.getValue());
                    if (newEntryValue == NO_MERGE) {
                        return NO_MERGE;
                    }
                    if (existingValue == newEntryValue) continue;
                    parameters = parameters.putValue(newEntryKey, newEntryValue);
                }
                return parameters;
            }
            return NO_MERGE;
        }
        Object existingValue = parameters.getValue(this.name);
        Object newValue = merger.apply(existingValue);
        if (newValue == NO_MERGE) {
            return NO_MERGE;
        }
        if (existingValue == newValue) {
            return parameters;
        }
        return parameters.putValue(this.name, newValue);
    }

    @Override
    protected Object getValue(ImmutableMap parameters) {
        ImmutableMap map = this.castTo(super.getValue(parameters), ImmutableMap.class);
        return this.name == null ? map : map.getValue(this.name);
    }

    @Override
    protected <T> T castTo(Object o, Class<T> type) {
        if (o instanceof Map) {
            o = new ImmutableMapImpl((Map)o);
        }
        return super.castTo(o, type);
    }

    protected ImmutableMap getEmptyContainer() {
        return EMPTY;
    }
}

