/*
 * Decompiled with CFR 0.152.
 */
package spoon.pattern.internal.parameter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import spoon.pattern.internal.parameter.AbstractParameterInfo;
import spoon.pattern.internal.parameter.ParameterInfo;
import spoon.support.util.ImmutableMap;

public class ListParameterInfo
extends AbstractParameterInfo {
    private final int idx;

    public ListParameterInfo(ParameterInfo next) {
        this(-1, next);
    }

    public ListParameterInfo(int idx, ParameterInfo next) {
        super(next);
        this.idx = idx;
    }

    @Override
    protected String getPlainName() {
        return this.getWrappedName(this.getContainerName());
    }

    @Override
    protected String getWrappedName(String containerName) {
        if (this.idx < 0) {
            return containerName;
        }
        return containerName + "[" + this.idx + "]";
    }

    @Override
    protected Object addValueAs(Object container, Function<Object, Object> merger) {
        List list = this.castTo(container, List.class);
        Object existingValue = this.getExistingValue(list);
        Object newValue = merger.apply(existingValue);
        if (newValue == NO_MERGE) {
            return NO_MERGE;
        }
        if (existingValue == newValue) {
            return list;
        }
        if (newValue == null) {
            return list;
        }
        ArrayList<Object> newList = new ArrayList<Object>(list.size() + 1);
        newList.addAll(list);
        if (this.idx >= 0) {
            while (this.idx >= newList.size()) {
                newList.add(null);
            }
            newList.set(this.idx, newValue);
        } else if (newValue instanceof Collection) {
            newList.addAll((Collection)newValue);
        } else {
            newList.add(newValue);
        }
        return Collections.unmodifiableList(newList);
    }

    protected Object getExistingValue(List<Object> list) {
        if (list == null || this.idx < 0 || this.idx >= list.size()) {
            return null;
        }
        return list.get(this.idx);
    }

    protected List<Object> getEmptyContainer() {
        return Collections.emptyList();
    }

    @Override
    protected Object getValue(ImmutableMap parameters) {
        List list = this.castTo(super.getValue(parameters), List.class);
        if (this.idx < 0) {
            return list;
        }
        if (this.idx < list.size()) {
            return list.get(this.idx);
        }
        return null;
    }

    @Override
    protected <T> T castTo(Object o, Class<T> type) {
        if (o instanceof Set) {
            o = new ArrayList((Set)((Object)o));
        } else if (o instanceof Object[]) {
            o = Arrays.asList((Object[])o);
        }
        return super.castTo(o, type);
    }
}

