/*
 * Decompiled with CFR 0.152.
 */
package spoon.pattern.internal.node;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import spoon.SpoonException;
import spoon.pattern.internal.DefaultGenerator;
import spoon.pattern.internal.ResultHolder;
import spoon.pattern.internal.matcher.Matchers;
import spoon.pattern.internal.matcher.TobeMatched;
import spoon.pattern.internal.node.AbstractNode;
import spoon.pattern.internal.node.InlineNode;
import spoon.pattern.internal.node.PrimitiveMatcher;
import spoon.pattern.internal.node.RootNode;
import spoon.pattern.internal.parameter.ParameterInfo;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtStatement;
import spoon.reflect.factory.CoreFactory;
import spoon.reflect.factory.Factory;
import spoon.support.util.ImmutableMap;

public class SwitchNode
extends AbstractNode
implements InlineNode {
    private List<CaseNode> cases = new ArrayList<CaseNode>();

    @Override
    public boolean replaceNode(RootNode oldNode, RootNode newNode) {
        for (CaseNode caseNode : this.cases) {
            if (!caseNode.replaceNode(oldNode, newNode)) continue;
            return true;
        }
        return false;
    }

    public void addCase(PrimitiveMatcher vrOfExpression, RootNode statement) {
        this.cases.add(new CaseNode(vrOfExpression, statement));
    }

    @Override
    public <T> void generateTargets(DefaultGenerator generator, ResultHolder<T> result, ImmutableMap parameters) {
        for (CaseNode case1 : this.cases) {
            if (!case1.isCaseSelected(generator, parameters)) continue;
            generator.generateTargets((RootNode)case1, result, parameters);
            return;
        }
    }

    @Override
    public void forEachParameterInfo(BiConsumer<ParameterInfo, RootNode> consumer) {
        for (CaseNode case1 : this.cases) {
            if (case1.vrOfExpression != null) {
                case1.vrOfExpression.forEachParameterInfo(consumer);
            }
            if (case1.statement == null) continue;
            case1.statement.forEachParameterInfo(consumer);
        }
    }

    @Override
    public TobeMatched matchTargets(TobeMatched targets, Matchers nextMatchers) {
        boolean hasDefaultCase = false;
        for (CaseNode case1 : this.cases) {
            TobeMatched match = case1.matchTargets(targets, nextMatchers);
            if (match != null) {
                return match;
            }
            if (case1.vrOfExpression != null) continue;
            hasDefaultCase = true;
        }
        if (hasDefaultCase) {
            return null;
        }
        return new CaseNode(null, null).matchTargets(targets, nextMatchers);
    }

    @Override
    public <T> void generateInlineTargets(DefaultGenerator generator, ResultHolder<T> result, ImmutableMap parameters) {
        CtIf resultStmt = null;
        CtStatement lastElse = null;
        CtIf lastIf = null;
        for (CaseNode caseNode : this.cases) {
            CtStatement stmt = generator.generateSingleTarget(caseNode, parameters, CtStatement.class);
            if (stmt instanceof CtIf) {
                CtIf ifStmt = (CtIf)stmt;
                if (lastIf == null) {
                    resultStmt = ifStmt;
                    lastIf = ifStmt;
                    continue;
                }
                lastIf.setElseStatement(ifStmt);
                lastIf = ifStmt;
                continue;
            }
            if (lastElse != null) {
                throw new SpoonException("Only one SwitchNode can have no expression.");
            }
            lastElse = stmt;
        }
        if (lastIf == null) {
            if (lastElse != null) {
                result.addResult(lastElse);
            }
            return;
        }
        if (lastElse != null) {
            lastIf.setElseStatement(lastElse);
        }
        result.addResult(resultStmt);
    }

    private class CaseNode
    extends AbstractNode
    implements InlineNode {
        private PrimitiveMatcher vrOfExpression;
        private RootNode statement;

        private CaseNode(PrimitiveMatcher vrOfExpression, RootNode statement) {
            this.vrOfExpression = vrOfExpression;
            this.statement = statement;
        }

        @Override
        public boolean replaceNode(RootNode oldNode, RootNode newNode) {
            if (this.vrOfExpression != null) {
                if (this.vrOfExpression == oldNode) {
                    this.vrOfExpression = (PrimitiveMatcher)newNode;
                    return true;
                }
                if (this.vrOfExpression.replaceNode(oldNode, newNode)) {
                    return true;
                }
            }
            if (this.statement != null) {
                if (this.statement == oldNode) {
                    this.statement = newNode;
                    return true;
                }
                return this.statement.replaceNode(oldNode, newNode);
            }
            return false;
        }

        @Override
        public TobeMatched matchTargets(TobeMatched targets, Matchers nextMatchers) {
            ImmutableMap parameters = targets.getParameters();
            for (CaseNode case1 : SwitchNode.this.cases) {
                if (case1.vrOfExpression == null || (parameters = case1.vrOfExpression.matchTarget(case1 == this, parameters)) != null) continue;
                return null;
            }
            targets = targets.copyAndSetParams(parameters);
            if (this.statement != null) {
                return this.statement.matchTargets(targets, nextMatchers);
            }
            return nextMatchers.matchAllWith(targets);
        }

        @Override
        public void forEachParameterInfo(BiConsumer<ParameterInfo, RootNode> consumer) {
            SwitchNode.this.forEachParameterInfo(consumer);
        }

        @Override
        public <T> void generateTargets(DefaultGenerator generator, ResultHolder<T> result, ImmutableMap parameters) {
            if (this.statement != null) {
                generator.generateTargets(this.statement, result, parameters);
            }
        }

        private boolean isCaseSelected(DefaultGenerator generator, ImmutableMap parameters) {
            if (this.vrOfExpression == null) {
                return true;
            }
            Boolean value = generator.generateSingleTarget(this.vrOfExpression, parameters, Boolean.class);
            return value == null ? false : value;
        }

        @Override
        public <T> void generateInlineTargets(DefaultGenerator generator, ResultHolder<T> result, ImmutableMap parameters) {
            Factory f = generator.getFactory();
            CoreFactory cf = f.Core();
            CtBlock block = cf.createBlock();
            if (this.statement != null) {
                block.setStatements(generator.generateTargets(this.statement, parameters, CtStatement.class));
            }
            if (this.vrOfExpression != null) {
                CtIf ifStmt = cf.createIf();
                ifStmt.setCondition(generator.generateSingleTarget(this.vrOfExpression, parameters, CtExpression.class));
                ifStmt.setThenStatement(block);
                result.addResult(ifStmt);
            } else {
                result.addResult((CtIf)((Object)block));
            }
        }
    }
}

