/*
 * Decompiled with CFR 0.152.
 */
package spoon.pattern.internal.node;

import java.util.Map;
import java.util.function.BiConsumer;
import spoon.SpoonException;
import spoon.pattern.Quantifier;
import spoon.pattern.internal.DefaultGenerator;
import spoon.pattern.internal.ResultHolder;
import spoon.pattern.internal.matcher.TobeMatched;
import spoon.pattern.internal.node.AbstractPrimitiveMatcher;
import spoon.pattern.internal.node.ParameterNode;
import spoon.pattern.internal.node.RootNode;
import spoon.pattern.internal.parameter.ParameterInfo;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.meta.ContainerKind;
import spoon.support.util.ImmutableMap;

public class MapEntryNode
extends AbstractPrimitiveMatcher {
    private RootNode key;
    private RootNode value;

    public MapEntryNode(RootNode key, RootNode value) {
        this.key = key;
        this.value = value;
    }

    public RootNode getKey() {
        return this.key;
    }

    public RootNode getValue() {
        return this.value;
    }

    @Override
    public boolean replaceNode(RootNode oldNode, RootNode newNode) {
        if (this.key == oldNode) {
            this.key = newNode;
            return true;
        }
        if (this.value == oldNode) {
            this.value = newNode;
            return true;
        }
        if (this.key.replaceNode(oldNode, newNode)) {
            return true;
        }
        return this.value.replaceNode(oldNode, newNode);
    }

    @Override
    public void forEachParameterInfo(BiConsumer<ParameterInfo, RootNode> consumer) {
        this.key.forEachParameterInfo(consumer);
        this.value.forEachParameterInfo(consumer);
    }

    @Override
    public <T> void generateTargets(DefaultGenerator generator, ResultHolder<T> result, ImmutableMap parameters) {
        String entryKey = generator.generateSingleTarget(this.key, parameters, String.class);
        CtElement entryValue = generator.generateSingleTarget(this.value, parameters, CtElement.class);
        if (entryKey != null && entryValue != null) {
            result.addResult(new Entry(entryKey, entryValue));
        }
    }

    @Override
    public ImmutableMap matchTarget(Object target, ImmutableMap parameters) {
        if (target instanceof Map.Entry) {
            Map.Entry targetEntry = (Map.Entry)target;
            parameters = TobeMatched.getMatchedParameters(this.getKey().matchAllWith(TobeMatched.create(parameters, ContainerKind.SINGLE, targetEntry.getKey())));
            if (parameters == null) {
                return null;
            }
            return TobeMatched.getMatchedParameters(this.getValue().matchAllWith(TobeMatched.create(parameters, ContainerKind.SINGLE, targetEntry.getValue())));
        }
        throw new SpoonException("Unexpected target type " + target.getClass().getName());
    }

    @Override
    public Quantifier getMatchingStrategy() {
        if (this.key instanceof ParameterNode) {
            return ((ParameterNode)this.key).getMatchingStrategy();
        }
        return Quantifier.POSSESSIVE;
    }

    @Override
    public boolean isTryNextMatch(ImmutableMap parameters) {
        if (this.key instanceof ParameterNode) {
            return ((ParameterNode)this.key).isTryNextMatch(parameters);
        }
        return false;
    }

    private static class Entry
    implements Map.Entry<String, CtElement> {
        private final String key;
        private CtElement value;

        Entry(String key, CtElement value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public CtElement getValue() {
            return this.value;
        }

        @Override
        public CtElement setValue(CtElement value) {
            CtElement oldV = this.value;
            this.value = value;
            return oldV;
        }
    }
}

