/*
 * Decompiled with CFR 0.152.
 */
package spoon.pattern.internal.node;

import spoon.SpoonException;
import spoon.pattern.internal.matcher.Matchers;
import spoon.pattern.internal.matcher.TobeMatched;
import spoon.pattern.internal.node.AbstractNode;
import spoon.pattern.internal.node.RepeatableMatcher;

abstract class AbstractRepeatableMatcher
extends AbstractNode
implements RepeatableMatcher {
    AbstractRepeatableMatcher() {
    }

    @Override
    public TobeMatched matchTargets(TobeMatched targets, Matchers next) {
        if (!this.isRepeatable()) {
            boolean isMandatory = this.isMandatory(targets.getParameters());
            TobeMatched tmp = this.matchAllWith(targets);
            if (tmp == null) {
                if (isMandatory) {
                    return null;
                }
            } else {
                targets = tmp;
            }
            return next.matchAllWith(targets);
        }
        while (this.isMandatory(targets.getParameters())) {
            TobeMatched tmp = this.matchAllWith(targets);
            if (tmp == null) {
                return null;
            }
            if (!this.isTryNextMatch(tmp.getParameters())) {
                return next.matchAllWith(tmp);
            }
            targets = tmp;
        }
        return this.matchOptionalTargets(targets, next);
    }

    private TobeMatched matchOptionalTargets(TobeMatched targets, Matchers next) {
        if (!this.isTryNextMatch(targets.getParameters())) {
            return next.matchAllWith(targets);
        }
        switch (this.getMatchingStrategy()) {
            case GREEDY: {
                TobeMatched match = this.matchAllWith(targets);
                if (match != null && (match = this.matchOptionalTargets(match, next)) != null) {
                    return match;
                }
                return next.matchAllWith(targets);
            }
            case RELUCTANT: {
                TobeMatched match = next.matchAllWith(targets);
                if (match != null) {
                    return match;
                }
                match = this.matchAllWith(targets);
                if (match == null) {
                    return null;
                }
                return this.matchOptionalTargets(match, next);
            }
            case POSSESSIVE: {
                while (this.isTryNextMatch(targets.getParameters())) {
                    TobeMatched tmp = this.matchAllWith(targets);
                    if (tmp == null) {
                        if (!this.isMandatory(targets.getParameters())) break;
                        return null;
                    }
                    targets = tmp;
                }
                return next.matchAllWith(targets);
            }
        }
        throw new SpoonException("Unsupported quantifier " + this.getMatchingStrategy());
    }
}

