/*
 * Decompiled with CFR 0.152.
 */
package spoon.pattern.internal.matcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import spoon.SpoonException;
import spoon.reflect.meta.ContainerKind;
import spoon.support.util.ImmutableMap;

public class TobeMatched {
    private final ImmutableMap parameters;
    private final List<?> targets;
    private final boolean ordered;

    public static TobeMatched create(ImmutableMap parameters, ContainerKind containerKind, Object target) {
        switch (containerKind) {
            case LIST: {
                return new TobeMatched(parameters, (List)target, true);
            }
            case SET: {
                return new TobeMatched(parameters, (Set)target, false);
            }
            case MAP: {
                return new TobeMatched(parameters, (Map)target);
            }
            case SINGLE: {
                return new TobeMatched(parameters, target);
            }
        }
        throw new SpoonException("Unexpected RoleHandler containerKind: " + containerKind);
    }

    private TobeMatched(ImmutableMap parameters, Object target) {
        this.parameters = parameters;
        this.targets = Collections.singletonList(target);
        this.ordered = true;
    }

    private TobeMatched(ImmutableMap parameters, Collection<?> targets, boolean ordered) {
        this.parameters = parameters;
        this.targets = targets == null ? Collections.emptyList() : this.copyToListWithoutNullValues(targets);
        this.ordered = ordered;
    }

    private TobeMatched(ImmutableMap parameters, Map<String, ?> targets) {
        this.parameters = parameters;
        this.targets = targets == null ? Collections.emptyList() : this.copyToListWithoutNullValues(targets.entrySet());
        this.ordered = false;
    }

    private TobeMatched(ImmutableMap parameters, List<?> targets, boolean ordered, int tobeRemovedIndex) {
        this.parameters = parameters;
        this.targets = new ArrayList(targets);
        if (tobeRemovedIndex >= 0) {
            this.targets.remove(tobeRemovedIndex);
        }
        this.ordered = ordered;
    }

    private <T> List<T> copyToListWithoutNullValues(Collection<T> collection) {
        return collection.stream().filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
    }

    public ImmutableMap getParameters() {
        return this.parameters;
    }

    public List<?> getTargets() {
        return this.targets;
    }

    public List<?> getMatchedTargets(TobeMatched tobeMatchedTargets) {
        int nrOfMatches = this.getTargets().size() - tobeMatchedTargets.getTargets().size();
        if (nrOfMatches >= 0) {
            if (nrOfMatches == 0) {
                return Collections.emptyList();
            }
            ArrayList matched = new ArrayList(nrOfMatches);
            for (Object target : this.getTargets()) {
                if (this.containsSame(tobeMatchedTargets.getTargets(), target)) continue;
                matched.add(target);
            }
            if (matched.size() == nrOfMatches) {
                return matched;
            }
        }
        throw new SpoonException("Invalid input `originTobeMatched`");
    }

    private boolean containsSame(List<?> items, Object object) {
        for (Object item : items) {
            if (item != object) continue;
            return true;
        }
        return false;
    }

    public boolean hasTargets() {
        return !this.targets.isEmpty();
    }

    public TobeMatched copyAndSetParams(ImmutableMap newParams) {
        if (this.parameters == newParams) {
            return this;
        }
        return new TobeMatched(newParams, this.targets, this.ordered, -1);
    }

    public @Nullable TobeMatched matchNext(BiFunction<Object, ImmutableMap, ImmutableMap> matcher) {
        if (this.targets.isEmpty()) {
            return null;
        }
        if (this.ordered) {
            ImmutableMap parameters = matcher.apply(this.targets.get(0), this.getParameters());
            if (parameters != null) {
                return this.removeTarget(parameters, 0);
            }
            return null;
        }
        for (int idxOfMatch = 0; idxOfMatch < this.targets.size(); ++idxOfMatch) {
            ImmutableMap parameters = matcher.apply(this.targets.get(idxOfMatch), this.getParameters());
            if (parameters == null) continue;
            return this.removeTarget(parameters, idxOfMatch);
        }
        return null;
    }

    public static @Nullable ImmutableMap getMatchedParameters(TobeMatched remainingMatch) {
        return remainingMatch == null ? null : remainingMatch.getParameters();
    }

    public TobeMatched removeTarget(int idxOfTobeRemovedTarget) {
        return this.removeTarget(this.parameters, idxOfTobeRemovedTarget);
    }

    public TobeMatched removeTarget(ImmutableMap parameters, int idxOfTobeRemovedTarget) {
        return new TobeMatched(parameters, this.targets, this.ordered, idxOfTobeRemovedTarget);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Parameters:\n----------------\n").append(this.parameters).append("\nTobe matched target elements\n-----------------------\n");
        for (int i = 0; i < this.targets.size(); ++i) {
            sb.append('\n').append(i + 1).append('/').append(this.targets.size()).append(": ").append(this.targets.get(i));
        }
        return sb.toString();
    }
}

