/*
 * Decompiled with CFR 0.152.
 */
package spoon.pattern.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import spoon.SpoonException;

public abstract class ResultHolder<T> {
    private final Class<T> requiredClass;

    protected ResultHolder(Class<T> requiredClass) {
        this.requiredClass = requiredClass;
    }

    public Class<T> getRequiredClass() {
        return this.requiredClass;
    }

    public abstract boolean isMultiple();

    public abstract void addResult(T var1);

    public abstract void mapEachResult(Function<T, T> var1);

    public abstract List<T> getResults();

    public static class Multiple<T>
    extends ResultHolder<T> {
        List<T> result = new ArrayList<T>();

        public Multiple(Class<T> requiredClass) {
            super(requiredClass);
        }

        @Override
        public boolean isMultiple() {
            return true;
        }

        @Override
        public void addResult(T value) {
            this.result.add(value);
        }

        public List<T> getResult() {
            return this.result;
        }

        @Override
        public List<T> getResults() {
            return this.result;
        }

        @Override
        public void mapEachResult(Function<T, T> consumer) {
            ListIterator<T> iter = this.result.listIterator();
            while (iter.hasNext()) {
                iter.set(consumer.apply(iter.next()));
            }
        }
    }

    public static class Single<T>
    extends ResultHolder<T> {
        private T result;

        public Single(Class<T> requiredClass) {
            super(requiredClass);
        }

        @Override
        public boolean isMultiple() {
            return false;
        }

        @Override
        public void addResult(T value) {
            if (this.result != null) {
                throw new SpoonException("Cannot add second value into single value ConversionContext");
            }
            this.result = value;
        }

        public T getResult() {
            return this.result;
        }

        @Override
        public void mapEachResult(Function<T, T> consumer) {
            this.result = consumer.apply(this.result);
        }

        @Override
        public List<T> getResults() {
            return this.result == null ? Collections.emptyList() : Collections.singletonList(this.result);
        }
    }
}

