/*
 * Decompiled with CFR 0.152.
 */
package spoon.pattern.internal;

import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import spoon.SpoonException;
import spoon.pattern.Generator;
import spoon.pattern.internal.ResultHolder;
import spoon.pattern.internal.node.ElementNode;
import spoon.pattern.internal.node.ListOfNodes;
import spoon.pattern.internal.node.ParameterNode;
import spoon.pattern.internal.node.RootNode;
import spoon.pattern.internal.node.SwitchNode;
import spoon.pattern.internal.parameter.ParameterInfo;
import spoon.reflect.code.CtCodeElement;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtStatement;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeMember;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtTypeReference;
import spoon.support.SpoonClassNotFoundException;
import spoon.support.util.ImmutableMap;
import spoon.support.util.ImmutableMapImpl;

public class DefaultGenerator
implements Generator {
    protected final Factory factory;
    private boolean addGeneratedBy = false;
    private ListOfNodes nodes;

    public DefaultGenerator(Factory factory, ListOfNodes nodes) {
        this.nodes = nodes;
        this.factory = factory;
    }

    public <T> @Nullable T generateSingleTarget(RootNode node, ImmutableMap parameters, Class<T> expectedType) {
        ResultHolder.Single<T> result = new ResultHolder.Single<T>(expectedType);
        this.generateTargets(node, result, parameters);
        return result.getResult();
    }

    public <T> List<T> generateTargets(RootNode node, ImmutableMap parameters, Class<T> expectedType) {
        ResultHolder.Multiple<T> result = new ResultHolder.Multiple<T>(expectedType);
        this.generateTargets(node, result, parameters);
        return result.getResult();
    }

    public <T> void generateTargets(RootNode node, ResultHolder<T> result, ImmutableMap parameters) {
        node.generateTargets(this, result, parameters);
        if (node.isSimplifyGenerated()) {
            result.mapEachResult(element -> {
                if (element instanceof CtCodeElement) {
                    CtCodeElement code = (CtCodeElement)element;
                    try {
                        code = code.partiallyEvaluate();
                        if (result.getRequiredClass().isInstance(code)) {
                            return code;
                        }
                    }
                    catch (SpoonClassNotFoundException e) {
                        this.getFactory().getEnvironment().debugMessage("Partial evaluation was skipped because of: " + e.getMessage());
                    }
                }
                return element;
            });
        }
    }

    public <T> void getValueAs(ParameterInfo parameterInfo, ResultHolder<T> result, ImmutableMap parameters) {
        parameterInfo.getValueAs(this.factory, result, parameters);
    }

    @Override
    public Factory getFactory() {
        return this.factory;
    }

    public DefaultGenerator setAddGeneratedBy(boolean addGeneratedBy) {
        this.addGeneratedBy = addGeneratedBy;
        return this;
    }

    public void applyGeneratedBy(CtElement generatedElement, String genBy) {
        if (this.isAddGeneratedBy() && generatedElement instanceof CtTypeMember && genBy != null) {
            this.addGeneratedByComment(generatedElement, genBy);
        }
    }

    public String getGeneratedByComment(CtElement ele) {
        CtType<?> mainType;
        CompilationUnit cu;
        SourcePosition pos = ele.getPosition();
        if (pos != null && pos.isValidPosition() && (cu = pos.getCompilationUnit()) != null && (mainType = cu.getMainType()) != null) {
            StringBuilder result = new StringBuilder();
            result.append("Generated by ");
            result.append(mainType.getQualifiedName());
            this.appendInnerTypedElements(result, mainType, ele);
            result.append('(');
            result.append(mainType.getSimpleName());
            result.append(".java:");
            result.append(pos.getLine());
            result.append(')');
            return result.toString();
        }
        return null;
    }

    private void appendInnerTypedElements(StringBuilder result, CtType<?> mainType, CtElement ele) {
        CtTypeMember typeMember = this.getFirst(ele, CtTypeMember.class);
        if (typeMember != null && !this.isMainType(typeMember, mainType)) {
            if (typeMember.isParentInitialized()) {
                this.appendInnerTypedElements(result, mainType, typeMember.getParent());
            }
            if (typeMember instanceof CtType) {
                result.append('$');
            } else {
                result.append('#');
            }
            result.append(typeMember.getSimpleName());
        }
    }

    private boolean isMainType(CtTypeMember tm, CtType<?> mainType) {
        if (tm instanceof CtType) {
            return mainType.getQualifiedName().equals(((CtType)tm).getQualifiedName());
        }
        return false;
    }

    private <T extends CtElement> T getFirst(CtElement ele, Class<T> clazz) {
        if (ele != null) {
            if (clazz.isAssignableFrom(ele.getClass())) {
                return (T)ele;
            }
            if (ele.isParentInitialized()) {
                return this.getFirst(ele.getParent(), clazz);
            }
        }
        return null;
    }

    private void addGeneratedByComment(CtElement ele, String generatedBy) {
        if (generatedBy == null) {
            return;
        }
        String EOL = System.getProperty("line.separator");
        CtComment comment = this.getJavaDoc(ele);
        Object content = comment.getContent();
        if (!((String)content).trim().isEmpty()) {
            content = (String)content + EOL + EOL;
        }
        content = (String)content + generatedBy;
        comment.setContent((String)content);
    }

    private CtComment getJavaDoc(CtElement ele) {
        for (CtComment comment : ele.getComments()) {
            if (comment.getCommentType() != CtComment.CommentType.JAVADOC) continue;
            return comment;
        }
        CtComment c = ele.getFactory().Code().createComment("", CtComment.CommentType.JAVADOC);
        ele.addComment(c);
        return c;
    }

    @Override
    public <T extends CtElement> List<T> generate(ImmutableMap params) {
        Class<Object> valueType = null;
        RootNode node = this.nodes.getNodes().get(0);
        if (node instanceof ElementNode) {
            valueType = ((ElementNode)node).getElementType().getMetamodelInterface().getActualClass();
        } else if (node instanceof ParameterNode) {
            valueType = ((ParameterNode)node).getParameterInfo().getParameterValueType();
        } else if (node instanceof SwitchNode) {
            valueType = CtStatement.class;
        } else {
            throw new SpoonException("node type not known " + node.getClass());
        }
        if (valueType == null) {
            valueType = Object.class;
        }
        return this.setAddGeneratedBy(this.isAddGeneratedBy()).generateTargets((RootNode)this.nodes, params, valueType);
    }

    @Override
    public <T extends CtElement> List<T> generate(Map<String, Object> params) {
        return this.generate(new ImmutableMapImpl(params));
    }

    @Override
    public <T extends CtType<?>> T generate(String typeQualifiedName, Map<String, Object> params) {
        CtTypeReference newTypeRef = this.factory.Type().createReference(typeQualifiedName);
        CtPackage ownerPackage = newTypeRef.getFactory().Package().getOrCreate(newTypeRef.getPackage().getQualifiedName());
        return this.createType(ownerPackage, newTypeRef.getSimpleName(), params);
    }

    private <T extends CtType<?>> T createType(CtPackage ownerPackage, String typeSimpleName, Map<String, Object> params) {
        List<T> types = this.generate(new ImmutableMapImpl(params, "targetType", ownerPackage.getFactory().Type().createReference(DefaultGenerator.getQualifiedName(ownerPackage, typeSimpleName))));
        CtType result = null;
        for (CtType type : types) {
            ownerPackage.addType(type);
            if (!type.getSimpleName().equals(typeSimpleName)) continue;
            result = type;
        }
        return (T)result;
    }

    private static String getQualifiedName(CtPackage pckg, String simpleName) {
        if (pckg.isUnnamedPackage()) {
            return simpleName;
        }
        return pckg.getQualifiedName() + "." + simpleName;
    }

    public boolean isAddGeneratedBy() {
        return this.addGeneratedBy;
    }
}

