/*
 * Decompiled with CFR 0.152.
 */
package spoon.pattern;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import spoon.SpoonException;
import spoon.metamodel.Metamodel;
import spoon.pattern.ConflictResolutionMode;
import spoon.pattern.InlinedStatementConfigurator;
import spoon.pattern.PatternBuilder;
import spoon.pattern.Quantifier;
import spoon.pattern.internal.node.ListOfNodes;
import spoon.pattern.internal.node.MapEntryNode;
import spoon.pattern.internal.node.ParameterNode;
import spoon.pattern.internal.node.RootNode;
import spoon.pattern.internal.node.StringNode;
import spoon.pattern.internal.parameter.AbstractParameterInfo;
import spoon.pattern.internal.parameter.ComputedParameterInfo;
import spoon.pattern.internal.parameter.ListParameterInfo;
import spoon.pattern.internal.parameter.MapParameterInfo;
import spoon.pattern.internal.parameter.ParameterInfo;
import spoon.pattern.internal.parameter.SimpleNameOfTypeReferenceParameterComputer;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeMember;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.factory.Factory;
import spoon.reflect.meta.ContainerKind;
import spoon.reflect.meta.RoleHandler;
import spoon.reflect.meta.impl.RoleHandlerHelper;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.chain.CtQueryable;
import spoon.reflect.visitor.filter.AllTypeMembersFunction;
import spoon.reflect.visitor.filter.InvocationFilter;
import spoon.reflect.visitor.filter.NamedElementFilter;
import spoon.reflect.visitor.filter.PotentialVariableDeclarationFunction;
import spoon.reflect.visitor.filter.VariableReferenceFunction;
import spoon.support.Experimental;
import spoon.template.Parameter;
import spoon.template.TemplateParameter;

@Experimental
public class PatternParameterConfigurator {
    private final PatternBuilder patternBuilder;
    private final Map<String, AbstractParameterInfo> parameterInfos;
    private AbstractParameterInfo currentParameter;
    private List<CtElement> substitutedNodes = new ArrayList<CtElement>();
    private ConflictResolutionMode conflictResolutionMode = ConflictResolutionMode.FAIL;

    PatternParameterConfigurator(PatternBuilder patternBuilder, Map<String, AbstractParameterInfo> parameterInfos) {
        this.patternBuilder = patternBuilder;
        this.parameterInfos = parameterInfos;
    }

    public ConflictResolutionMode getConflictResolutionMode() {
        return this.conflictResolutionMode;
    }

    public PatternParameterConfigurator setConflictResolutionMode(ConflictResolutionMode conflictResolutionMode) {
        this.conflictResolutionMode = conflictResolutionMode;
        return this;
    }

    public CtQueryable queryModel() {
        return this.patternBuilder.patternQuery;
    }

    private AbstractParameterInfo getParameterInfo(String parameterName, boolean createIfNotExist) {
        return this.parameterInfos.computeIfAbsent(parameterName, k -> new MapParameterInfo((String)k).setValueConvertor(this.patternBuilder.getDefaultValueConvertor()));
    }

    public PatternParameterConfigurator parameter(String paramName) {
        this.currentParameter = this.getParameterInfo(paramName, true);
        this.substitutedNodes.clear();
        return this;
    }

    public PatternParameterConfigurator setMinOccurrence(int minOccurrence) {
        this.currentParameter.setMinOccurrences(minOccurrence);
        return this;
    }

    public PatternParameterConfigurator setMaxOccurrence(int maxOccurrence) {
        if (maxOccurrence == Integer.MAX_VALUE || maxOccurrence > 1 && !this.currentParameter.isMultiple()) {
            throw new SpoonException("Cannot set maxOccurrences > 1 for single value parameter. Call setMultiple(true) first.");
        }
        this.currentParameter.setMaxOccurrences(maxOccurrence);
        return this;
    }

    public PatternParameterConfigurator setMatchingStrategy(Quantifier quantifier) {
        this.currentParameter.setMatchingStrategy(quantifier);
        return this;
    }

    public PatternParameterConfigurator setValueType(Class<?> valueType) {
        this.currentParameter.setParameterValueType(valueType);
        return this;
    }

    public PatternParameterConfigurator setContainerKind(ContainerKind containerKind) {
        this.currentParameter.setContainerKind(containerKind);
        return this;
    }

    public ParameterInfo getCurrentParameter() {
        if (this.currentParameter == null) {
            throw new SpoonException("Parameter name must be defined first by call of #parameter(String) method.");
        }
        return this.currentParameter;
    }

    public PatternParameterConfigurator byType(Class<?> type) {
        return this.byType(type.getName());
    }

    public PatternParameterConfigurator byType(String typeQualifiedName) {
        ParameterInfo pi = this.getCurrentParameter();
        this.queryModel().filterChildren(typeRef -> typeRef.getQualifiedName().equals(typeQualifiedName)).forEach(typeRef -> this.addSubstitutionRequest(pi, (CtElement)typeRef));
        CtType type2 = (CtType)this.queryModel().filterChildren(t -> t.getQualifiedName().equals(typeQualifiedName)).first();
        if (type2 != null) {
            this.addSubstitutionRequest(pi, type2, CtRole.NAME);
        }
        return this;
    }

    public PatternParameterConfigurator byType(CtTypeReference<?> type) {
        ParameterInfo pi = this.getCurrentParameter();
        this.queryModel().filterChildren(typeRef -> typeRef.equals(type)).forEach(typeRef -> this.addSubstitutionRequest(pi, (CtElement)typeRef));
        String typeQName = type.getQualifiedName();
        CtType type2 = (CtType)this.queryModel().filterChildren(t -> t.getQualifiedName().equals(typeQName)).first();
        if (type2 != null) {
            ComputedParameterInfo piName = new ComputedParameterInfo(SimpleNameOfTypeReferenceParameterComputer.INSTANCE, pi);
            piName.setParameterValueType(String.class);
            this.addSubstitutionRequest(piName, type2, CtRole.NAME);
        }
        return this;
    }

    public PatternParameterConfigurator byLocalType(CtType<?> searchScope, String localTypeSimpleName) {
        this.byLocalType(searchScope, localTypeSimpleName, false);
        return this;
    }

    PatternParameterConfigurator byLocalType(CtType<?> searchScope, String localTypeSimpleName, boolean optional) {
        String nestedType = PatternBuilder.getLocalTypeRefBySimpleName(searchScope, localTypeSimpleName);
        if (nestedType == null) {
            if (optional) {
                return this;
            }
            throw new SpoonException("Template parameter " + localTypeSimpleName + " doesn't match to any local type");
        }
        this.byType(nestedType);
        return this;
    }

    public PatternParameterConfigurator byVariable(String variableName) {
        CtVariable var = (CtVariable)this.queryModel().map(new PotentialVariableDeclarationFunction(variableName)).first();
        if (var != null) {
            this.byVariable(var);
        }
        return this;
    }

    public PatternParameterConfigurator byVariable(CtVariable<?> variable) {
        ParameterInfo pi = this.getCurrentParameter();
        CtVariable<?> root = this.queryModel();
        if (this.patternBuilder.isInModel(variable)) {
            root = variable;
        }
        root.map(new VariableReferenceFunction(variable)).forEach(varRef -> this.addSubstitutionRequest(pi, (CtElement)varRef));
        return this;
    }

    public PatternParameterConfigurator byInvocation(CtMethod<?> method) {
        ParameterInfo pi = this.getCurrentParameter();
        this.queryModel().filterChildren(new InvocationFilter(method)).forEach(inv -> this.addSubstitutionRequest(pi, (CtElement)inv));
        return this;
    }

    public PatternParameterConfigurator byFieldAccessOnVariable(String varName) {
        CtVariable var = (CtVariable)this.queryModel().map(new PotentialVariableDeclarationFunction(varName)).first();
        if (var != null) {
            this.createPatternParameterForVariable(var);
        } else {
            List vars = this.queryModel().filterChildren(new NamedElementFilter<CtVariable>(CtVariable.class, varName)).list();
            if (vars.size() > 1) {
                throw new SpoonException("Ambiguous variable " + varName);
            }
            if (vars.size() == 1) {
                this.createPatternParameterForVariable((CtVariable)vars.get(0));
            }
        }
        return this;
    }

    private void createPatternParameterForVariable(CtVariable<?> variable) {
        CtVariable<?> searchScope;
        if (this.patternBuilder.isInModel(variable)) {
            this.addSubstitutionRequest(this.parameter(variable.getSimpleName()).getCurrentParameter(), variable);
            searchScope = variable;
        } else {
            searchScope = this.queryModel();
        }
        searchScope.map(new VariableReferenceFunction(variable)).forEach(varRef -> {
            CtFieldRead fieldRead = varRef.getParent(CtFieldRead.class);
            if (fieldRead != null) {
                this.addSubstitutionRequest(this.parameter(fieldRead.getVariable().getSimpleName()).getCurrentParameter(), fieldRead);
            } else {
                this.addSubstitutionRequest(this.parameter(varRef.getSimpleName()).getCurrentParameter(), (CtElement)varRef);
            }
        });
    }

    public PatternParameterConfigurator byTemplateParameter() {
        return this.byTemplateParameter(null);
    }

    public PatternParameterConfigurator byTemplateParameter(Map<String, Object> parameterValues) {
        CtType<?> templateType = this.patternBuilder.getTemplateTypeRef().getTypeDeclaration();
        templateType.map(new AllTypeMembersFunction()).forEach(typeMember -> this.configureByTemplateParameter(templateType, parameterValues, (CtTypeMember)typeMember));
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void configureByTemplateParameter(CtType<?> templateType, Map<String, Object> parameterValues, CtTypeMember typeMember) {
        Factory f = typeMember.getFactory();
        CtTypeReference<CtTypeReference> typeReferenceRef = f.Type().createReference(CtTypeReference.class);
        CtTypeReference<CtStatement> ctStatementRef = f.Type().createReference(CtStatement.class);
        CtTypeReference<TemplateParameter> templateParamRef = f.Type().createReference(TemplateParameter.class);
        Parameter param = typeMember.getAnnotation(Parameter.class);
        if (param != null) {
            Object value;
            String nestedType;
            String stringMarker;
            if (!(typeMember instanceof CtField)) throw new SpoonException("Template Parameter annotation on " + typeMember.getClass().getName() + " is not supported");
            CtField paramField = (CtField)typeMember;
            String fieldName = typeMember.getSimpleName();
            String parameterName = stringMarker = param.value() != null && !param.value().isEmpty() ? param.value() : fieldName;
            CtTypeReference paramType = paramField.getType();
            if (paramType.isSubtypeOf(f.Type().createReference(Iterable.class)) || paramType instanceof CtArrayTypeReference) {
                this.parameter(parameterName).setContainerKind(ContainerKind.LIST).byNamedElement(stringMarker).byReferenceName(stringMarker);
            } else if (paramType.isSubtypeOf(typeReferenceRef) || paramType.getQualifiedName().equals(Class.class.getName())) {
                nestedType = PatternBuilder.getLocalTypeRefBySimpleName(templateType, stringMarker);
                if (nestedType != null) {
                    this.parameter(parameterName).byType(nestedType);
                }
                this.parameter(parameterName).byVariable(paramField);
            } else if (paramType.getQualifiedName().equals(String.class.getName())) {
                nestedType = PatternBuilder.getLocalTypeRefBySimpleName(templateType, stringMarker);
                if (nestedType != null) {
                    this.parameter(parameterName).byType(nestedType);
                }
            } else if (paramType.isSubtypeOf(templateParamRef)) {
                this.parameter(parameterName).byTemplateParameterReference(paramField);
                templateType.getMethodsByName(stringMarker).forEach(m -> this.parameter(parameterName).byInvocation((CtMethod<?>)m));
            } else if (paramType.isSubtypeOf(ctStatementRef)) {
                templateType.getMethodsByName(stringMarker).forEach(m -> this.parameter(parameterName).setContainerKind(ContainerKind.LIST).byInvocation((CtMethod<?>)m));
            } else {
                this.parameter(parameterName).byVariable(paramField);
            }
            if (paramType.getQualifiedName().equals(Object.class.getName()) && parameterValues != null && ((value = parameterValues.get(parameterName)) instanceof CtLiteral || value instanceof CtTypeReference)) {
                ParameterInfo pi = this.parameter(parameterName).getCurrentParameter();
                this.queryModel().filterChildren(inv -> inv.getExecutable().getSimpleName().equals(stringMarker)).forEach(inv -> this.addSubstitutionRequest(pi, (CtElement)inv));
            }
            this.parameter(parameterName).setConflictResolutionMode(ConflictResolutionMode.KEEP_OLD_NODE).bySubstring(stringMarker);
            if (parameterValues == null) return;
            this.addInlineStatements(fieldName, parameterValues.get(parameterName));
            return;
        } else {
            if (!(typeMember instanceof CtField) || !((CtField)typeMember).getType().isSubtypeOf(templateParamRef)) return;
            CtField field = (CtField)typeMember;
            String parameterName = typeMember.getSimpleName();
            Object value = parameterValues == null ? null : parameterValues.get(parameterName);
            Class<?> valueType = null;
            boolean multiple = false;
            if (value != null) {
                valueType = value.getClass();
                if (value instanceof CtBlock) {
                    multiple = true;
                }
            }
            this.parameter(parameterName).setValueType(valueType).setContainerKind(multiple ? ContainerKind.LIST : ContainerKind.SINGLE).byTemplateParameterReference(field);
            if (parameterValues == null) return;
            this.addInlineStatements(parameterName, parameterValues.get(parameterName));
        }
    }

    private void addInlineStatements(String variableName, Object paramValue) {
        if (paramValue != null && paramValue.getClass().isArray()) {
            this.patternBuilder.configureInlineStatements(sb -> {
                sb.setFailOnMissingParameter(false);
                sb.inlineIfOrForeachReferringTo(variableName);
            });
        }
    }

    public PatternParameterConfigurator byParameterValues(Map<String, Object> parameterValues) {
        if (parameterValues != null) {
            CtType<?> templateType = this.patternBuilder.getTemplateTypeRef().getTypeDeclaration();
            parameterValues.forEach((paramName, paramValue) -> {
                if (!this.isSubstituted((String)paramName)) {
                    this.parameter((String)paramName).setConflictResolutionMode(ConflictResolutionMode.KEEP_OLD_NODE).byLocalType(templateType, (String)paramName, true);
                    this.parameter((String)paramName).setConflictResolutionMode(ConflictResolutionMode.KEEP_OLD_NODE).bySubstring((String)paramName);
                }
            });
        }
        return this;
    }

    public PatternParameterConfigurator byTemplateParameterReference(CtVariable<?> variable) {
        ParameterInfo pi = this.getCurrentParameter();
        this.queryModel().map(new VariableReferenceFunction(variable)).forEach(varRef -> {
            CtInvocation invocation;
            CtVariableAccess varAccess = (CtVariableAccess)varRef.getParent();
            CtElement invocationOfS = varAccess.getParent();
            if (invocationOfS instanceof CtInvocation && "S".equals((invocation = (CtInvocation)invocationOfS).getExecutable().getSimpleName())) {
                this.addSubstitutionRequest(pi, invocation);
                return;
            }
            throw new SpoonException("TemplateParameter reference is NOT used as target of invocation of TemplateParameter#S()");
        });
        return this;
    }

    public PatternParameterConfigurator byString(final String stringMarker) {
        final ParameterInfo pi = this.getCurrentParameter();
        new StringAttributeScanner(){

            @Override
            protected void visitStringAttribute(RoleHandler roleHandler, CtElement element, String value) {
                if (stringMarker.equals(value)) {
                    PatternParameterConfigurator.this.addSubstitutionRequest(pi, element, roleHandler.getRole());
                }
            }

            @Override
            protected void visitStringAttribute(RoleHandler roleHandler, CtElement element, String mapEntryKey, CtElement mapEntryValue) {
                if (stringMarker.equals(mapEntryKey)) {
                    PatternParameterConfigurator.this.patternBuilder.modifyNodeOfAttributeOfElement(element, roleHandler.getRole(), PatternParameterConfigurator.this.conflictResolutionMode, oldAttrNode -> {
                        if (oldAttrNode instanceof MapEntryNode) {
                            MapEntryNode mapEntryNode = (MapEntryNode)oldAttrNode;
                            return new MapEntryNode(new ParameterNode(pi), mapEntryNode.getValue());
                        }
                        return oldAttrNode;
                    });
                }
            }
        }.scan(this.patternBuilder.getPatternModel());
        return this;
    }

    public PatternParameterConfigurator bySubstring(final String stringMarker) {
        final ParameterInfo pi = this.getCurrentParameter();
        new StringAttributeScanner(){

            @Override
            protected void visitStringAttribute(RoleHandler roleHandler, CtElement element, String value) {
                if (value != null && value.contains(stringMarker)) {
                    PatternParameterConfigurator.this.addSubstitutionRequest(pi, element, roleHandler.getRole(), stringMarker);
                }
            }

            @Override
            protected void visitStringAttribute(RoleHandler roleHandler, CtElement element, String mapEntryKey, CtElement mapEntryValue) {
                if (mapEntryKey != null && mapEntryKey.contains(stringMarker)) {
                    PatternParameterConfigurator.this.patternBuilder.modifyNodeOfAttributeOfElement(element, roleHandler.getRole(), PatternParameterConfigurator.this.conflictResolutionMode, oldAttrNode -> {
                        List<RootNode> nodes = ((ListOfNodes)oldAttrNode).getNodes();
                        for (int i = 0; i < nodes.size(); ++i) {
                            RootNode node = nodes.get(i);
                            if (!(node instanceof MapEntryNode)) continue;
                            MapEntryNode mapEntryNode = (MapEntryNode)node;
                            nodes.set(i, new MapEntryNode(StringNode.setReplaceMarker(mapEntryNode.getKey(), stringMarker, pi), mapEntryNode.getValue()));
                        }
                        return oldAttrNode;
                    });
                }
            }
        }.scan(this.patternBuilder.getPatternModel());
        return this;
    }

    public PatternParameterConfigurator byNamedElement(String simpleName) {
        ParameterInfo pi = this.getCurrentParameter();
        this.queryModel().filterChildren(named -> simpleName.equals(named.getSimpleName())).forEach(named -> this.addSubstitutionRequest(pi, (CtElement)named));
        return this;
    }

    public PatternParameterConfigurator byReferenceName(String simpleName) {
        ParameterInfo pi = this.getCurrentParameter();
        this.queryModel().filterChildren(ref -> simpleName.equals(ref.getSimpleName())).forEach(ref -> this.addSubstitutionRequest(pi, (CtElement)ref));
        return this;
    }

    public PatternParameterConfigurator byFilter(Filter<?> filter) {
        ParameterInfo pi = this.getCurrentParameter();
        this.queryModel().filterChildren(filter).forEach(ele -> this.addSubstitutionRequest(pi, (CtElement)ele));
        return this;
    }

    public PatternParameterConfigurator byElement(CtElement ... elements) {
        ParameterInfo pi = this.getCurrentParameter();
        for (CtElement element : elements) {
            this.addSubstitutionRequest(pi, element);
        }
        return this;
    }

    public PatternParameterConfigurator byRole(CtRole role, Filter<?> filter) {
        ParameterInfo pi = this.getCurrentParameter();
        this.queryModel().filterChildren(filter).forEach(ele -> this.addSubstitutionRequest(pi, (CtElement)ele, role));
        return this;
    }

    public PatternParameterConfigurator byRole(CtRole role, CtElement ... elements) {
        ParameterInfo pi = this.getCurrentParameter();
        for (CtElement element : elements) {
            this.addSubstitutionRequest(pi, element, role);
        }
        return this;
    }

    public <T> PatternParameterConfigurator byCondition(Class<T> type, Predicate<T> matchCondition) {
        this.currentParameter.setMatchCondition(type, matchCondition);
        return this;
    }

    public PatternParameterConfigurator matchInlinedStatements() {
        InlinedStatementConfigurator sb = new InlinedStatementConfigurator(this.patternBuilder);
        for (CtElement ctElement : this.substitutedNodes) {
            sb.byElement(ctElement);
        }
        return this;
    }

    public boolean isSubstituted(String paramName) {
        if (this.patternBuilder.getParameterInfo(paramName) == null) {
            return false;
        }
        AbstractParameterInfo pi = this.getParameterInfo(paramName, false);
        if (pi == null) {
            return false;
        }
        class Result {
            boolean isUsed = false;

            Result() {
            }
        }
        Result result = new Result();
        this.patternBuilder.forEachNodeOfParameter(pi, parameterized -> {
            result.isUsed = true;
        });
        return result.isUsed;
    }

    void addSubstitutionRequest(ParameterInfo parameter, CtElement element) {
        RootNode node;
        this.substitutedNodes.add(element);
        ParameterElementPair pep = this.getSubstitutedNodeOfElement(parameter, element);
        this.patternBuilder.setNodeOfElement(pep.element, new ParameterNode(pep.parameter), this.conflictResolutionMode);
        if (this.patternBuilder.isAutoSimplifySubstitutions() && pep.element.isParentInitialized() && (node = this.patternBuilder.getOptionalPatternNode(pep.element.getParent(), new CtRole[0])) != null) {
            node.setSimplifyGenerated(true);
        }
    }

    void addSubstitutionRequest(ParameterInfo parameter, CtElement element, CtRole attributeRole) {
        this.patternBuilder.setNodeOfAttributeOfElement(element, attributeRole, new ParameterNode(parameter), this.conflictResolutionMode);
    }

    void addSubstitutionRequest(ParameterInfo parameter, CtElement element, CtRole attributeRole, String subStringMarker) {
        this.patternBuilder.modifyNodeOfAttributeOfElement(element, attributeRole, this.conflictResolutionMode, oldAttrNode -> StringNode.setReplaceMarker(oldAttrNode, subStringMarker, parameter));
    }

    private ParameterElementPair getSubstitutedNodeOfElement(ParameterInfo parameter, CtElement element) {
        ParameterElementPair parameterElementPair = new ParameterElementPair(parameter, element);
        parameterElementPair = this.transformVariableAccessToVariableReference(parameterElementPair);
        parameterElementPair = this.transformArrayAccess(parameterElementPair);
        parameterElementPair = this.transformTemplateParameterInvocationOfS(parameterElementPair);
        parameterElementPair = this.transformExecutableRefToInvocation(parameterElementPair);
        parameterElementPair = this.transformCtReturnIfNeeded(parameterElementPair);
        parameterElementPair = this.getLastImplicitParent(parameterElementPair);
        return parameterElementPair;
    }

    private ParameterElementPair transformArrayAccess(ParameterElementPair pep) {
        CtLiteral idxLiteral;
        Object idx;
        CtArrayAccess arrayAccess;
        CtExpression<Integer> expr;
        CtElement parent;
        CtElement element = pep.element;
        if (element.isParentInitialized() && (parent = element.getParent()) instanceof CtArrayAccess && (expr = (arrayAccess = (CtArrayAccess)parent).getIndexExpression()) instanceof CtLiteral && (idx = (idxLiteral = (CtLiteral)expr).getValue()) instanceof Number) {
            return new ParameterElementPair(new ListParameterInfo(((Number)idx).intValue(), pep.parameter), arrayAccess);
        }
        return pep;
    }

    private ParameterElementPair transformVariableAccessToVariableReference(ParameterElementPair pep) {
        if (pep.element instanceof CtVariableReference) {
            CtVariableReference varRef = (CtVariableReference)pep.element;
            return pep.copyAndSet(varRef.getParent());
        }
        return pep;
    }

    private ParameterElementPair transformTemplateParameterInvocationOfS(ParameterElementPair pep) {
        CtInvocation invocation;
        CtExecutableReference executableRef;
        CtElement parent;
        CtElement element = pep.element;
        if (element.isParentInitialized() && (parent = element.getParent()) instanceof CtInvocation && "S".equals((executableRef = (invocation = (CtInvocation)parent).getExecutable()).getSimpleName()) && TemplateParameter.class.getName().equals(executableRef.getDeclaringType().getQualifiedName())) {
            return pep.copyAndSet(invocation);
        }
        return pep;
    }

    private ParameterElementPair transformExecutableRefToInvocation(ParameterElementPair pep) {
        CtElement element = pep.element;
        if (element instanceof CtExecutableReference) {
            CtElement parent;
            CtExecutableReference execRef = (CtExecutableReference)element;
            if (element.isParentInitialized() && (parent = execRef.getParent()) instanceof CtInvocation) {
                return pep.copyAndSet(parent);
            }
        }
        return pep;
    }

    private ParameterElementPair transformCtReturnIfNeeded(ParameterElementPair pep) {
        Class<?> valueType;
        CtElement element = pep.element;
        if (element.isParentInitialized() && element.getParent() instanceof CtReturn && (valueType = pep.parameter.getParameterValueType()) != null && CtBlock.class.isAssignableFrom(valueType)) {
            return pep.copyAndSet(element.getParent());
        }
        return pep;
    }

    private ParameterElementPair getLastImplicitParent(ParameterElementPair pep) {
        CtElement parent;
        CtElement element = pep.element;
        while (element.isParentInitialized() && (parent = element.getParent()) instanceof CtBlock && parent.isImplicit()) {
            element = parent;
        }
        return pep.copyAndSet(element);
    }

    public static class ParameterElementPair {
        final ParameterInfo parameter;
        final CtElement element;

        public ParameterElementPair(ParameterInfo parameter, CtElement element) {
            this.parameter = parameter;
            this.element = element;
        }

        public ParameterElementPair copyAndSet(ParameterInfo param) {
            return new ParameterElementPair(param, this.element);
        }

        public ParameterElementPair copyAndSet(CtElement element) {
            return new ParameterElementPair(this.parameter, element);
        }
    }

    private static abstract class StringAttributeScanner
    extends CtScanner {
        private static List<RoleHandler> stringAttributeRoleHandlers = new ArrayList<RoleHandler>();

        private StringAttributeScanner() {
        }

        @Override
        public void scan(CtElement element) {
            this.visitStringAttribute(element);
            super.scan(element);
        }

        private void visitStringAttribute(CtElement element) {
            for (RoleHandler roleHandler : stringAttributeRoleHandlers) {
                if (!roleHandler.getTargetType().isInstance(element) || Metamodel.getInstance().getConcept(element.getClass()).getProperty(roleHandler.getRole()).isUnsettable()) continue;
                Object value = roleHandler.getValue(element);
                if (value instanceof String) {
                    this.visitStringAttribute(roleHandler, element, (String)value);
                    continue;
                }
                if (!(value instanceof Map)) continue;
                for (Map.Entry e : ((Map)value).entrySet()) {
                    this.visitStringAttribute(roleHandler, element, (String)e.getKey(), (CtElement)e.getValue());
                }
            }
        }

        protected abstract void visitStringAttribute(RoleHandler var1, CtElement var2, String var3);

        protected abstract void visitStringAttribute(RoleHandler var1, CtElement var2, String var3, CtElement var4);

        static {
            RoleHandlerHelper.forEachRoleHandler(rh -> {
                if (rh.getValueClass().isAssignableFrom(String.class)) {
                    stringAttributeRoleHandlers.add((RoleHandler)rh);
                }
                if (rh.getContainerKind() == ContainerKind.MAP) {
                    stringAttributeRoleHandlers.add((RoleHandler)rh);
                }
            });
        }
    }
}

