/*
 * Decompiled with CFR 0.152.
 */
package spoon.pattern;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import spoon.SpoonException;
import spoon.pattern.Generator;
import spoon.pattern.Match;
import spoon.pattern.internal.DefaultGenerator;
import spoon.pattern.internal.PatternPrinter;
import spoon.pattern.internal.matcher.MatchingScanner;
import spoon.pattern.internal.node.ListOfNodes;
import spoon.pattern.internal.parameter.ParameterInfo;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.factory.Factory;
import spoon.reflect.path.CtRole;
import spoon.reflect.visitor.chain.CtConsumer;
import spoon.support.Experimental;

@Experimental
public class Pattern {
    private ListOfNodes modelValueResolver;
    private boolean addGeneratedBy = false;
    private final Factory factory;

    Pattern(Factory factory, ListOfNodes modelValueResolver) {
        this.modelValueResolver = modelValueResolver;
        this.factory = factory;
    }

    public Map<String, ParameterInfo> getParameterInfos() {
        HashMap parameters = new HashMap();
        this.modelValueResolver.forEachParameterInfo((parameter, valueResolver) -> {
            ParameterInfo existingParameter = (ParameterInfo)parameters.get(parameter.getName());
            if (existingParameter != null) {
                if (existingParameter == parameter) {
                    return;
                }
                throw new SpoonException("There is already a parameter: " + parameter.getName());
            }
            parameters.put(parameter.getName(), parameter);
        });
        return Collections.unmodifiableMap(parameters);
    }

    public Generator generator() {
        return new DefaultGenerator(this.factory, this.modelValueResolver).setAddGeneratedBy(this.addGeneratedBy);
    }

    public void forEachMatch(Object input, CtConsumer<Match> consumer) {
        if (input == null) {
            return;
        }
        if (input.getClass().isArray()) {
            input = Arrays.asList((Object[])input);
        }
        MatchingScanner scanner = new MatchingScanner(this.modelValueResolver, consumer);
        if (input instanceof Collection) {
            scanner.scan(null, (Collection<? extends CtElement>)input);
        } else if (input instanceof Map) {
            scanner.scan((CtRole)null, input);
        } else {
            scanner.scan(null, (CtElement)((Object)input));
        }
    }

    public List<Match> getMatches(CtElement root) {
        ArrayList<Match> matches = new ArrayList<Match>();
        this.forEachMatch(root, matches::add);
        return matches;
    }

    public String print(boolean addParameterComments) {
        return new PatternPrinter().setPrintParametersAsComments(addParameterComments).printNode(this.modelValueResolver);
    }

    public String toString() {
        return this.modelValueResolver.toString();
    }

    boolean isAddGeneratedBy() {
        return this.addGeneratedBy;
    }

    Pattern setAddGeneratedBy(boolean addGeneratedBy) {
        this.addGeneratedBy = addGeneratedBy;
        return this;
    }
}

