/*
 * Decompiled with CFR 0.152.
 */
package spoon.pattern;

import java.util.List;
import java.util.Map;
import spoon.SpoonException;
import spoon.reflect.declaration.CtElement;
import spoon.support.util.ImmutableMap;

public class Match {
    private final List<?> matchingElements;
    private final ImmutableMap parameters;

    public Match(List<?> matches, ImmutableMap parameters) {
        this.parameters = parameters;
        this.matchingElements = matches;
    }

    public List<CtElement> getMatchingElements() {
        return this.getMatchingElements(CtElement.class);
    }

    public <T> List<T> getMatchingElements(Class<T> clazz) {
        for (Object object : this.matchingElements) {
            if (object == null || clazz.isInstance(object)) continue;
            throw new SpoonException("Match contains a " + object.getClass() + " which cannot be cast to " + clazz);
        }
        return this.matchingElements;
    }

    public CtElement getMatchingElement() {
        return this.getMatchingElement(CtElement.class, true);
    }

    public <T> T getMatchingElement(Class<T> clazz) {
        return this.getMatchingElement(clazz, true);
    }

    private <T> T getMatchingElement(Class<T> clazz, boolean failIfMany) {
        if (this.matchingElements.isEmpty()) {
            return null;
        }
        if (failIfMany && this.matchingElements.size() != 1) {
            throw new SpoonException("There is more then one match");
        }
        Object object = this.matchingElements.get(0);
        if (object != null && !clazz.isInstance(object)) {
            throw new SpoonException("Match contains a " + object.getClass() + " which cannot be cast to " + clazz);
        }
        return clazz.cast(object);
    }

    public ImmutableMap getParameters() {
        return this.parameters;
    }

    public Map<String, Object> getParametersMap() {
        return this.parameters.asMap();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        sb.append(this.parameters.toString());
        sb.append("\n}\n----------");
        for (int i = 0; i < this.matchingElements.size(); ++i) {
            sb.append("\n").append(i + 1).append(") ").append(this.matchingElements.get(i));
        }
        return sb.toString();
    }
}

