/*
 * Decompiled with CFR 0.152.
 */
package spoon.metamodel;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import spoon.SpoonException;
import spoon.metamodel.ConceptKind;
import spoon.metamodel.MMMethod;
import spoon.metamodel.MMMethodKind;
import spoon.metamodel.Metamodel;
import spoon.metamodel.MetamodelConcept;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.factory.Factory;
import spoon.reflect.meta.ContainerKind;
import spoon.reflect.meta.RoleHandler;
import spoon.reflect.meta.impl.RoleHandlerHelper;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.support.DerivedProperty;
import spoon.support.UnsettableProperty;
import spoon.support.util.RtHelper;

public class MetamodelProperty {
    private final String name;
    private final CtRole role;
    private final MetamodelConcept ownerConcept;
    private ContainerKind valueContainerType;
    private CtTypeReference<?> valueType;
    private CtTypeReference<?> itemValueType;
    private RoleHandler roleHandler;
    private Boolean derived;
    private Boolean unsettable;
    private Map<MMMethodKind, List<MMMethod>> methodsByKind = new EnumMap<MMMethodKind, List<MMMethod>>(MMMethodKind.class);
    private Map<String, MMMethod> methodsBySignature;
    private final List<MMMethod> roleMethods = new ArrayList<MMMethod>();
    private final Map<String, MMMethod> roleMethodsBySignature = new HashMap<String, MMMethod>();
    private final List<MetamodelProperty> superProperties = new ArrayList<MetamodelProperty>();
    static boolean useRuntimeMethodInvocation = false;

    MetamodelProperty(String name, CtRole role, MetamodelConcept ownerConcept) {
        this.name = name;
        this.role = role;
        this.ownerConcept = ownerConcept;
    }

    void addMethod(CtMethod<?> method) {
        this.addMethod(method, true);
    }

    MMMethod addMethod(CtMethod<?> method, boolean createIfNotExist) {
        for (MMMethod mmMethod : this.roleMethods) {
            if (!mmMethod.overrides(method)) continue;
            mmMethod.addRelatedMethod(method);
            return mmMethod;
        }
        if (createIfNotExist) {
            MMMethod mmMethod = new MMMethod(this, method);
            this.roleMethods.add(mmMethod);
            this.methodsByKind.computeIfAbsent(mmMethod.getKind(), k -> new ArrayList()).add(mmMethod);
            MMMethod conflict = this.roleMethodsBySignature.put(mmMethod.getSignature(), mmMethod);
            if (conflict != null) {
                throw new SpoonException("Conflict on " + this.getOwner().getName() + "." + this.name + " method signature: " + mmMethod.getSignature());
            }
            return mmMethod;
        }
        return null;
    }

    void addSuperField(MetamodelProperty superMMField) {
        if (Metamodel.addUniqueObject(this.superProperties, superMMField)) {
            for (MMMethod superMethod : superMMField.getRoleMethods()) {
                CtMethod<?> method = superMethod.getCompatibleMethod(this.getOwner());
                this.addMethod(method, true);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public CtRole getRole() {
        return this.role;
    }

    public MetamodelConcept getOwner() {
        return this.ownerConcept;
    }

    public ContainerKind getContainerKind() {
        return this.valueContainerType;
    }

    CtTypeReference<?> detectValueType() {
        CtTypeReference<?> setterValueType;
        MMMethod mmGetMethod = this.getMethod(MMMethodKind.GET);
        if (mmGetMethod == null) {
            throw new SpoonException("No getter exists for " + this.getOwner().getName() + "." + this.getName());
        }
        MMMethod mmSetMethod = this.getMethod(MMMethodKind.SET);
        if (mmSetMethod == null) {
            return mmGetMethod.getReturnType();
        }
        CtTypeReference<?> getterValueType = mmGetMethod.getReturnType();
        if (getterValueType.equals(setterValueType = mmSetMethod.getValueType())) {
            return mmGetMethod.getReturnType();
        }
        if (MetamodelProperty.containerKindOf(getterValueType.getActualClass()) != ContainerKind.SINGLE) {
            getterValueType = MetamodelProperty.getTypeofItems(getterValueType);
            setterValueType = MetamodelProperty.getTypeofItems(setterValueType);
        }
        if (getterValueType.equals(setterValueType)) {
            return mmGetMethod.getReturnType();
        }
        if (getterValueType.isSubtypeOf(setterValueType)) {
            return mmSetMethod.getValueType();
        }
        throw new SpoonException("Incompatible getter and setter for " + this.getOwner().getName() + "." + this.getName());
    }

    void setValueType(CtTypeReference<?> valueType) {
        Factory f = valueType.getFactory();
        if (valueType instanceof CtTypeParameterReference && (valueType = ((CtTypeParameterReference)valueType).getBoundingType()) == null) {
            valueType = f.Type().objectType();
        }
        if (valueType.isImplicit()) {
            valueType = valueType.clone();
            valueType.setImplicit(false);
        }
        valueType.setAnnotations(List.of());
        this.valueType = valueType;
        this.valueContainerType = MetamodelProperty.containerKindOf(valueType.getActualClass());
        this.itemValueType = this.valueContainerType != ContainerKind.SINGLE ? MetamodelProperty.getTypeofItems(valueType) : valueType;
    }

    public CtTypeReference<?> getTypeOfField() {
        if (this.valueType == null) {
            throw new SpoonException("Model is not initialized yet");
        }
        return this.valueType;
    }

    public CtTypeReference<?> getTypeofItems() {
        if (this.itemValueType == null) {
            this.getTypeOfField();
        }
        return this.itemValueType;
    }

    public MMMethod getMethod(MMMethodKind kind) {
        List<MMMethod> ms = this.getMethods(kind);
        return !ms.isEmpty() ? ms.get(0) : null;
    }

    public MMMethod getMethodBySignature(String signature) {
        if (this.methodsBySignature == null) {
            this.methodsBySignature = new HashMap<String, MMMethod>();
            for (List<MMMethod> mmMethods : this.methodsByKind.values()) {
                for (MMMethod mmMethod : mmMethods) {
                    String sigature = mmMethod.getSignature();
                    this.methodsBySignature.put(sigature, mmMethod);
                }
            }
        }
        return this.methodsBySignature.get(signature);
    }

    public List<MMMethod> getMethods(MMMethodKind kind) {
        List<MMMethod> ms = this.methodsByKind.get((Object)kind);
        return ms == null ? Collections.emptyList() : Collections.unmodifiableList(ms);
    }

    public Set<MMMethod> getMethods() {
        HashSet<MMMethod> res = new HashSet<MMMethod>();
        for (List<MMMethod> methods : this.methodsByKind.values()) {
            res.addAll(methods);
        }
        return Collections.unmodifiableSet(res);
    }

    void sortByBestMatch() {
        for (MMMethodKind mk : MMMethodKind.values()) {
            this.sortByBestMatch(mk);
        }
    }

    void sortByBestMatch(MMMethodKind key) {
        int idx;
        List<MMMethod> methods = this.methodsByKind.get((Object)key);
        if (methods != null && methods.size() > 1 && (idx = this.getIdxOfBestMatch(methods, key)) > 0) {
            methods.add(0, methods.remove(idx));
        }
    }

    private int getIdxOfBestMatch(List<MMMethod> methods, MMMethodKind key) {
        MMMethod mmMethod = methods.get(0);
        if (mmMethod.getActualCtMethod().getParameters().isEmpty()) {
            return this.getIdxOfBestMatchByReturnType(methods, key);
        }
        MMMethod mmGetMethod = this.getMethod(MMMethodKind.GET);
        if (mmGetMethod == null) {
            return -1;
        }
        return this.getIdxOfBestMatchByInputParameter(methods, key, mmGetMethod.getReturnType());
    }

    private int getIdxOfBestMatchByReturnType(List<MMMethod> methods, MMMethodKind key) {
        boolean is2Iterable;
        if (methods.size() > 2) {
            throw new SpoonException("Resolving of more then 2 conflicting getters is not supported. There are: " + methods);
        }
        CtTypeReference returnType1 = methods.get(0).getActualCtMethod().getType();
        CtTypeReference returnType2 = methods.get(1).getActualCtMethod().getType();
        Factory f = returnType1.getFactory();
        CtTypeReference<Iterable> iterableRef = f.Type().createReference(Iterable.class);
        boolean is1Iterable = returnType1.isSubtypeOf(iterableRef);
        if (is1Iterable != (is2Iterable = returnType2.isSubtypeOf(iterableRef))) {
            if (is1Iterable) {
                if (this.isIterableOf(returnType1, returnType2)) {
                    return 0;
                }
            } else if (this.isIterableOf(returnType2, returnType1)) {
                return 1;
            }
        }
        return -1;
    }

    private boolean isIterableOf(CtTypeReference<?> iterableType, CtTypeReference<?> itemType) {
        CtTypeReference<?> iterableItemType = MetamodelProperty.getTypeofItems(iterableType);
        if (iterableItemType != null) {
            return itemType.isSubtypeOf(iterableItemType);
        }
        return false;
    }

    private int getIdxOfBestMatchByInputParameter(List<MMMethod> methods, MMMethodKind key, CtTypeReference<?> expectedValueType) {
        int idx = -1;
        Enum maxMatchLevel = null;
        if (key.isMulti()) {
            expectedValueType = MetamodelProperty.getTypeofItems(expectedValueType);
        }
        for (int i = 0; i < methods.size(); ++i) {
            MMMethod mMethod = methods.get(i);
            MatchLevel matchLevel = this.getMatchLevel(expectedValueType, mMethod.getValueType());
            if (matchLevel == null) continue;
            if (idx == -1) {
                idx = i;
                maxMatchLevel = matchLevel;
                continue;
            }
            if (maxMatchLevel.ordinal() < matchLevel.ordinal()) {
                idx = i;
                maxMatchLevel = matchLevel;
                continue;
            }
            if (maxMatchLevel != matchLevel) continue;
            return -1;
        }
        return idx;
    }

    private static CtTypeReference<?> getTypeofItems(CtTypeReference<?> valueType) {
        CtTypeReference<Object> itemValueType;
        ContainerKind valueContainerType = MetamodelProperty.containerKindOf(valueType.getActualClass());
        if (valueContainerType == ContainerKind.SINGLE) {
            return null;
        }
        if (valueContainerType == ContainerKind.MAP) {
            if (!String.class.getName().equals(valueType.getActualTypeArguments().get(0).getQualifiedName())) {
                throw new SpoonException("Unexpected container of type: " + valueType.toString());
            }
            itemValueType = valueType.getActualTypeArguments().get(1);
        } else {
            itemValueType = valueType.getActualTypeArguments().get(0);
        }
        if (itemValueType instanceof CtTypeParameterReference && (itemValueType = ((CtTypeParameterReference)itemValueType).getBoundingType()) == null) {
            itemValueType = valueType.getFactory().Type().objectType();
        }
        return itemValueType;
    }

    private @Nullable MatchLevel getMatchLevel(CtTypeReference<?> expectedType, CtTypeReference<?> realType) {
        if (expectedType.equals(realType)) {
            return MatchLevel.EQUALS;
        }
        if (expectedType.getTypeErasure().equals(realType.getTypeErasure())) {
            return MatchLevel.ERASED_EQUALS;
        }
        if (expectedType.isSubtypeOf(realType)) {
            return MatchLevel.SUBTYPE;
        }
        return null;
    }

    public boolean isDerived() {
        if (this.derived == null) {
            if (this.getOwner().getKind() == ConceptKind.LEAF && this.isUnsettable()) {
                this.derived = Boolean.TRUE;
                return this.derived;
            }
            this.derived = Boolean.FALSE;
            MMMethod getter = this.getMethod(MMMethodKind.GET);
            if (getter == null) {
                throw new SpoonException("No getter defined for " + this);
            }
            CtTypeReference derivedProperty = getter.getActualCtMethod().getFactory().createCtTypeReference(DerivedProperty.class);
            for (CtMethod<?> ctMethod : getter.getDeclaredMethods()) {
                if (ctMethod.getAnnotation(derivedProperty) == null) continue;
                this.derived = Boolean.TRUE;
                return this.derived;
            }
            for (MetamodelProperty superField : this.superProperties) {
                if (!superField.isDerived()) continue;
                this.derived = Boolean.TRUE;
                return this.derived;
            }
        }
        return this.derived;
    }

    public boolean isUnsettable() {
        if (this.unsettable == null) {
            this.unsettable = Boolean.FALSE;
            MMMethod setter = this.getMethod(MMMethodKind.SET);
            if (setter == null) {
                this.unsettable = Boolean.TRUE;
                return this.unsettable;
            }
            CtTypeReference unsettableProperty = setter.getActualCtMethod().getFactory().createCtTypeReference(UnsettableProperty.class);
            for (CtMethod<?> ctMethod : setter.getDeclaredMethods()) {
                if (ctMethod.getAnnotation(unsettableProperty) == null) continue;
                this.unsettable = Boolean.TRUE;
                return this.unsettable;
            }
        }
        return this.unsettable;
    }

    private List<MMMethod> getRoleMethods() {
        return Collections.unmodifiableList(this.roleMethods);
    }

    public String toString() {
        return this.ownerConcept.getName() + "#" + this.getName() + "<" + this.valueType + ">";
    }

    public MetamodelProperty getSuperProperty() {
        ArrayList<MetamodelProperty> potentialRootSuperFields = new ArrayList<MetamodelProperty>();
        if (!this.roleMethods.isEmpty()) {
            potentialRootSuperFields.add(this);
        }
        this.superProperties.forEach(superField -> Metamodel.addUniqueObject(potentialRootSuperFields, superField.getSuperProperty()));
        int idx = 0;
        if (potentialRootSuperFields.size() > 1) {
            MetamodelProperty superField2;
            boolean needsSetter = this.getMethod(MMMethodKind.SET) != null;
            CtTypeReference<?> expectedValueType = this.getTypeOfField().getTypeErasure();
            int i = 1;
            while (i < potentialRootSuperFields.size() && (superField2 = (MetamodelProperty)potentialRootSuperFields.get(i)).getTypeOfField().getTypeErasure().equals(expectedValueType) && (!needsSetter || superField2.getMethod(MMMethodKind.SET) != null)) {
                idx = i++;
            }
        }
        return (MetamodelProperty)potentialRootSuperFields.get(idx);
    }

    private static ContainerKind containerKindOf(Class<?> valueClass) {
        if (List.class.isAssignableFrom(valueClass)) {
            return ContainerKind.LIST;
        }
        if (Map.class.isAssignableFrom(valueClass)) {
            return ContainerKind.MAP;
        }
        if (Collection.class.isAssignableFrom(valueClass)) {
            return ContainerKind.SET;
        }
        return ContainerKind.SINGLE;
    }

    public RoleHandler getRoleHandler() {
        if (this.roleHandler == null) {
            this.roleHandler = RoleHandlerHelper.getRoleHandler(this.ownerConcept.getMetamodelInterface().getActualClass(), this.role);
        }
        return this.roleHandler;
    }

    public <T, U> U getValue(T element) {
        MMMethod method;
        if (useRuntimeMethodInvocation && (method = this.getMethod(MMMethodKind.GET)) != null) {
            Method rtMethod = RtHelper.getMethod(this.getOwner().getImplementationClass().getActualClass(), method.getName(), 0);
            if (rtMethod != null) {
                try {
                    return (U)rtMethod.invoke(element, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new SpoonException("Invocation of getter on " + this.toString() + " failed", e);
                }
            }
            throw new SpoonException("Cannot invoke getter on " + this.toString());
        }
        return this.getRoleHandler().getValue(element);
    }

    public <T, U> void setValue(T element, U value) {
        MMMethod method;
        if (useRuntimeMethodInvocation && (method = this.getMethod(MMMethodKind.SET)) != null) {
            Method rtMethod = RtHelper.getMethod(this.getOwner().getImplementationClass().getActualClass(), method.getName(), 1);
            if (rtMethod != null) {
                try {
                    rtMethod.invoke(element, value);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new SpoonException("Invocation of setter on " + this.toString() + " failed", e);
                }
                return;
            }
            throw new SpoonException("Cannot invoke setter on " + this.toString());
        }
        this.getRoleHandler().setValue(element, value);
    }

    private static enum MatchLevel {
        SUBTYPE,
        ERASED_EQUALS,
        EQUALS;

    }
}

