/*
 * Decompiled with CFR 0.152.
 */
package spoon.metamodel;

import java.util.function.Predicate;
import spoon.SpoonException;
import spoon.reflect.declaration.CtMethod;

public enum MMMethodKind {
    GET(false, 1, m -> m.getParameters().isEmpty() && (m.getSimpleName().startsWith("get") || m.getSimpleName().startsWith("is"))),
    SET(false, 1, m -> m.getParameters().size() == 1 && m.getSimpleName().startsWith("set")),
    ADD_FIRST(true, 10, m -> {
        if (m.getParameters().size() == 1 && (m.getSimpleName().startsWith("add") || m.getSimpleName().startsWith("insert"))) {
            return m.getSimpleName().endsWith("AtTop") || m.getSimpleName().endsWith("Begin");
        }
        return false;
    }),
    ADD_LAST(true, 1, m -> {
        if (m.getParameters().size() == 1) {
            return m.getSimpleName().startsWith("add") || m.getSimpleName().startsWith("insert");
        }
        return false;
    }),
    ADD_ON(true, 1, m -> {
        if (m.getParameters().size() == 2 && "int".equals(m.getParameters().get(0).getType().getSimpleName())) {
            return m.getSimpleName().startsWith("add") || m.getSimpleName().startsWith("insert");
        }
        return false;
    }),
    REMOVE(true, 1, m -> m.getParameters().size() == 1 && m.getSimpleName().startsWith("remove")),
    GET_BY(true, 1, m -> m.getSimpleName().startsWith("get") && m.getParameters().size() == 1 && m.getParameters().get(0).getType().getQualifiedName().equals(String.class.getName())),
    OTHER(false, 0, m -> true);

    private final Predicate<CtMethod<?>> detector;
    private final int level;
    private final boolean multi;

    private MMMethodKind(boolean multi, int level, Predicate<CtMethod<?>> detector) {
        this.multi = multi;
        this.level = level;
        this.detector = detector;
    }

    public boolean isMulti() {
        return this.multi;
    }

    public static MMMethodKind kindOf(CtMethod<?> method) {
        MMMethodKind result = OTHER;
        for (MMMethodKind k : MMMethodKind.values()) {
            if (!k.detector.test(method) || result.level > k.level) continue;
            if (result.level == k.level && k != OTHER) {
                throw new SpoonException("Ambiguous method kinds " + result.name() + " X " + k.name() + " for method " + method.getSignature());
            }
            result = k;
        }
        return result;
    }
}

