/*
 * Decompiled with CFR 0.152.
 */
package spoon.javadoc.internal;

import java.io.Serializable;
import spoon.javadoc.internal.JavadocDescriptionElement;

@Deprecated(forRemoval=true, since="11.0.0")
public class JavadocInlineTag
implements JavadocDescriptionElement,
Serializable {
    private static final long serialVersionUID = 1L;
    private String tagName;
    private Type type;
    private String content;

    public static String nextWord(String string) {
        int index;
        for (index = 0; index < string.length() && !Character.isWhitespace(string.charAt(index)); ++index) {
        }
        return string.substring(0, index);
    }

    public static JavadocDescriptionElement fromText(String text) {
        if (!text.startsWith("{@")) {
            throw new IllegalArgumentException(String.format("Expected to start with '{@'. Text '%s'", text));
        }
        if (!text.endsWith("}")) {
            throw new IllegalArgumentException(String.format("Expected to end with '}'. Text '%s'", text));
        }
        text = text.substring(2, text.length() - 1);
        String tagName = JavadocInlineTag.nextWord(text);
        Type type = Type.fromName(tagName);
        String content = text.substring(tagName.length()).trim();
        return new JavadocInlineTag(tagName, type, content);
    }

    public void setContent(String content) {
        this.content = content;
    }

    public JavadocInlineTag(String tagName, Type type, String content) {
        this.tagName = tagName;
        this.type = type;
        this.content = content;
    }

    public Type getType() {
        return this.type;
    }

    public String getContent() {
        return this.content;
    }

    public String getName() {
        return this.tagName;
    }

    @Override
    public String toText() {
        return "{@" + this.tagName + " " + this.content + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavadocInlineTag that = (JavadocInlineTag)o;
        if (this.tagName != null ? !this.tagName.equals(that.tagName) : that.tagName != null) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return this.content != null ? this.content.equals(that.content) : that.content == null;
    }

    public int hashCode() {
        int result = this.tagName != null ? this.tagName.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.content != null ? this.content.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "JavadocInlineTag{tagName='" + this.tagName + "', type=" + this.type + ", content='" + this.content + "'}";
    }

    public static enum Type {
        CODE("code"),
        DOC_ROOT("docRoot"),
        INHERIT_DOC("inheritDoc"),
        LINK("link"),
        LINKPLAIN("linkplain"),
        LITERAL("literal"),
        VALUE("value"),
        UNKNOWN("unknown");

        private final String keyword;

        private Type(String keyword) {
            this.keyword = keyword;
        }

        static Type fromName(String tagName) {
            for (Type type : Type.values()) {
                if (!type.keyword.equalsIgnoreCase(tagName)) continue;
                return type;
            }
            return UNKNOWN;
        }
    }
}

