/*
 * Decompiled with CFR 0.152.
 */
package spoon.compiler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import spoon.SpoonException;
import spoon.compiler.Environment;
import spoon.compiler.SpoonResource;

public interface SpoonFile
extends SpoonResource {
    public InputStream getContent();

    public boolean isJava();

    public boolean isActualFile();

    default public char[] getContentChars(Environment env) {
        byte[] bytes;
        try (InputStream contentStream = this.getContent();){
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            contentStream.transferTo(outputStream);
            bytes = outputStream.toByteArray();
        }
        catch (IOException e) {
            throw new SpoonException(e);
        }
        if (env.getEncodingProvider() == null) {
            return new String(bytes, env.getEncoding()).toCharArray();
        }
        Charset encoding = env.getEncodingProvider().detectEncoding(this, bytes);
        return new String(bytes, encoding).toCharArray();
    }
}

