/*
 * Decompiled with CFR 0.152.
 */
package spoon;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spoon.Launcher;
import spoon.SpoonException;
import spoon.support.compiler.SpoonPom;

public class MavenLauncher
extends Launcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String mvnHome;
    private SOURCE_TYPE sourceType;
    private SpoonPom model;
    private boolean forceRefresh = false;
    private final SpoonPom.MavenOptions mavenOptions = SpoonPom.MavenOptions.empty();

    public SpoonPom getPomFile() {
        return this.model;
    }

    public MavenLauncher(String mavenProject, SOURCE_TYPE sourceType) {
        this(mavenProject, sourceType, System.getenv().get("M2_HOME"), false);
    }

    public MavenLauncher(String mavenProject, SOURCE_TYPE sourceType, Pattern profileFilter) {
        this(mavenProject, sourceType, System.getenv().get("M2_HOME"), false, profileFilter);
    }

    public MavenLauncher(String mavenProject, SOURCE_TYPE sourceType, boolean forceRefresh) {
        this(mavenProject, sourceType, System.getenv().get("M2_HOME"), forceRefresh);
    }

    public MavenLauncher(String mavenProject, SOURCE_TYPE sourceType, boolean forceRefresh, Pattern profileFilter) {
        this(mavenProject, sourceType, System.getenv().get("M2_HOME"), forceRefresh, profileFilter);
    }

    public MavenLauncher(String mavenProject, SOURCE_TYPE sourceType, String mvnHome) {
        this(mavenProject, sourceType, mvnHome, false);
    }

    public MavenLauncher(String mavenProject, SOURCE_TYPE sourceType, String mvnHome, Pattern profileFilter) {
        this(mavenProject, sourceType, mvnHome, false, profileFilter);
    }

    public MavenLauncher(String mavenProject, SOURCE_TYPE sourceType, String mvnHome, boolean forceRefresh) {
        this.sourceType = sourceType;
        this.mvnHome = mvnHome;
        this.forceRefresh = forceRefresh;
        this.init(mavenProject, null, Pattern.compile("^$"));
    }

    public MavenLauncher(String mavenProject, SOURCE_TYPE sourceType, String mvnHome, boolean forceRefresh, Pattern profileFilter) {
        this.sourceType = sourceType;
        this.mvnHome = mvnHome;
        this.forceRefresh = forceRefresh;
        this.init(mavenProject, null, profileFilter);
    }

    public MavenLauncher(String mavenProject, SOURCE_TYPE sourceType, String[] classpath) {
        this.sourceType = sourceType;
        this.init(mavenProject, classpath, Pattern.compile("^$"));
    }

    public MavenLauncher(String mavenProject, SOURCE_TYPE sourceType, String[] classpath, Pattern profileFilter) {
        this.sourceType = sourceType;
        this.init(mavenProject, classpath, profileFilter);
    }

    public void setEnvironmentVariable(String key, String value) {
        this.mavenOptions.setEnvironmentVariable(key, value);
    }

    private void init(String mavenProject, String[] classpath, Pattern profileFilter) {
        File mavenProjectFile = new File(mavenProject);
        if (!mavenProjectFile.exists()) {
            throw new SpoonException(mavenProject + " does not exist.");
        }
        try {
            this.model = new SpoonPom(mavenProject, this.sourceType, this.getEnvironment(), profileFilter);
        }
        catch (Exception e) {
            throw new SpoonException("Unable to read the pom", e);
        }
        if (SOURCE_TYPE.APP_SOURCE == this.sourceType || SOURCE_TYPE.ALL_SOURCE == this.sourceType) {
            List<File> sourceDirectories = this.model.getSourceDirectories();
            for (File sourceDirectory : sourceDirectories) {
                this.addInputResource(sourceDirectory.getAbsolutePath());
            }
        }
        if (SOURCE_TYPE.TEST_SOURCE == this.sourceType || SOURCE_TYPE.ALL_SOURCE == this.sourceType) {
            List<File> testSourceDirectories = this.model.getTestDirectories();
            for (File sourceDirectory : testSourceDirectories) {
                this.addInputResource(sourceDirectory.getAbsolutePath());
            }
        }
        if (classpath == null) {
            classpath = this.model.buildClassPath(this.mvnHome, this.sourceType, LOGGER, this.forceRefresh, this.mavenOptions);
            LOGGER.info("Running in FULLCLASSPATH mode. Source folders and dependencies are inferred from the pom.xml file (doc: http://spoon.gforge.inria.fr/launcher.html).");
        } else {
            LOGGER.info("Running in FULLCLASSPATH mode. Classpath is manually set (doc: http://spoon.gforge.inria.fr/launcher.html).");
        }
        this.factory.getEnvironment().setNoClasspath(false);
        this.getModelBuilder().setSourceClasspath(classpath);
        this.getEnvironment().setComplianceLevel(this.model.getSourceVersion());
    }

    @Override
    protected void reportClassPathMode() {
    }

    public void rebuildClasspath() {
        String[] classpath = this.model.buildClassPath(this.mvnHome, this.sourceType, LOGGER, true, this.mavenOptions);
        this.getModelBuilder().setSourceClasspath(classpath);
    }

    public static enum SOURCE_TYPE {
        APP_SOURCE,
        TEST_SOURCE,
        ALL_SOURCE;

    }
}

