/*
 * Decompiled with CFR 0.152.
 */
package spoon;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.stringparsers.EnumeratedStringParser;
import com.martiansoftware.jsap.stringparsers.FileStringParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spoon.OutputType;
import spoon.SpoonAPI;
import spoon.SpoonException;
import spoon.SpoonModelBuilder;
import spoon.compiler.Environment;
import spoon.compiler.SpoonResource;
import spoon.compiler.SpoonResourceHelper;
import spoon.processing.Processor;
import spoon.reflect.CtModel;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.factory.Factory;
import spoon.reflect.factory.FactoryImpl;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.PrettyPrinter;
import spoon.reflect.visitor.filter.AbstractFilter;
import spoon.support.DefaultCoreFactory;
import spoon.support.JavaOutputProcessor;
import spoon.support.Level;
import spoon.support.StandardEnvironment;
import spoon.support.compiler.FileSystemFile;
import spoon.support.compiler.FileSystemFolder;
import spoon.support.compiler.VirtualFile;
import spoon.support.compiler.jdt.JDTBasedSpoonCompiler;
import spoon.support.gui.SpoonModelTree;

public class Launcher
implements SpoonAPI {
    public static final String SPOONED_CLASSES = "spooned-classes";
    public static final String OUTPUTDIR = "spooned";
    protected Factory factory;
    private SpoonModelBuilder modelBuilder;
    private String[] commandLineArgs = new String[0];
    private Filter<CtType<?>> typeFilter;
    private static JSAP jsapSpec;
    protected JSAPResult jsapActualArgs;
    private List<String> processorTypes = new ArrayList<String>();
    private List<Processor<? extends CtElement>> processors = new ArrayList<Processor<? extends CtElement>>();
    private boolean processed = false;
    public static final Logger LOGGER;
    public static final IOFileFilter RESOURCES_FILE_FILTER;
    public static final IOFileFilter ALL_DIR_FILTER;

    public static void main(String[] args) {
        new Launcher().run(args);
    }

    @Override
    public void run(String[] args) {
        this.setArgs(args);
        if (args.length != 0) {
            this.run();
            if (this.jsapActualArgs.getBoolean("gui")) {
                new SpoonModelTree(this.getFactory());
            }
        } else {
            this.printUsage();
        }
    }

    public void setArgs(String[] args2) {
        this.commandLineArgs = args2;
        if (this.processed) {
            throw new SpoonException("You cannot process twice the same launcher instance.");
        }
        this.processed = true;
        this.processArguments();
    }

    public void printUsage() {
        this.commandLineArgs = new String[]{"--help"};
        this.processArguments();
    }

    public Launcher() {
        this.factory = this.createFactory();
        this.processArguments();
    }

    public Launcher(Factory pFactory) {
        if (pFactory == null) {
            throw new IllegalArgumentException("unable to create launcher with null factory");
        }
        this.factory = pFactory;
        this.processArguments();
    }

    @Override
    public void addInputResource(String path) {
        File file = new File(path);
        if (file.isDirectory()) {
            this.addInputResource(new FileSystemFolder(file));
        } else {
            this.addInputResource(new FileSystemFile(file));
        }
    }

    public void addInputResource(SpoonResource resource) {
        this.modelBuilder.addInputSource(resource);
    }

    @Override
    public void addProcessor(String name) {
        this.processorTypes.add(name);
    }

    @Override
    public <T extends CtElement> void addProcessor(Processor<T> processor) {
        this.processors.add(processor);
    }

    public void addTemplateResource(SpoonResource resource) {
        this.modelBuilder.addTemplateSource(resource);
    }

    @Override
    public Environment getEnvironment() {
        return this.factory.getEnvironment();
    }

    protected static JSAP defineArgs() {
        try {
            JSAP jsap = new JSAP();
            Switch sw1 = new Switch("help");
            sw1.setShortFlag('h');
            sw1.setLongFlag("help");
            sw1.setDefault("false");
            jsap.registerParameter((Parameter)sw1);
            sw1 = new Switch("tabs");
            sw1.setLongFlag("tabs");
            sw1.setDefault("false");
            sw1.setHelp("Use tabulations instead of spaces in the generated code (use spaces by default).");
            jsap.registerParameter((Parameter)sw1);
            FlaggedOption opt2 = new FlaggedOption("tabsize");
            opt2.setLongFlag("tabsize");
            opt2.setStringParser((StringParser)JSAP.INTEGER_PARSER);
            opt2.setDefault("4");
            opt2.setHelp("Define tabulation size.");
            jsap.registerParameter((Parameter)opt2);
            opt2 = new FlaggedOption("level");
            opt2.setLongFlag("level");
            opt2.setHelp("Level of the output messages about what spoon is doing.");
            opt2.setStringParser((StringParser)JSAP.STRING_PARSER);
            opt2.setDefault(Level.ERROR.toString());
            jsap.registerParameter((Parameter)opt2);
            sw1 = new Switch("imports");
            sw1.setLongFlag("with-imports");
            sw1.setDefault("false");
            sw1.setHelp("Enable imports in generated files.");
            jsap.registerParameter((Parameter)sw1);
            opt2 = new FlaggedOption("compliance");
            opt2.setLongFlag("compliance");
            opt2.setHelp("Java source code compliance level (e.g. 21 for Java 21).");
            opt2.setStringParser((StringParser)JSAP.INTEGER_PARSER);
            opt2.setDefault("" + StandardEnvironment.DEFAULT_CODE_COMPLIANCE_LEVEL);
            jsap.registerParameter((Parameter)opt2);
            opt2 = new FlaggedOption("encoding");
            opt2.setLongFlag("encoding");
            opt2.setStringParser((StringParser)JSAP.STRING_PARSER);
            opt2.setRequired(false);
            opt2.setDefault("UTF-8");
            opt2.setHelp("Forces the compiler to use a specific encoding (UTF-8, UTF-16, ...).");
            jsap.registerParameter((Parameter)opt2);
            opt2 = new FlaggedOption("input");
            opt2.setShortFlag('i');
            opt2.setLongFlag("input");
            opt2.setStringParser((StringParser)JSAP.STRING_PARSER);
            opt2.setRequired(false);
            opt2.setHelp("List of path to sources files.");
            jsap.registerParameter((Parameter)opt2);
            opt2 = new FlaggedOption("processors");
            opt2.setShortFlag('p');
            opt2.setLongFlag("processors");
            opt2.setHelp("List of processor's qualified name to be used.");
            opt2.setStringParser((StringParser)JSAP.STRING_PARSER);
            opt2.setRequired(false);
            jsap.registerParameter((Parameter)opt2);
            opt2 = new FlaggedOption("template");
            opt2.setShortFlag('t');
            opt2.setLongFlag("template");
            opt2.setHelp("List of source templates.");
            opt2.setStringParser((StringParser)JSAP.STRING_PARSER);
            opt2.setRequired(false);
            opt2.setHelp("List of path to templates java files.");
            jsap.registerParameter((Parameter)opt2);
            opt2 = new FlaggedOption("output");
            opt2.setShortFlag('o');
            opt2.setLongFlag("output");
            opt2.setDefault(OUTPUTDIR);
            opt2.setHelp("Specify where to place generated java files.");
            opt2.setStringParser((StringParser)FileStringParser.getParser());
            opt2.setRequired(false);
            jsap.registerParameter((Parameter)opt2);
            opt2 = new FlaggedOption("source-classpath");
            opt2.setLongFlag("source-classpath");
            opt2.setHelp("An optional classpath to be passed to the internal Java compiler when building or compiling the input sources.");
            opt2.setStringParser((StringParser)JSAP.STRING_PARSER);
            opt2.setRequired(false);
            jsap.registerParameter((Parameter)opt2);
            opt2 = new FlaggedOption("template-classpath");
            opt2.setLongFlag("template-classpath");
            opt2.setHelp("An optional classpath to be passed to the internal Java compiler when building the template sources.");
            opt2.setStringParser((StringParser)JSAP.STRING_PARSER);
            opt2.setRequired(false);
            jsap.registerParameter((Parameter)opt2);
            opt2 = new FlaggedOption("destination");
            opt2.setShortFlag('d');
            opt2.setLongFlag("destination");
            opt2.setDefault(SPOONED_CLASSES);
            opt2.setHelp("An optional destination directory for the generated class files.");
            opt2.setStringParser((StringParser)FileStringParser.getParser());
            opt2.setRequired(false);
            jsap.registerParameter((Parameter)opt2);
            opt2 = new FlaggedOption("output-type");
            opt2.setLongFlag(opt2.getID());
            StringBuilder msg = new StringBuilder("States how to print the processed source code: ");
            int i = 0;
            for (OutputType v : OutputType.values()) {
                msg.append(v.toString());
                if (++i == OutputType.values().length) continue;
                msg.append("|");
            }
            opt2.setStringParser((StringParser)JSAP.STRING_PARSER);
            opt2.setHelp(msg.toString());
            opt2.setDefault("classes");
            jsap.registerParameter((Parameter)opt2);
            sw1 = new Switch("compile");
            sw1.setLongFlag(sw1.getUsageName());
            sw1.setHelp("Compiles the resulting classes (after transformation) to bytecode.");
            sw1.setDefault("false");
            jsap.registerParameter((Parameter)sw1);
            sw1 = new Switch("precompile");
            sw1.setLongFlag("precompile");
            sw1.setHelp("[experimental] Enable pre-compilation of input source files before processing. The compiled classes will be added to the classpath.");
            sw1.setDefault("false");
            jsap.registerParameter((Parameter)sw1);
            sw1 = new Switch("lines");
            sw1.setLongFlag("lines");
            sw1.setHelp("Set Spoon to try to preserve the original line numbers when generating the source code (may lead to human-unfriendly formatting).");
            sw1.setDefault("false");
            jsap.registerParameter((Parameter)sw1);
            opt2 = new FlaggedOption("cpmode");
            opt2.setLongFlag(opt2.getID());
            String acceptedValues = StringUtils.join((Object[])CLASSPATH_MODE.values(), (String)"; ");
            opt2.setStringParser((StringParser)EnumeratedStringParser.getParser((String)acceptedValues));
            msg = new StringBuilder("Classpath mode to use in Spoon: " + acceptedValues);
            opt2.setHelp(msg.toString());
            opt2.setRequired(true);
            opt2.setDefault(CLASSPATH_MODE.NOCLASSPATH.name());
            jsap.registerParameter((Parameter)opt2);
            sw1 = new Switch("ignore-syntax-errors");
            sw1.setShortFlag('n');
            sw1.setLongFlag("ignore-syntax-errors");
            sw1.setHelp("If an input resource has any syntax errors, it will be removed from the compilation batch.");
            sw1.setDefault("false");
            jsap.registerParameter((Parameter)sw1);
            sw1 = new Switch("gui");
            sw1.setShortFlag('g');
            sw1.setLongFlag("gui");
            sw1.setHelp("Show spoon model after processing");
            jsap.registerParameter((Parameter)sw1);
            sw1 = new Switch("no-copy-resources");
            sw1.setShortFlag('r');
            sw1.setLongFlag("no-copy-resources");
            sw1.setHelp("Disable the copy of resources from source to destination folder.");
            sw1.setDefault("false");
            jsap.registerParameter((Parameter)sw1);
            sw1 = new Switch("enable-comments");
            sw1.setShortFlag('c');
            sw1.setLongFlag("enable-comments");
            sw1.setHelp("[DEPRECATED] Adds all code comments in the Spoon AST (Javadoc, line-based comments), rewrites them when pretty-printing. (deprecated: by default, the comments are enabled.)");
            sw1.setDefault("false");
            jsap.registerParameter((Parameter)sw1);
            sw1 = new Switch("disable-comments");
            sw1.setLongFlag("disable-comments");
            sw1.setHelp("Disable the parsing of comments in Spoon.");
            sw1.setDefault("false");
            jsap.registerParameter((Parameter)sw1);
            opt2 = new FlaggedOption("generate-files");
            opt2.setShortFlag('f');
            opt2.setLongFlag("generate-files");
            opt2.setHelp("Only generate the given fully qualified java classes (separated by ':' if multiple are given).");
            opt2.setStringParser((StringParser)JSAP.STRING_PARSER);
            opt2.setRequired(false);
            jsap.registerParameter((Parameter)opt2);
            sw1 = new Switch("disable-model-self-checks");
            sw1.setShortFlag('a');
            sw1.setLongFlag("disable-model-self-checks");
            sw1.setHelp("Disables checks made on the AST (hashcode violation, method's signature violation and parent violation). Default: false.");
            sw1.setDefault("false");
            jsap.registerParameter((Parameter)sw1);
            return jsap;
        }
        catch (JSAPException e) {
            throw new SpoonException(e.getMessage(), e);
        }
    }

    protected final JSAPResult getArguments() {
        return this.parseArgs();
    }

    protected void processArguments() {
        String outputString;
        OutputType outputType;
        this.jsapActualArgs = this.getArguments();
        Environment environment = this.factory.getEnvironment();
        environment.setComplianceLevel(this.jsapActualArgs.getInt("compliance"));
        environment.setLevel(this.jsapActualArgs.getString("level"));
        if (this.jsapActualArgs.getBoolean("imports")) {
            environment.setPrettyPrintingMode(Environment.PRETTY_PRINTING_MODE.AUTOIMPORT);
        } else {
            environment.setPrettyPrintingMode(Environment.PRETTY_PRINTING_MODE.FULLYQUALIFIED);
        }
        String cpmode = this.jsapActualArgs.getString("cpmode").toUpperCase();
        this.reportClassPathMode();
        CLASSPATH_MODE classpath_mode = CLASSPATH_MODE.valueOf(cpmode);
        switch (classpath_mode) {
            case NOCLASSPATH: {
                environment.setNoClasspath(true);
                break;
            }
            case FULLCLASSPATH: {
                environment.setNoClasspath(false);
            }
        }
        environment.setIgnoreSyntaxErrors(this.jsapActualArgs.getBoolean("ignore-syntax-errors"));
        environment.setPreserveLineNumbers(this.jsapActualArgs.getBoolean("lines"));
        environment.setTabulationSize(this.jsapActualArgs.getInt("tabsize"));
        environment.useTabulations(this.jsapActualArgs.getBoolean("tabs"));
        environment.setCopyResources(!this.jsapActualArgs.getBoolean("no-copy-resources"));
        if (this.jsapActualArgs.getBoolean("disable-comments")) {
            environment.setCommentEnabled(false);
        } else {
            environment.setCommentEnabled(true);
        }
        environment.setShouldCompile(this.jsapActualArgs.getBoolean("compile"));
        if (this.jsapActualArgs.getBoolean("disable-model-self-checks")) {
            environment.disableConsistencyChecks();
        }
        if ((outputType = OutputType.fromString(outputString = this.jsapActualArgs.getString("output-type"))) == null) {
            throw new SpoonException("Unknown output type: " + outputString);
        }
        environment.setOutputType(outputType);
        try {
            Charset charset = Charset.forName(this.jsapActualArgs.getString("encoding"));
            environment.setEncoding(charset);
        }
        catch (Exception e) {
            throw new SpoonException(e);
        }
        if (this.getArguments().getString("generate-files") != null) {
            this.setOutputFilter(this.getArguments().getString("generate-files").split(":"));
        }
        this.modelBuilder = this.createCompiler();
        if (this.getArguments().getString("input") != null) {
            for (String s : this.getArguments().getString("input").split("[" + File.pathSeparatorChar + "]")) {
                try {
                    this.modelBuilder.addInputSource(SpoonResourceHelper.createResource(new File(s)));
                }
                catch (FileNotFoundException e) {
                    throw new SpoonException(e);
                }
            }
        }
        if (this.jsapActualArgs.getBoolean("precompile")) {
            this.modelBuilder.compile(SpoonModelBuilder.InputType.FILES);
            this.getEnvironment().setSourceClasspath(new String[]{this.getEnvironment().getBinaryOutputDirectory()});
        }
        if (this.getArguments().getFile("output") != null) {
            this.setSourceOutputDirectory(this.getArguments().getFile("output"));
        }
        if (this.getArguments().getString("template") != null) {
            for (String s : this.getArguments().getString("template").split("[" + File.pathSeparatorChar + "]")) {
                try {
                    this.modelBuilder.addTemplateSource(SpoonResourceHelper.createResource(new File(s)));
                }
                catch (FileNotFoundException e) {
                    environment.report(null, Level.ERROR, "Unable to add template file: " + e.getMessage());
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (this.getArguments().getString("processors") != null) {
            for (String processorName : this.getArguments().getString("processors").split(File.pathSeparator)) {
                this.addProcessor(processorName);
            }
        }
    }

    protected void reportClassPathMode() {
        String cpmode = this.jsapActualArgs.getString("cpmode").toUpperCase();
        this.factory.getEnvironment().report(null, Level.DEBUG, "Running in " + cpmode + " mode (doc: http://spoon.gforge.inria.fr/launcher.html).");
    }

    protected List<String> getProcessorTypes() {
        return this.processorTypes;
    }

    protected List<Processor<? extends CtElement>> getProcessors() {
        return this.processors;
    }

    protected JSAPResult parseArgs() {
        if (jsapSpec == null) {
            throw new IllegalStateException("no args, please call setArgs before");
        }
        JSAPResult arguments = jsapSpec.parse(this.commandLineArgs);
        if (!arguments.success()) {
            Iterator errs = arguments.getErrorMessageIterator();
            while (errs.hasNext()) {
                System.err.println("Error: " + errs.next());
            }
        }
        if (!arguments.success() || arguments.getBoolean("help")) {
            System.err.println(this.getVersionMessage());
            System.err.println("Usage: java <launcher name> [option(s)]");
            System.err.println();
            System.err.println("Options : ");
            System.err.println();
            System.err.println(jsapSpec.getHelp());
            System.exit(-1);
        }
        return arguments;
    }

    public SpoonModelBuilder createCompiler(Factory factory) {
        SpoonModelBuilder comp = this.getCompilerInstance(factory);
        Environment env = this.getEnvironment();
        comp.setBinaryOutputDirectory(this.jsapActualArgs.getFile("destination"));
        if (this.jsapActualArgs.contains("source-classpath")) {
            comp.setSourceClasspath(this.jsapActualArgs.getString("source-classpath").split(System.getProperty("path.separator")));
        }
        env.debugMessage("destination: " + comp.getBinaryOutputDirectory());
        env.debugMessage("source classpath: " + Arrays.toString(comp.getSourceClasspath()));
        env.debugMessage("template classpath: " + Arrays.toString(comp.getTemplateClasspath()));
        return comp;
    }

    protected SpoonModelBuilder getCompilerInstance(Factory factory) {
        return new JDTBasedSpoonCompiler(factory);
    }

    public SpoonModelBuilder createCompiler(Factory factory, List<SpoonResource> inputSources) {
        SpoonModelBuilder c = this.createCompiler(factory);
        c.addInputSources(inputSources);
        return c;
    }

    public SpoonModelBuilder createCompiler(Factory factory, List<SpoonResource> inputSources, List<SpoonResource> templateSources) {
        SpoonModelBuilder c = this.createCompiler(factory);
        c.addInputSources(inputSources);
        c.addTemplateSources(templateSources);
        return c;
    }

    @Override
    public SpoonModelBuilder createCompiler() {
        return this.createCompiler(this.factory);
    }

    public SpoonModelBuilder createCompiler(List<SpoonResource> inputSources) {
        SpoonModelBuilder c = this.createCompiler(this.factory);
        c.addInputSources(inputSources);
        return c;
    }

    @Override
    public Factory createFactory() {
        return new FactoryImpl(new DefaultCoreFactory(), this.createEnvironment());
    }

    @Override
    public Factory getFactory() {
        return this.factory;
    }

    @Override
    public Environment createEnvironment() {
        return new StandardEnvironment();
    }

    public JavaOutputProcessor createOutputWriter() {
        JavaOutputProcessor outputProcessor = new JavaOutputProcessor();
        outputProcessor.setFactory(this.getFactory());
        return outputProcessor;
    }

    public PrettyPrinter createPrettyPrinter() {
        return this.getEnvironment().createPrettyPrinter();
    }

    @Override
    public void run() {
        Environment env = this.modelBuilder.getFactory().getEnvironment();
        env.debugMessage(this.getVersionMessage());
        env.reportProgressMessage("Running Spoon...");
        env.debugMessage("Start processing...");
        long tstart = System.currentTimeMillis();
        this.buildModel();
        this.process();
        this.prettyprint();
        if (env.shouldCompile()) {
            this.modelBuilder.compile(SpoonModelBuilder.InputType.CTTYPES);
        }
        long t = System.currentTimeMillis();
        env.debugMessage("Program spooning done in " + (t - tstart) + " ms");
        env.reportEnd();
    }

    private String getVersionMessage() {
        return "Spoon version " + ResourceBundle.getBundle("spoon").getString("application.version");
    }

    @Override
    public CtModel buildModel() {
        long tstart = System.currentTimeMillis();
        this.modelBuilder.build();
        this.getEnvironment().debugMessage("model built in " + (System.currentTimeMillis() - tstart));
        return this.modelBuilder.getFactory().getModel();
    }

    @Override
    public void process() {
        long tstart = System.currentTimeMillis();
        this.modelBuilder.instantiateAndProcess(this.getProcessorTypes());
        this.modelBuilder.process(this.getProcessors());
        this.getEnvironment().debugMessage("model processed in " + (System.currentTimeMillis() - tstart) + " ms");
    }

    @Override
    public void prettyprint() {
        long tstart = System.currentTimeMillis();
        try {
            this.modelBuilder.generateProcessedSourceFiles(this.getEnvironment().getOutputType(), this.typeFilter);
        }
        catch (RuntimeException e) {
            if (!(e instanceof SpoonException)) {
                throw new SpoonException(e);
            }
            throw e;
        }
        Path outputPath = this.getEnvironment().getDefaultFileGenerator().getOutputDirectory().toPath();
        if (!this.getEnvironment().getOutputType().equals((Object)OutputType.NO_OUTPUT) && this.getEnvironment().isCopyResources()) {
            for (File dirInputSource : this.modelBuilder.getInputSources()) {
                if (!dirInputSource.isDirectory()) continue;
                Path dirInputSourceAsPath = dirInputSource.toPath();
                Collection resources = FileUtils.listFiles((File)dirInputSource, (IOFileFilter)RESOURCES_FILE_FILTER, (IOFileFilter)ALL_DIR_FILTER);
                for (File resource : resources) {
                    Path resourcePath = resource.toPath();
                    Path relativePath = dirInputSourceAsPath.relativize(resourcePath);
                    Path targetPath = outputPath.resolve(relativePath).getParent();
                    try {
                        FileUtils.copyFileToDirectory((File)resource, (File)targetPath.toFile());
                    }
                    catch (IOException e) {
                        throw new SpoonException(e);
                    }
                }
            }
        }
        this.getEnvironment().debugMessage("pretty-printed in " + (System.currentTimeMillis() - tstart) + " ms");
    }

    public SpoonModelBuilder getModelBuilder() {
        return this.modelBuilder;
    }

    @Override
    public void setSourceOutputDirectory(String path) {
        this.setSourceOutputDirectory(new File(path));
    }

    @Override
    public void setSourceOutputDirectory(File outputDirectory) {
        this.getEnvironment().setSourceOutputDirectory(outputDirectory);
        this.getEnvironment().setDefaultFileGenerator(this.createOutputWriter());
    }

    @Override
    public void setOutputFilter(Filter<CtType<?>> typeFilter) {
        this.typeFilter = typeFilter;
    }

    @Override
    public void setOutputFilter(final String ... qualifedNames) {
        this.setOutputFilter(new AbstractFilter<CtType<?>>(CtType.class){

            @Override
            public boolean matches(CtType<?> element) {
                for (String generateFile : qualifedNames) {
                    if (!generateFile.equals(element.getQualifiedName())) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public void setBinaryOutputDirectory(String path) {
        this.getFactory().getEnvironment().setBinaryOutputDirectory(path);
    }

    @Override
    public void setBinaryOutputDirectory(File outputDirectory) {
        this.setBinaryOutputDirectory(outputDirectory.getPath());
    }

    @Override
    public CtModel getModel() {
        return this.factory.getModel();
    }

    public static CtClass<?> parseClass(String code) {
        Launcher launcher = new Launcher();
        launcher.addInputResource(new VirtualFile(code));
        launcher.getEnvironment().setNoClasspath(true);
        launcher.getEnvironment().setAutoImports(true);
        Collection<CtType<?>> allTypes = launcher.buildModel().getAllTypes();
        if (allTypes.size() != 1) {
            throw new SpoonException("parseClass only considers one class. Please consider using a Launcher object for more advanced usage.");
        }
        try {
            return (CtClass)allTypes.stream().findFirst().get();
        }
        catch (ClassCastException e) {
            throw new SpoonException("parseClass only considers classes (and not interfaces and enums). Please consider using a Launcher object for more advanced usage.");
        }
    }

    static {
        if (System.getProperty("spoon.log.path") == null) {
            System.setProperty("spoon.log.path", "${java.io.tmpdir}/spoon-log.log");
        }
        jsapSpec = Launcher.defineArgs();
        LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        RESOURCES_FILE_FILTER = new IOFileFilter(){

            public boolean accept(File file) {
                return !file.getName().endsWith(".java");
            }

            public boolean accept(File file, String s) {
                return false;
            }
        };
        ALL_DIR_FILTER = new IOFileFilter(){

            public boolean accept(File file) {
                return true;
            }

            public boolean accept(File file, String s) {
                return false;
            }
        };
    }

    static enum CLASSPATH_MODE {
        NOCLASSPATH,
        FULLCLASSPATH;

    }
}

