/*
 * Decompiled with CFR 0.152.
 */
package spoon;

import java.io.File;
import java.nio.charset.Charset;
import spoon.Launcher;
import spoon.SpoonAPI;
import spoon.processing.Processor;
import spoon.reflect.CtModel;
import spoon.reflect.declaration.CtElement;

public class FluentLauncher {
    private final SpoonAPI launcher;

    public FluentLauncher() {
        this.launcher = new Launcher();
    }

    public FluentLauncher(SpoonAPI launcher) {
        this.launcher = launcher;
    }

    public FluentLauncher inputResource(String path) {
        this.launcher.addInputResource(path);
        return this;
    }

    public FluentLauncher inputResource(Iterable<String> paths) {
        for (String path : paths) {
            this.launcher.addInputResource(path);
        }
        return this;
    }

    public <T extends CtElement> FluentLauncher processor(Processor<T> processor) {
        this.launcher.addProcessor(processor);
        return this;
    }

    public <T extends CtElement> FluentLauncher processor(Iterable<Processor<T>> processors) {
        for (Processor<T> processor : processors) {
            this.launcher.addProcessor(processor);
        }
        return this;
    }

    public CtModel buildModel() {
        this.launcher.run();
        return this.launcher.getModel();
    }

    public FluentLauncher outputDirectory(String path) {
        this.launcher.setSourceOutputDirectory(path);
        return this;
    }

    public FluentLauncher outputDirectory(File outputDirectory) {
        this.launcher.setSourceOutputDirectory(outputDirectory);
        return this;
    }

    public FluentLauncher autoImports(boolean autoImports) {
        this.launcher.getEnvironment().setAutoImports(autoImports);
        return this;
    }

    public FluentLauncher disableConsistencyChecks() {
        this.launcher.getEnvironment().disableConsistencyChecks();
        return this;
    }

    public FluentLauncher complianceLevel(int level) {
        this.launcher.getEnvironment().setComplianceLevel(level);
        return this;
    }

    public FluentLauncher sourceClassPath(String[] sourceClasspath) {
        this.launcher.getEnvironment().setSourceClasspath(sourceClasspath);
        return this;
    }

    public FluentLauncher noClasspath(boolean option) {
        this.launcher.getEnvironment().setNoClasspath(option);
        return this;
    }

    public FluentLauncher encoding(Charset encoding) {
        this.launcher.getEnvironment().setEncoding(encoding);
        return this;
    }
}

