/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.controlflow;

import fr.inria.controlflow.ControlFlowBuilder;
import fr.inria.controlflow.ControlFlowGraph;
import fr.inria.controlflow.ControlFlowNode;
import fr.inria.controlflow.ExceptionControlFlowStrategy;
import fr.inria.controlflow.NodeKind;
import fr.inria.controlflow.UnsupportedReturnException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtResource;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtTry;
import spoon.reflect.code.CtTryWithResource;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.visitor.CtVisitor;

public class NaiveExceptionControlFlowStrategy
implements ExceptionControlFlowStrategy {
    private final Deque<List<ControlFlowNode>> catchNodeStack;
    private final EnumSet<Options> instanceOptions;
    private final Map<CtBlock<?>, ControlFlowNode> finallyStatementsWithNodes = new IdentityHashMap();

    public NaiveExceptionControlFlowStrategy() {
        this(EnumSet.noneOf(Options.class));
    }

    public NaiveExceptionControlFlowStrategy(EnumSet<Options> options) {
        this.instanceOptions = options;
        this.catchNodeStack = new ArrayDeque<List<ControlFlowNode>>();
    }

    @Override
    public void handleTryStatement(ControlFlowBuilder builder, CtTry tryBlock) {
        if (!this.instanceOptions.contains((Object)Options.RETURN_WITHOUT_FINALIZERS) && tryBlock.getFinalizer() != null) {
            for (CtElement element : tryBlock.asIterable()) {
                if (!(element instanceof CtReturn)) continue;
                throw new UnsupportedReturnException("return statements in try-(catch-)finally constructs are not supported");
            }
        }
        ControlFlowGraph graph = builder.getResult();
        ControlFlowNode lastNode = builder.getLastNode();
        ArrayList<ControlFlowNode> catchNodes = new ArrayList<ControlFlowNode>();
        ControlFlowNode tryNode = new ControlFlowNode(null, graph, NodeKind.TRY);
        ControlFlowNode convergeNode = new ControlFlowNode(null, graph, NodeKind.CONVERGE);
        for (CtCatch catchBlock : tryBlock.getCatchers()) {
            catchNodes.add(new ControlFlowNode((CtElement)catchBlock.getParameter(), graph, NodeKind.CATCH));
        }
        ControlFlowNode finallyNode = null;
        if (tryBlock.getFinalizer() != null) {
            finallyNode = new ControlFlowNode(null, graph, NodeKind.FINALLY);
            this.finallyStatementsWithNodes.put(tryBlock.getFinalizer(), finallyNode);
        }
        graph.addEdge(lastNode, tryNode);
        builder.setLastNode(tryNode);
        this.catchNodeStack.push(catchNodes);
        if (tryBlock instanceof CtTryWithResource) {
            for (CtResource res : ((CtTryWithResource)tryBlock).getResources()) {
                res.accept((CtVisitor)builder);
            }
        }
        tryBlock.getBody().accept((CtVisitor)builder);
        this.catchNodeStack.pop();
        if (builder.getLastNode() != null) {
            graph.addEdge(builder.getLastNode(), finallyNode != null ? finallyNode : convergeNode);
        }
        for (ControlFlowNode catchNode : catchNodes) {
            if (tryBlock.getBody().getStatements().isEmpty() && this.instanceOptions.contains((Object)Options.ADD_PATHS_FOR_EMPTY_TRY_BLOCKS)) {
                graph.addEdge(tryNode.next().get(0).next().get(0), catchNode);
            }
            builder.setLastNode(catchNode);
            ((CtCatch)catchNode.getStatement().getParent()).getBody().accept((CtVisitor)builder);
            lastNode = builder.getLastNode();
            if (lastNode == null) continue;
            graph.addEdge(lastNode, finallyNode != null ? finallyNode : convergeNode);
        }
        builder.setLastNode(finallyNode != null ? finallyNode : convergeNode);
        if (finallyNode != null) {
            tryBlock.getFinalizer().accept((CtVisitor)builder);
            if (builder.getLastNode() != null) {
                graph.addEdge(builder.getLastNode(), convergeNode);
            }
            builder.setLastNode(convergeNode);
        }
    }

    @Override
    public void handleThrowStatement(ControlFlowBuilder builder, CtThrow throwStatement) {
        ControlFlowGraph graph = builder.getResult();
        ControlFlowNode throwNode = new ControlFlowNode((CtElement)throwStatement, graph, NodeKind.STATEMENT);
        graph.addEdge(builder.getLastNode(), throwNode);
        builder.setLastNode(throwNode);
    }

    @Override
    public void handleStatement(ControlFlowBuilder builder, ControlFlowNode source) {
        if (this.catchNodeStack.isEmpty()) {
            return;
        }
        List<ControlFlowNode> catchNodes = this.catchNodeStack.peek();
        if (catchNodes != null) {
            ControlFlowGraph graph = builder.getResult();
            catchNodes.forEach(catchNode -> graph.addEdge(source, (ControlFlowNode)catchNode));
        }
    }

    @Override
    public void postProcess(ControlFlowGraph graph) {
        this.removeNonCatchSuccessorsFromThrowStatements(graph);
        this.removeUnreachableCatchNodes(graph);
        this.removeUnreachableFinalizerNodeBlockEndPredecessors(graph);
        this.connectThrowVertexesWithoutOutputToFinallyOrExitNode(graph);
    }

    private void removeNonCatchSuccessorsFromThrowStatements(ControlFlowGraph graph) {
        graph.findNodesOfKind(NodeKind.STATEMENT).forEach(node -> {
            if (!(node.getStatement() instanceof CtThrow)) {
                return;
            }
            if (!graph.containsVertex(node)) {
                return;
            }
            node.next().stream().filter(arg_0 -> ((ControlFlowGraph)graph).containsVertex(arg_0)).filter(x -> x.getKind() != NodeKind.CATCH).forEach(nextNode -> {
                graph.removeEdge(node, nextNode);
                this.removePathWhileUnreachable((ControlFlowNode)nextNode);
            });
        });
    }

    private void removeUnreachableCatchNodes(ControlFlowGraph graph) {
        this.nodesWithoutPredecessors(graph).stream().filter(node -> node.getKind() == NodeKind.CATCH).forEach(this::removePathWhileUnreachable);
    }

    private void removeUnreachableFinalizerNodeBlockEndPredecessors(ControlFlowGraph graph) {
        graph.findNodesOfKind(NodeKind.FINALLY).forEach(node -> node.prev().stream().filter(prevNode -> prevNode.prev().isEmpty()).forEach(arg_0 -> ((ControlFlowGraph)graph).removeVertex(arg_0)));
    }

    private void removePathWhileUnreachable(ControlFlowNode start) {
        LinkedList<ControlFlowNode> nodesToRemove = new LinkedList<ControlFlowNode>(Collections.singletonList(start));
        while (!nodesToRemove.isEmpty()) {
            ControlFlowNode node = (ControlFlowNode)nodesToRemove.removeFirst();
            if (node.getKind() == NodeKind.EXIT) continue;
            node.next().stream().filter(x -> x.prev().size() == 1).forEach(nodesToRemove::addLast);
            node.getParent().removeVertex(node);
        }
    }

    private void connectThrowVertexesWithoutOutputToFinallyOrExitNode(ControlFlowGraph graph) {
        LinkedList vertexes = new LinkedList();
        graph.vertexSet().stream().filter(vert -> vert.getStatement() instanceof CtThrow && vert.next().isEmpty()).forEach(vertexes::add);
        vertexes.forEach(vert -> {
            CtTry tryParent = (CtTry)vert.getStatement().getParent(CtTry.class);
            if (tryParent == null || tryParent.getFinalizer() == null || !this.finallyStatementsWithNodes.containsKey(tryParent.getFinalizer())) {
                graph.addEdge((ControlFlowNode)vert, graph.getExitNode());
            } else {
                graph.addEdge((ControlFlowNode)vert, this.finallyStatementsWithNodes.get(tryParent.getFinalizer()));
            }
        });
    }

    private List<ControlFlowNode> nodesWithoutPredecessors(ControlFlowGraph graph) {
        ArrayList<ControlFlowNode> result = new ArrayList<ControlFlowNode>();
        for (ControlFlowNode node : graph.vertexSet()) {
            if (!node.prev().isEmpty()) continue;
            result.add(node);
        }
        return result;
    }

    public static enum Options {
        ADD_PATHS_FOR_EMPTY_TRY_BLOCKS,
        RETURN_WITHOUT_FINALIZERS;

    }
}

