/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.controlflow;

import fr.inria.controlflow.ControlFlowEdge;
import fr.inria.controlflow.ControlFlowGraph;
import fr.inria.controlflow.ControlFlowNode;
import fr.inria.controlflow.NodeKind;
import java.util.HashMap;

public class GraphVisPrettyPrinter {
    private final ControlFlowGraph graph;

    public GraphVisPrettyPrinter(ControlFlowGraph graph) {
        this.graph = graph;
    }

    public String print() {
        StringBuilder sb = new StringBuilder("digraph ").append(this.graph.getName()).append(" { \n");
        sb.append("node [fontsize = 8];\n");
        int i = 0;
        HashMap<ControlFlowNode, Integer> nodeIds = new HashMap<ControlFlowNode, Integer>();
        for (ControlFlowNode n : this.graph.vertexSet()) {
            this.printNode(++i, n, sb);
            nodeIds.put(n, i);
        }
        for (ControlFlowEdge e : this.graph.edgeSet()) {
            if (e.isBackEdge()) {
                sb.append(nodeIds.get(e.getSourceNode())).append(" -> ").append(nodeIds.get(e.getTargetNode())).append("[style=dashed];\n ");
                continue;
            }
            sb.append(nodeIds.get(e.getSourceNode())).append(" -> ").append(nodeIds.get(e.getTargetNode())).append(" ;\n ");
        }
        sb.append("\n }");
        return sb.toString();
    }

    private String printNode(int i, ControlFlowNode n, StringBuilder sb) {
        String labelStr = " [shape=rectangle, label=\"";
        if (n.getKind() == NodeKind.BRANCH) {
            labelStr = " [shape=diamond, label=\"";
        } else if (n.getKind() == NodeKind.BEGIN) {
            labelStr = " [shape=Mdiamond, label=\"";
        } else if (n.getKind() == NodeKind.BLOCK_BEGIN || n.getKind() == NodeKind.BLOCK_END) {
            labelStr = " [shape=rectangle, style=filled, fillcolor=gray, label=\"";
        } else if (n.getKind() == NodeKind.EXIT) {
            labelStr = " [shape=doublecircle, label=\"";
        } else if (n.getKind() == NodeKind.CONVERGE) {
            labelStr = " [shape=point label=\"";
        }
        sb.append(i).append(labelStr).append(n.toString().replace("\"", "quot ")).append(" \"]").append(";\n");
        return sb.toString();
    }
}

