/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.controlflow;

import fr.inria.controlflow.ControlFlowEdge;
import fr.inria.controlflow.ControlFlowGraph;
import fr.inria.controlflow.NodeKind;
import java.util.ArrayList;
import java.util.List;
import spoon.reflect.code.CtAbstractSwitch;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtWhile;
import spoon.reflect.declaration.CtElement;

public class ControlFlowNode {
    public static int count = 0;
    private final int id;
    ControlFlowGraph parent;
    private NodeKind kind;
    private CtElement statement;
    private boolean isStatementEnd;
    Object tag;

    public NodeKind getKind() {
        return this.kind;
    }

    public void setKind(NodeKind kind) {
        this.kind = kind;
    }

    public ControlFlowNode(CtElement statement, ControlFlowGraph parent, NodeKind kind) {
        this.kind = kind;
        this.parent = parent;
        this.statement = statement;
        this.isStatementEnd = true;
        this.id = ++count;
    }

    public ControlFlowNode(CtElement statement, ControlFlowGraph parent) {
        this.parent = parent;
        this.statement = statement;
        this.isStatementEnd = true;
        this.id = ++count;
    }

    public int getId() {
        return this.id;
    }

    public List<ControlFlowNode> siblings() {
        ArrayList<ControlFlowNode> result = new ArrayList<ControlFlowNode>();
        for (ControlFlowNode n : this.prev()) {
            for (ControlFlowNode nn : n.next()) {
                if (nn.equals(this)) continue;
                result.add(nn);
            }
        }
        return result;
    }

    public List<ControlFlowNode> next() {
        ArrayList<ControlFlowNode> result = new ArrayList<ControlFlowNode>();
        for (ControlFlowEdge e : this.parent.outgoingEdgesOf(this)) {
            result.add(e.getTargetNode());
        }
        return result;
    }

    public List<ControlFlowNode> prev() {
        ArrayList<ControlFlowNode> result = new ArrayList<ControlFlowNode>();
        for (ControlFlowEdge e : this.parent.incomingEdgesOf(this)) {
            result.add(e.getSourceNode());
        }
        return result;
    }

    public CtElement getStatement() {
        return this.statement;
    }

    public void setStatement(CtElement statement) {
        this.statement = statement;
    }

    public boolean getIsStatementEnd() {
        return this.isStatementEnd;
    }

    public void setEndTo(ControlFlowNode end) {
        this.isStatementEnd = false;
        this.setTag(end);
        end.setTag(this);
        end.isStatementEnd = true;
    }

    public ControlFlowGraph getParent() {
        return this.parent;
    }

    public void setParent(ControlFlowGraph parent) {
        this.parent = parent;
    }

    public Object getTag() {
        return this.tag;
    }

    public void setTag(Object tag) {
        this.tag = tag;
    }

    public String toString() {
        if (this.statement == null) {
            return String.valueOf((Object)this.kind) + "_" + this.id;
        }
        if (this.kind == NodeKind.STATEMENT_END || !this.isStatementEnd) {
            String prefix = this.isStatementEnd && this.tag instanceof ControlFlowNode ? "END of " + ((ControlFlowNode)this.tag).id + ": " + this.id + " - " : this.id + " - ";
            if (this.statement instanceof CtAbstractSwitch) {
                return prefix + "switch (" + String.valueOf(((CtAbstractSwitch)this.statement).getSelector()) + ")";
            }
            if (this.statement instanceof CtReturn && ((CtReturn)this.statement).getReturnedExpression() instanceof CtAbstractSwitch) {
                CtAbstractSwitch switchExpression = (CtAbstractSwitch)((CtReturn)this.statement).getReturnedExpression();
                return prefix + "return switch (" + String.valueOf(switchExpression.getSelector()) + ")";
            }
            if (this.statement instanceof CtLocalVariable && ((CtLocalVariable)this.statement).getDefaultExpression() instanceof CtAbstractSwitch) {
                CtLocalVariable localVariable = (CtLocalVariable)this.statement;
                CtAbstractSwitch switchExpression = (CtAbstractSwitch)localVariable.getDefaultExpression();
                CtLocalVariable renderVariable = localVariable.clone();
                renderVariable.setDefaultExpression(null);
                return prefix + String.valueOf(renderVariable) + " = switch (" + String.valueOf(switchExpression.getSelector()) + ")";
            }
            if (this.statement instanceof CtConditional) {
                CtConditional conditional = (CtConditional)this.statement;
                return prefix + String.valueOf(conditional.getCondition()) + " ?";
            }
            if (this.statement instanceof CtIf) {
                CtIf ifStatement = (CtIf)this.statement;
                CtIf renderStatement = ifStatement.clone();
                renderStatement.setThenStatement(null);
                renderStatement.setElseStatement(null);
                return prefix + "if (" + String.valueOf(ifStatement.getCondition()) + ")";
            }
            if (this.statement instanceof CtDo && !this.isStatementEnd) {
                return prefix + "do";
            }
            if (this.statement instanceof CtDo) {
                return prefix + "while (" + String.valueOf(((CtDo)this.statement).getLoopingExpression()) + ")";
            }
            if (this.statement instanceof CtWhile) {
                CtWhile renderLoop = ((CtWhile)this.statement).clone();
                renderLoop.setBody(null);
                return prefix + String.valueOf(renderLoop);
            }
            if (this.statement instanceof CtFor) {
                CtFor renderLoop = ((CtFor)this.statement).clone();
                renderLoop.setBody(null);
                return prefix + String.valueOf(renderLoop);
            }
            return prefix + String.valueOf(this.statement);
        }
        return this.id + " - " + String.valueOf(this.statement);
    }
}

