/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.controlflow;

import fr.inria.controlflow.ControlFlowEdge;
import fr.inria.controlflow.ControlFlowNode;
import fr.inria.controlflow.GraphVisPrettyPrinter;
import fr.inria.controlflow.NodeKind;
import fr.inria.controlflow.NotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jgrapht.graph.DefaultDirectedGraph;
import spoon.reflect.declaration.CtElement;

public class ControlFlowGraph
extends DefaultDirectedGraph<ControlFlowNode, ControlFlowEdge> {
    private String name;
    private ControlFlowNode exitNode;

    public ControlFlowGraph(Class<? extends ControlFlowEdge> edgeClass) {
        super(edgeClass);
    }

    public ControlFlowGraph() {
        super(ControlFlowEdge.class);
    }

    private int countNodes(NodeKind kind) {
        int result = 0;
        for (ControlFlowNode v : this.vertexSet()) {
            if (!v.getKind().equals((Object)kind)) continue;
            ++result;
        }
        return result;
    }

    public String toGraphVisText() {
        GraphVisPrettyPrinter p = new GraphVisPrettyPrinter(this);
        return p.print();
    }

    public ControlFlowNode findNode(CtElement e) throws NotFoundException {
        if (e != null) {
            for (ControlFlowNode n : this.vertexSet()) {
                if (e != n.getStatement()) continue;
                return n;
            }
        }
        throw new NotFoundException("Element's node not found ");
    }

    public ControlFlowNode findNodeById(int id) {
        for (ControlFlowNode n : this.vertexSet()) {
            if (n.getId() != id) continue;
            return n;
        }
        return null;
    }

    public List<ControlFlowNode> findNodesOfKind(NodeKind kind) {
        ArrayList<ControlFlowNode> result = new ArrayList<ControlFlowNode>();
        for (ControlFlowNode n : this.vertexSet()) {
            if (!n.getKind().equals((Object)kind)) continue;
            result.add(n);
        }
        return result;
    }

    public ControlFlowEdge addEdge(ControlFlowNode source, ControlFlowNode target) {
        if (!this.containsVertex(source)) {
            this.addVertex(source);
        }
        if (!this.containsVertex(target)) {
            this.addVertex(target);
        }
        return (ControlFlowEdge)((Object)super.addEdge((Object)source, (Object)target));
    }

    public List<ControlFlowNode> statements() {
        return this.findNodesOfKind(NodeKind.STATEMENT);
    }

    public List<ControlFlowNode> branches() {
        return this.findNodesOfKind(NodeKind.BRANCH);
    }

    private void simplify(NodeKind kind) {
        try {
            List<ControlFlowNode> convergence = this.findNodesOfKind(kind);
            for (ControlFlowNode n : convergence) {
                Set incoming = this.incomingEdgesOf(n);
                Set outgoing = this.outgoingEdgesOf(n);
                if (incoming != null && outgoing != null) {
                    for (ControlFlowEdge in : incoming) {
                        for (ControlFlowEdge out : outgoing) {
                            ControlFlowEdge ed = this.addEdge(in.getSourceNode(), out.getTargetNode());
                            if (ed == null) continue;
                            ed.setBackEdge(out.isBackEdge() || in.isBackEdge());
                        }
                    }
                }
                for (ControlFlowEdge e : this.edgesOf(n)) {
                    this.removeEdge((Object)e);
                }
                this.removeVertex(n);
            }
        }
        catch (Exception e) {
            System.out.println(this.toGraphVisText());
            throw e;
        }
        this.exitNode = null;
    }

    public void simplifyBlockNodes() {
        this.simplify(NodeKind.BLOCK_BEGIN);
        this.simplify(NodeKind.BLOCK_END);
    }

    public void simplify() {
        this.simplifyConvergenceNodes();
        this.simplifyBlockNodes();
    }

    public void simplifyConvergenceNodes() {
        this.simplify(NodeKind.CONVERGE);
    }

    public int branchCount() {
        return this.countNodes(NodeKind.BRANCH);
    }

    public int statementCount() {
        return this.countNodes(NodeKind.STATEMENT);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ControlFlowNode getExitNode() {
        if (this.exitNode == null) {
            this.exitNode = this.findNodesOfKind(NodeKind.EXIT).get(0);
        }
        return this.exitNode;
    }
}

