/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.controlflow;

import fr.inria.controlflow.ControlFlowEdge;
import fr.inria.controlflow.ControlFlowGraph;
import fr.inria.controlflow.ControlFlowNode;
import fr.inria.controlflow.ExceptionControlFlowStrategy;
import fr.inria.controlflow.ExitControlFlowException;
import fr.inria.controlflow.NodeKind;
import fr.inria.controlflow.NotFoundException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import spoon.reflect.code.CaseKind;
import spoon.reflect.code.CtAbstractSwitch;
import spoon.reflect.code.CtAssert;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBreak;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtContinue;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtSwitchExpression;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtTry;
import spoon.reflect.code.CtTryWithResource;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtWhile;
import spoon.reflect.code.CtYieldStatement;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtAbstractVisitor;
import spoon.reflect.visitor.CtVisitor;

public class ControlFlowBuilder
extends CtAbstractVisitor {
    private final ControlFlowGraph result = new ControlFlowGraph(ControlFlowEdge.class);
    ControlFlowNode exitNode = new ControlFlowNode(null, this.result, NodeKind.EXIT);
    ControlFlowNode beginNode;
    private ControlFlowNode lastNode = this.beginNode = new ControlFlowNode(null, this.result, NodeKind.BEGIN);
    HashMap<String, CtStatement> labeledStatement = new HashMap();
    Deque<ControlFlowNode> breakingBad = new ArrayDeque<ControlFlowNode>();
    Deque<ControlFlowNode> continueBad = new ArrayDeque<ControlFlowNode>();
    ExceptionControlFlowStrategy exceptionControlFlowStrategy;

    public void setExceptionControlFlowStrategy(ExceptionControlFlowStrategy strategy) {
        this.exceptionControlFlowStrategy = strategy;
    }

    public ControlFlowNode getLastNode() {
        return this.lastNode;
    }

    public void setLastNode(ControlFlowNode node) {
        this.lastNode = node;
    }

    public ControlFlowGraph getResult() {
        return this.result;
    }

    public ControlFlowGraph build(CtElement s) {
        s.accept((CtVisitor)this);
        this.tryAddEdge(this.lastNode, this.exitNode);
        if (this.exceptionControlFlowStrategy != null) {
            this.exceptionControlFlowStrategy.postProcess(this.result);
        }
        return this.result;
    }

    private void visitConditional(CtElement parent, CtConditional<?> conditional) {
        ControlFlowNode branch = new ControlFlowNode(parent, this.result, NodeKind.BRANCH);
        this.tryAddEdge(this.lastNode, branch);
        ControlFlowNode convergenceNode = new ControlFlowNode(null, this.result, NodeKind.CONVERGE);
        this.lastNode = branch;
        if (conditional.getThenExpression() instanceof CtConditional) {
            this.visitConditional((CtElement)conditional, (CtConditional<?>)((CtConditional)conditional.getThenExpression()));
        } else {
            this.lastNode = new ControlFlowNode((CtElement)conditional.getThenExpression(), this.result, NodeKind.STATEMENT);
            this.tryAddEdge(branch, this.lastNode);
        }
        this.tryAddEdge(this.lastNode, convergenceNode);
        this.lastNode = branch;
        if (conditional.getElseExpression() instanceof CtConditional) {
            this.visitConditional((CtElement)conditional, (CtConditional<?>)((CtConditional)conditional.getElseExpression()));
        } else {
            this.lastNode = new ControlFlowNode((CtElement)conditional.getElseExpression(), this.result, NodeKind.STATEMENT);
            this.tryAddEdge(branch, this.lastNode);
        }
        this.tryAddEdge(this.lastNode, convergenceNode);
        this.lastNode = convergenceNode;
    }

    public static ControlFlowNode firstNode(ControlFlowGraph g, CtElement statement) throws NotFoundException {
        if (statement == null) {
            throw new NotFoundException("statement null");
        }
        if (statement instanceof CtFor) {
            CtFor ctFor = (CtFor)statement;
            if (!ctFor.getForInit().isEmpty()) {
                return g.findNode((CtElement)ctFor.getForInit().get(0));
            }
            return g.findNode((CtElement)ctFor.getExpression());
        }
        if (statement instanceof CtForEach) {
            return g.findNode((CtElement)((CtForEach)statement).getVariable());
        }
        if (statement instanceof CtWhile) {
            return g.findNode((CtElement)((CtWhile)statement).getLoopingExpression());
        }
        if (statement instanceof CtDo) {
            ControlFlowNode n = g.findNode((CtElement)((CtDo)statement).getLoopingExpression());
            ControlFlowNode n1 = null;
            for (ControlFlowEdge e : g.outgoingEdgesOf(n)) {
                if (!e.isBackEdge()) continue;
                n1 = e.getTargetNode();
                break;
            }
            if (n == n1 || n1 == null) {
                throw new NotFoundException("cannot find initial node of do while loop");
            }
            return n1;
        }
        if (statement instanceof CtIf) {
            return g.findNode((CtElement)((CtIf)statement).getCondition());
        }
        if (statement instanceof CtSwitch) {
            return g.findNode((CtElement)((CtSwitch)statement).getSelector());
        }
        if (statement instanceof CtBlock) {
            return g.findNode((CtElement)((CtBlock)statement).getStatement(0));
        }
        return g.findNode(statement);
    }

    private void defaultAction(NodeKind kind, CtStatement st) {
        ControlFlowNode n = new ControlFlowNode((CtElement)st, this.result, kind);
        this.tryAddEdge(this.lastNode, n);
        this.lastNode = n;
    }

    private void registerStatementLabel(CtStatement st) {
        if (st.getLabel() == null || st.getLabel().isEmpty()) {
            return;
        }
        if (!this.labeledStatement.containsKey(st.getLabel())) {
            this.labeledStatement.put(st.getLabel(), st);
        }
    }

    private void tryAddEdge(ControlFlowNode source, ControlFlowNode target) {
        this.tryAddEdge(source, target, false, false);
    }

    private void tryAddEdge(ControlFlowNode source, ControlFlowNode target, boolean isLooping, boolean breakDance) {
        boolean isContinue;
        if (source != null && source.getKind() != NodeKind.CATCH && source.getStatement() != null && this.exceptionControlFlowStrategy != null) {
            this.exceptionControlFlowStrategy.handleStatement(this, source);
        }
        boolean isBreak = source != null && source.getStatement() instanceof CtBreak;
        boolean bl = isContinue = source != null && source.getStatement() instanceof CtContinue;
        if (source != null && target != null && !this.result.containsEdge(source, target) && (isLooping || breakDance || !isBreak && !isContinue)) {
            ControlFlowEdge e = this.result.addEdge(source, target);
            e.setBackEdge(isLooping);
        }
    }

    public <T> void visitCtAssert(CtAssert<T> asserted) {
        this.defaultAction(NodeKind.STATEMENT, (CtStatement)asserted);
    }

    public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> assignement) {
        this.registerStatementLabel((CtStatement)assignement);
        if (assignement.getAssignment() instanceof CtConditional) {
            this.visitConditional((CtElement)assignement, (CtConditional<?>)((CtConditional)assignement.getAssignment()));
        } else {
            this.defaultAction(NodeKind.STATEMENT, (CtStatement)assignement);
        }
    }

    private ControlFlowNode travelStatementList(List<CtStatement> statements) {
        ControlFlowNode begin = new ControlFlowNode(null, this.result, NodeKind.BLOCK_BEGIN);
        ControlFlowNode end = new ControlFlowNode(null, this.result, NodeKind.BLOCK_END);
        this.tryAddEdge(this.lastNode, begin);
        this.lastNode = begin;
        try {
            for (CtStatement s : statements) {
                this.registerStatementLabel(s);
                s.accept((CtVisitor)this);
            }
        }
        catch (ExitControlFlowException ex) {
            this.tryAddEdge(this.lastNode, end);
            this.tryAddEdge(end, this.exitNode);
            this.lastNode = null;
            return begin;
        }
        this.tryAddEdge(this.lastNode, end);
        this.lastNode = end;
        return begin;
    }

    public <R> void visitCtBlock(CtBlock<R> block) {
        this.travelStatementList(block.getStatements());
    }

    public void visitCtBreak(CtBreak breakStatement) {
        ControlFlowNode to;
        try {
            to = ControlFlowBuilder.firstNode(this.result, (CtElement)this.labeledStatement.get(breakStatement.getTargetLabel()));
        }
        catch (NotFoundException e) {
            to = null;
        }
        if (to != null) {
            this.defaultAction(NodeKind.STATEMENT, (CtStatement)breakStatement);
            this.tryAddEdge(this.lastNode, to, true, false);
        } else if (!this.breakingBad.isEmpty()) {
            this.defaultAction(NodeKind.STATEMENT, (CtStatement)breakStatement);
            this.tryAddEdge(this.lastNode, this.breakingBad.peek(), false, true);
        }
    }

    public <T> void visitCtClass(CtClass<T> ctClass) {
        this.defaultAction(NodeKind.STATEMENT, (CtStatement)ctClass);
    }

    public <T> void visitCtConstructor(CtConstructor<T> constructor) {
        constructor.getBody().accept((CtVisitor)this);
    }

    public void visitCtContinue(CtContinue continueStatement) {
        ControlFlowNode to;
        try {
            to = ControlFlowBuilder.firstNode(this.result, (CtElement)this.labeledStatement.get(continueStatement.getTargetLabel()));
        }
        catch (NotFoundException ex) {
            to = this.continueBad.peek();
        }
        if (to != null) {
            this.defaultAction(NodeKind.STATEMENT, (CtStatement)continueStatement);
            this.tryAddEdge(this.lastNode, to, true, false);
        }
    }

    public void visitCtDo(CtDo doLoop) {
        this.registerStatementLabel((CtStatement)doLoop);
        ControlFlowNode convergenceNode = new ControlFlowNode(null, this.result, NodeKind.CONVERGE);
        this.continueBad.push(convergenceNode);
        ControlFlowNode convergenceNodeOut = new ControlFlowNode(null, this.result, NodeKind.CONVERGE);
        this.breakingBad.push(convergenceNodeOut);
        this.tryAddEdge(this.lastNode, convergenceNode);
        ControlFlowNode branch = new ControlFlowNode((CtElement)doLoop.getLoopingExpression(), this.result, NodeKind.BRANCH);
        this.tryAddEdge(branch, convergenceNode, true, false);
        this.tryAddEdge(branch, convergenceNodeOut);
        this.lastNode = convergenceNode;
        doLoop.getBody().accept((CtVisitor)this);
        this.tryAddEdge(this.lastNode, branch);
        this.lastNode = convergenceNodeOut;
        this.breakingBad.pop();
        this.continueBad.pop();
    }

    public void visitCtFor(CtFor forLoop) {
        this.registerStatementLabel((CtStatement)forLoop);
        if (forLoop.getForInit() != null) {
            if (forLoop.getForInit().size() > 1) {
                this.travelStatementList(forLoop.getForInit());
            } else if (!forLoop.getForInit().isEmpty()) {
                ((CtStatement)forLoop.getForInit().get(0)).accept((CtVisitor)this);
            }
        }
        ControlFlowNode convergence = new ControlFlowNode((CtElement)forLoop.getExpression(), this.result, NodeKind.CONVERGE);
        this.breakingBad.push(convergence);
        ControlFlowNode branch = new ControlFlowNode((CtElement)forLoop.getExpression(), this.result, NodeKind.BRANCH);
        this.tryAddEdge(this.lastNode, branch);
        this.continueBad.push(branch);
        this.lastNode = branch;
        if (forLoop.getBody() != null) {
            forLoop.getBody().accept((CtVisitor)this);
        }
        if (forLoop.getForUpdate() != null) {
            if (forLoop.getForUpdate().size() > 1) {
                this.travelStatementList(forLoop.getForUpdate());
            } else if (!forLoop.getForUpdate().isEmpty()) {
                ((CtStatement)forLoop.getForUpdate().get(0)).accept((CtVisitor)this);
            }
        }
        this.tryAddEdge(this.lastNode, branch, true, false);
        this.lastNode = convergence;
        this.tryAddEdge(branch, this.lastNode);
        this.continueBad.pop();
        this.breakingBad.pop();
    }

    public void visitCtForEach(CtForEach foreach) {
        this.registerStatementLabel((CtStatement)foreach);
        ControlFlowNode convergence = new ControlFlowNode(null, this.result, NodeKind.CONVERGE);
        this.breakingBad.push(convergence);
        ControlFlowNode init = new ControlFlowNode((CtElement)foreach.getVariable(), this.result, NodeKind.STATEMENT);
        this.tryAddEdge(this.lastNode, init);
        this.lastNode = init;
        ControlFlowNode branch = new ControlFlowNode((CtElement)foreach.getExpression(), this.result, NodeKind.BRANCH);
        this.continueBad.push(branch);
        this.tryAddEdge(this.lastNode, branch);
        this.lastNode = branch;
        if (foreach.getBody() != null) {
            foreach.getBody().accept((CtVisitor)this);
        }
        this.tryAddEdge(this.lastNode, branch, true, false);
        this.lastNode = convergence;
        this.tryAddEdge(branch, this.lastNode);
        this.breakingBad.pop();
        this.continueBad.pop();
    }

    public void visitCtIf(CtIf ifElement) {
        this.registerStatementLabel((CtStatement)ifElement);
        ControlFlowNode branch = new ControlFlowNode((CtElement)ifElement.getCondition(), this.result, NodeKind.BRANCH);
        this.tryAddEdge(this.lastNode, branch);
        ControlFlowNode convergenceNode = new ControlFlowNode(null, this.result, NodeKind.CONVERGE);
        if (ifElement.getThenStatement() != null) {
            this.lastNode = branch;
            ifElement.getThenStatement().accept((CtVisitor)this);
            this.tryAddEdge(this.lastNode, convergenceNode);
        }
        if (ifElement.getElseStatement() != null) {
            this.lastNode = branch;
            ifElement.getElseStatement().accept((CtVisitor)this);
            this.tryAddEdge(this.lastNode, convergenceNode);
        } else {
            this.tryAddEdge(branch, convergenceNode);
        }
        this.lastNode = convergenceNode;
    }

    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        if (this.isSystemExit(invocation)) {
            this.visitExitStatement((CtStatement)invocation);
            return;
        }
        this.registerStatementLabel((CtStatement)invocation);
        this.defaultAction(NodeKind.STATEMENT, (CtStatement)invocation);
    }

    private boolean isSystemExit(CtInvocation<?> invocation) {
        return "exit".equals(invocation.getExecutable().getSimpleName()) && invocation.getTarget() instanceof CtTypeAccess && "java.lang.System".equals(((CtTypeAccess)invocation.getTarget()).getAccessedType().getQualifiedName());
    }

    public <T> void visitCtLocalVariable(CtLocalVariable<T> localVariable) {
        this.registerStatementLabel((CtStatement)localVariable);
        if (localVariable.getDefaultExpression() instanceof CtConditional) {
            this.visitConditional((CtElement)localVariable, (CtConditional<?>)((CtConditional)localVariable.getDefaultExpression()));
        } else if (localVariable.getDefaultExpression() instanceof CtSwitchExpression) {
            this.handleCtAbstractSwitch((CtStatement)localVariable, (CtAbstractSwitch)((CtSwitchExpression)localVariable.getDefaultExpression()));
        } else {
            this.defaultAction(NodeKind.STATEMENT, (CtStatement)localVariable);
        }
    }

    public <T> void visitCtMethod(CtMethod<T> m) {
        if (m.getBody() == null) {
            return;
        }
        m.getBody().accept((CtVisitor)this);
    }

    public <T> void visitCtConstructorCall(CtConstructorCall<T> constructorCall) {
        this.defaultAction(NodeKind.STATEMENT, (CtStatement)constructorCall);
    }

    public <T, A extends T> void visitCtOperatorAssignment(CtOperatorAssignment<T, A> assignment) {
        this.registerStatementLabel((CtStatement)assignment);
        this.defaultAction(NodeKind.STATEMENT, (CtStatement)assignment);
    }

    public <R> void visitCtReturn(CtReturn<R> returnStatement) {
        if (returnStatement.getReturnedExpression() instanceof CtSwitchExpression) {
            this.registerStatementLabel((CtStatement)returnStatement);
            this.handleCtAbstractSwitch((CtStatement)returnStatement, (CtAbstractSwitch)((CtSwitchExpression)returnStatement.getReturnedExpression()));
        } else {
            this.visitExitStatement((CtStatement)returnStatement);
        }
    }

    private void visitExitStatement(CtStatement statement) {
        this.registerStatementLabel(statement);
        ControlFlowNode n = new ControlFlowNode((CtElement)statement, this.result, NodeKind.STATEMENT);
        this.tryAddEdge(this.lastNode, n);
        this.lastNode = n;
        throw new ExitControlFlowException();
    }

    public <S> void visitCtCase(CtCase<S> caseStatement) {
        this.registerStatementLabel((CtStatement)caseStatement);
        ControlFlowNode caseNode = new ControlFlowNode((CtElement)caseStatement.getCaseExpression(), this.result, NodeKind.STATEMENT);
        this.tryAddEdge(this.lastNode, caseNode);
        this.lastNode = caseNode;
        this.travelStatementList(caseStatement.getStatements());
    }

    public <S> void visitCtSwitch(CtSwitch<S> switchStatement) {
        this.handleCtAbstractSwitch((CtStatement)switchStatement, (CtAbstractSwitch<S>)switchStatement);
    }

    public void visitCtYieldStatement(CtYieldStatement ctYieldStatement) {
        this.defaultAction(NodeKind.STATEMENT, (CtStatement)ctYieldStatement);
    }

    public <S> void handleCtAbstractSwitch(CtStatement containingStatement, CtAbstractSwitch<S> abstractSwitch) {
        ControlFlowNode statementNode = new ControlFlowNode((CtElement)containingStatement, this.result, NodeKind.STATEMENT);
        this.tryAddEdge(this.lastNode, statementNode);
        this.lastNode = statementNode;
        ControlFlowNode switchBlockBegin = new ControlFlowNode(null, this.result, NodeKind.BLOCK_BEGIN);
        this.tryAddEdge(this.lastNode, switchBlockBegin);
        this.lastNode = switchBlockBegin;
        ControlFlowNode selectorNode = new ControlFlowNode((CtElement)abstractSwitch.getSelector(), this.result, NodeKind.BRANCH);
        this.tryAddEdge(this.lastNode, selectorNode);
        this.lastNode = selectorNode;
        ControlFlowNode convergenceNode = new ControlFlowNode(null, this.result, NodeKind.CONVERGE);
        this.breakingBad.push(convergenceNode);
        ControlFlowNode fallThroughNode = null;
        for (CtCase switchCase : abstractSwitch.getCases()) {
            ControlFlowNode caseConvergenceNode;
            boolean isEnhanced = switchCase.getCaseKind() == CaseKind.ARROW;
            this.lastNode = caseConvergenceNode = new ControlFlowNode(null, this.result, NodeKind.CONVERGE);
            this.tryAddEdge(fallThroughNode, caseConvergenceNode);
            for (CtExpression expression : switchCase.getCaseExpressions()) {
                ControlFlowNode node = new ControlFlowNode((CtElement)expression, this.result, NodeKind.EXPRESSION);
                node.setTag(switchCase.getGuard());
                this.tryAddEdge(selectorNode, node);
                this.tryAddEdge(node, caseConvergenceNode);
            }
            if (switchCase.getIncludesDefault() || switchCase.getCaseExpressions().isEmpty()) {
                this.tryAddEdge(selectorNode, caseConvergenceNode);
            }
            try {
                for (CtStatement statement : switchCase.getStatements()) {
                    this.registerStatementLabel(statement);
                    statement.accept((CtVisitor)this);
                }
            }
            catch (ExitControlFlowException ex) {
                this.tryAddEdge(this.lastNode, this.exitNode);
                this.lastNode = null;
            }
            if (this.lastNode == null || this.lastNode.getStatement() instanceof CtThrow) continue;
            if (!isEnhanced) {
                fallThroughNode = this.lastNode;
                continue;
            }
            this.tryAddEdge(this.lastNode, convergenceNode);
        }
        this.tryAddEdge(fallThroughNode, convergenceNode);
        if (!this.checkExhaustive(abstractSwitch)) {
            this.tryAddEdge(selectorNode, convergenceNode);
        }
        this.breakingBad.pop();
        ControlFlowNode switchBlockEnd = new ControlFlowNode(null, this.result, NodeKind.BLOCK_END);
        this.tryAddEdge(convergenceNode, switchBlockEnd);
        this.lastNode = switchBlockEnd;
        ControlFlowNode statementEndNode = new ControlFlowNode((CtElement)containingStatement, this.result, NodeKind.STATEMENT_END);
        statementNode.setEndTo(statementEndNode);
        this.tryAddEdge(this.lastNode, statementEndNode);
        this.lastNode = statementEndNode;
    }

    private boolean checkExhaustive(CtAbstractSwitch<?> switchElement) {
        if (switchElement instanceof CtSwitchExpression) {
            return true;
        }
        boolean hasDefault = switchElement.getCases().stream().anyMatch(cases -> cases.getIncludesDefault() || cases.getCaseExpressions().isEmpty());
        if (hasDefault) {
            return true;
        }
        if (switchElement.getSelector().getType().isEnum()) {
            Set caseExpressions = switchElement.getCases().stream().flatMap(cases -> cases.getCaseExpressions().stream()).collect(Collectors.toSet());
            CtEnum enumType = (CtEnum)switchElement.getSelector().getType().getTypeDeclaration();
            Set enumConstantNames = enumType.getEnumValues().stream().map(CtNamedElement::getSimpleName).collect(Collectors.toSet());
            Set referencedEnumConstants = caseExpressions.stream().map(expression -> ((CtFieldRead)expression).getVariable().getSimpleName()).collect(Collectors.toSet());
            return referencedEnumConstants.containsAll(enumConstantNames);
        }
        CtTypeReference selectorTypeReference = switchElement.getSelector().getType();
        return !selectorTypeReference.isPrimitive() && !selectorTypeReference.equals((Object)selectorTypeReference.getFactory().Type().createReference(String.class));
    }

    public void visitCtSynchronized(CtSynchronized synchro) {
        ControlFlowNode expressionNode = new ControlFlowNode((CtElement)synchro.getExpression(), this.result, NodeKind.STATEMENT);
        this.tryAddEdge(this.lastNode, expressionNode);
        this.lastNode = expressionNode;
        synchro.getBlock().accept((CtVisitor)this);
    }

    public void visitCtThrow(CtThrow throwStatement) {
        if (this.exceptionControlFlowStrategy != null) {
            this.exceptionControlFlowStrategy.handleThrowStatement(this, throwStatement);
        }
    }

    public void visitCtTry(CtTry tryBlock) {
        if (this.exceptionControlFlowStrategy != null) {
            this.exceptionControlFlowStrategy.handleTryStatement(this, tryBlock);
        }
    }

    public void visitCtTryWithResource(CtTryWithResource ctTryWithResource) {
        if (this.exceptionControlFlowStrategy != null) {
            this.exceptionControlFlowStrategy.handleTryStatement(this, (CtTry)ctTryWithResource);
        }
    }

    public <T> void visitCtUnaryOperator(CtUnaryOperator<T> operator) {
        this.defaultAction(NodeKind.STATEMENT, (CtStatement)operator);
    }

    public void visitCtWhile(CtWhile whileLoop) {
        this.registerStatementLabel((CtStatement)whileLoop);
        ControlFlowNode convergenceNode = new ControlFlowNode(null, this.result, NodeKind.CONVERGE);
        this.breakingBad.push(convergenceNode);
        ControlFlowNode branch = new ControlFlowNode((CtElement)whileLoop.getLoopingExpression(), this.result, NodeKind.BRANCH);
        this.continueBad.push(branch);
        this.tryAddEdge(this.lastNode, branch);
        this.tryAddEdge(branch, convergenceNode);
        this.lastNode = branch;
        if (whileLoop.getBody() != null) {
            whileLoop.getBody().accept((CtVisitor)this);
        }
        this.tryAddEdge(this.lastNode, branch, true, false);
        this.lastNode = convergenceNode;
        this.breakingBad.pop();
        this.continueBad.pop();
    }
}

