/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.controlflow;

import fr.inria.controlflow.ControlFlowBuilder;
import fr.inria.controlflow.ControlFlowEdge;
import fr.inria.controlflow.ControlFlowGraph;
import fr.inria.controlflow.ControlFlowNode;
import fr.inria.controlflow.NodeKind;
import java.util.List;
import java.util.Set;
import spoon.reflect.code.CtReturn;
import spoon.reflect.declaration.CtElement;

public class AllBranchesReturn {
    public boolean execute(CtElement element) {
        ControlFlowBuilder builder = new ControlFlowBuilder();
        ControlFlowGraph graph = builder.build(element);
        graph.simplify();
        List<ControlFlowNode> exits = graph.findNodesOfKind(NodeKind.EXIT);
        int returnCount = 0;
        int incomingCount = -1;
        for (ControlFlowNode n : exits) {
            Set edges = graph.incomingEdgesOf(n);
            incomingCount = edges.size();
            for (ControlFlowEdge in : edges) {
                if (!(in.getSourceNode().getStatement() instanceof CtReturn)) continue;
                ++returnCount;
            }
        }
        return returnCount == incomingCount || returnCount == 0;
    }
}

