/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.annotation.user.dto;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonLocation;
import com.pvsstudio.annotation.user.dto.AnnotationDTO;
import com.pvsstudio.annotation.user.dto.Locatable;
import com.pvsstudio.annotation.user.dto.ParameterDTO;
import com.pvsstudio.annotation.user.dto.constraint.MethodAttribute;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class MethodAnnotationDTO
extends AnnotationDTO {
    @JsonProperty(value="package")
    @NotBlank(message="Package name must not be empty")
    private @NotBlank(message="Package name must not be empty") String packageName;
    @JsonProperty(value="type_name")
    @NotBlank(message="Type name must not be empty")
    private @NotBlank(message="Type name must not be empty") String typeName;
    @JsonProperty(value="method_name")
    @NotBlank(message="Method name must not be empty")
    private @NotBlank(message="Method name must not be empty") String methodName;
    @JsonProperty(value="params")
    private @Nullable List<@Valid ParameterDTO> parameters;
    @JsonProperty(value="attributes")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private @NotNull List<@MethodAttribute String> attributes = List.of();
    @JsonProperty(value="returns")
    @Valid
    private Return returnDeclaration = new Return();

    public String getPackageName() {
        return this.packageName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Return getReturnDeclaration() {
        return this.returnDeclaration;
    }

    @Nullable
    public List<ParameterDTO> getParameters() {
        return this.parameters;
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setReturnDeclaration(Return returnDeclaration) {
        this.returnDeclaration = returnDeclaration;
    }

    public void setParameters(@Nullable List<ParameterDTO> parameters) {
        this.parameters = parameters;
    }

    public void setAttributes(List<String> attributes) {
        this.attributes = attributes;
    }

    public static class Return
    implements Locatable {
        @JacksonInject
        private JsonLocation annotationLocation;
        @JsonProperty(value="attributes")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private @NotNull List<@MethodAttribute String> attributes = List.of();

        public List<String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(List<String> attributes) {
            this.attributes = attributes;
        }

        @Override
        @org.jetbrains.annotations.NotNull
        public JsonLocation jsonLocation() {
            return this.annotationLocation;
        }
    }
}

