/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.annotation.user;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.TSFBuilder;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.pvsstudio.annotation.user.UserConfigurationLoader;
import com.pvsstudio.annotation.user.UserConfigurationMapper;
import com.pvsstudio.annotation.user.UserConfigurationValidator;
import com.pvsstudio.annotation.user.deserialization.SourceLocationInjector;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;

public class UserConfigurationModule
extends AbstractModule {
    protected void configure() {
        this.bind(UserConfigurationLoader.class).in(Singleton.class);
        this.bind(UserConfigurationValidator.class).in(Singleton.class);
        this.bind(UserConfigurationMapper.class).in(Singleton.class);
    }

    @Provides
    @Singleton
    @Named(value="jsonMapper")
    public ObjectMapper provideJsonMapper() {
        return this.createMapper(JsonFactory.builder());
    }

    @Provides
    @Singleton
    @Named(value="yamlMapper")
    public ObjectMapper provideYamlMapper() {
        return this.createMapper((TSFBuilder<?, ?>)YAMLFactory.builder());
    }

    @Provides
    @Singleton
    public Validator provideValidator() {
        try (ValidatorFactory validatorFactory = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory();){
            Validator validator = validatorFactory.getValidator();
            return validator;
        }
    }

    private ObjectMapper createMapper(TSFBuilder<?, ?> factoryBuilder) {
        JsonFactory factory = factoryBuilder.enable(StreamReadFeature.INCLUDE_SOURCE_IN_LOCATION).build();
        return new ObjectMapper(factory).setInjectableValues((InjectableValues)new SourceLocationInjector()).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

