/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.annotation.user;

import com.pvsstudio.annotation.FlagAnnotation;
import com.pvsstudio.annotation.builder.AnnotationBuilder;
import com.pvsstudio.annotation.builder.MethodAnnotationBuilder;
import com.pvsstudio.annotation.user.attribute.JsonAttributeMapper;
import com.pvsstudio.annotation.user.dto.AnnotationDTO;
import com.pvsstudio.annotation.user.dto.MethodAnnotationDTO;
import com.pvsstudio.annotation.user.dto.ParameterDTO;
import com.pvsstudio.annotation.user.dto.UserAnnotationConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class UserConfigurationMapper {
    public List<AnnotationBuilder<?, ?>> map(UserAnnotationConfiguration configuration) {
        ArrayList annotations = new ArrayList();
        for (AnnotationDTO annotation : configuration.getAnnotations()) {
            if (!(annotation instanceof MethodAnnotationDTO)) continue;
            MethodAnnotationDTO methodAnnotation = (MethodAnnotationDTO)annotation;
            String qualifiedTypeName = methodAnnotation.getPackageName() + "." + methodAnnotation.getTypeName();
            List<ParameterDTO> parameters = methodAnnotation.getParameters();
            List returnFlags = methodAnnotation.getReturnDeclaration().getAttributes().stream().filter(JsonAttributeMapper::isMethodAttribute).map(JsonAttributeMapper::of).collect(Collectors.toList());
            List<FlagAnnotation> flags = methodAnnotation.getAttributes().stream().filter(JsonAttributeMapper::isMethodAttribute).map(JsonAttributeMapper::of).collect(Collectors.toList());
            flags.addAll(returnFlags);
            MethodAnnotationBuilder builder = AnnotationBuilder.ofClass(qualifiedTypeName).ofMethod(methodAnnotation.getMethodName());
            if (parameters == null) {
                builder = builder.anyParameters();
            } else if (parameters.isEmpty()) {
                builder = builder.parameters(new String[0]);
            } else {
                List<String> parametersName = parameters.stream().map((? super T parameter) -> Stream.of(parameter.getPackageName(), parameter.getTypeName()).filter(StringUtils::isNotBlank).collect(Collectors.joining("."))).collect(Collectors.toList());
                builder = builder.parameters(parametersName.toArray(new String[0]));
            }
            Collection matcher = ((MethodAnnotationBuilder)builder.flags(flags)).finish();
            annotations.addAll(matcher);
        }
        return annotations;
    }
}

