/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.annotation.user;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.pvsstudio.annotation.user.dto.UserAnnotationConfiguration;
import java.io.IOException;
import java.nio.file.Path;

public class UserConfigurationLoader {
    private final ObjectMapper jsonMapper;
    private final ObjectMapper yamlMapper;

    @Inject
    public UserConfigurationLoader(@Named(value="jsonMapper") ObjectMapper jsonMapper, @Named(value="yamlMapper") ObjectMapper yamlMapper) {
        this.jsonMapper = jsonMapper;
        this.yamlMapper = yamlMapper;
    }

    public UserAnnotationConfiguration load(Path filePath) throws IOException {
        String fileName = filePath.getFileName().toString();
        if (fileName.endsWith(".json")) {
            return (UserAnnotationConfiguration)this.jsonMapper.readValue(filePath.toFile(), UserAnnotationConfiguration.class);
        }
        if (fileName.endsWith(".yml") || fileName.endsWith(".yaml")) {
            return (UserAnnotationConfiguration)this.yamlMapper.readValue(filePath.toFile(), UserAnnotationConfiguration.class);
        }
        throw new IllegalArgumentException("Unsupported configuration file extension: " + String.valueOf(filePath.getFileName()));
    }
}

